/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.google.gwt.resources.client.ImageResource;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.gwtbootstrap3.client.ui.Button;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.docks.view.items.SouthDockItem;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class SouthDockItemTest {
    @Mock
    private ImageResource imageResource;
    @Mock
    private ImageResource imageResourceFocused;
    @Mock
    private PlaceRequest placeRequest;
    private ParameterizedCommand<String> emptyCommand;
    private UberfireDock dockWithFontIcon;
    private UberfireDock dockWithImageIcon;
    private SouthDockItem southDockWithFontIcon;
    private SouthDockItem southDockWithImageIcon;

    @Before
    public void setup() {
        this.dockWithFontIcon = new UberfireDock(UberfireDockPosition.EAST, "BRIEFCASE", this.placeRequest, "").withSize(450.0).withLabel("dock");
        this.dockWithImageIcon = new UberfireDock(UberfireDockPosition.EAST, this.imageResource, this.imageResourceFocused, this.placeRequest, "").withSize(450.0).withLabel("dock");
        this.southDockWithFontIcon = (SouthDockItem)Mockito.spy((Object)new SouthDockItem(this.dockWithFontIcon, this.emptyCommand, this.emptyCommand));
        this.southDockWithImageIcon = (SouthDockItem)Mockito.spy((Object)new SouthDockItem(this.dockWithImageIcon, this.emptyCommand, this.emptyCommand));
        this.emptyCommand = parameter -> {};
    }

    @Test
    public void createSouthDockItemWithFontIconTest() {
        this.southDockWithFontIcon.createButton();
        InOrder ordenatedVerification = Mockito.inOrder((Object[])new Object[]{this.southDockWithFontIcon});
        ((SouthDockItem)ordenatedVerification.verify((Object)this.southDockWithFontIcon)).configureText((Button)Mockito.any(Button.class), Mockito.anyString());
        ((SouthDockItem)ordenatedVerification.verify((Object)this.southDockWithFontIcon)).configureIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)null));
        ((SouthDockItem)ordenatedVerification.verify((Object)this.southDockWithFontIcon, Mockito.never())).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.any(ImageResource.class));
    }

    @Test
    public void selectSouthDockItemWithFontIconTest() {
        this.southDockWithFontIcon.open();
        ((SouthDockItem)Mockito.verify((Object)this.southDockWithFontIcon, (VerificationMode)Mockito.never())).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.any(ImageResource.class));
    }

    @Test
    public void closeSouthDockItemWithFontIconTest() {
        this.southDockWithFontIcon.close();
        ((SouthDockItem)Mockito.verify((Object)this.southDockWithFontIcon, (VerificationMode)Mockito.never())).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.any(ImageResource.class));
    }

    @Test
    public void createSouthDockItemWithImageIconTest() {
        this.southDockWithImageIcon.createButton();
        ((SouthDockItem)Mockito.verify((Object)this.southDockWithImageIcon)).configureIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResource));
        ((SouthDockItem)Mockito.verify((Object)this.southDockWithImageIcon)).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResource));
    }

    @Test
    public void openSouthDockItemWithImageIconTest() {
        this.southDockWithImageIcon.open();
        ((SouthDockItem)Mockito.verify((Object)this.southDockWithImageIcon)).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResourceFocused));
    }

    @Test
    public void closeSouthDockItemWithImageIconTest() {
        this.southDockWithImageIcon.close();
        ((SouthDockItem)Mockito.verify((Object)this.southDockWithImageIcon)).configureImageIcon((Button)Mockito.any(Button.class), (ImageResource)Mockito.eq((Object)this.imageResource));
    }
}

