/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.docks.view.DocksBar;
import org.uberfire.client.docks.view.DocksBars;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockContainerReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDockReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class UberfireDocksImpl
implements UberfireDocks {
    final Map<String, List<UberfireDock>> docksPerPerspective = new HashMap<String, List<UberfireDock>>();
    final Map<String, List<Command>> delayedCommandsPerPerspective = new HashMap<String, List<Command>>();
    final Map<String, Set<UberfireDockPosition>> disableDocksPerPerspective = new HashMap<String, Set<UberfireDockPosition>>();
    String currentPerspective;
    private DocksBars docksBars;
    private Event<UberfireDockReadyEvent> dockReadyEvent;

    @Inject
    public UberfireDocksImpl(DocksBars docksBars, Event<UberfireDockReadyEvent> dockReadyEvent) {
        this.docksBars = docksBars;
        this.dockReadyEvent = dockReadyEvent;
    }

    protected void setup(@Observes UberfireDockContainerReadyEvent event) {
        this.docksBars.setup();
    }

    public void add(UberfireDock ... docks) {
        for (UberfireDock dock : docks) {
            if (dock.getAssociatedPerspective() == null) continue;
            List<UberfireDock> uberfireDocks = this.docksPerPerspective.get(dock.getAssociatedPerspective());
            if (uberfireDocks == null) {
                uberfireDocks = new ArrayList<UberfireDock>();
            }
            uberfireDocks.add(dock);
            this.docksPerPerspective.put(dock.getAssociatedPerspective(), uberfireDocks);
        }
        this.clearAndCollapseDocks(docks);
    }

    public void perspectiveChangeEvent(@Observes PerspectiveChange perspectiveChange) {
        this.currentPerspective = perspectiveChange.getIdentifier();
        this.updateAllDocks();
        this.executeDelayedCommands(perspectiveChange.getIdentifier());
        this.fireDockReadyEvent();
    }

    private void fireDockReadyEvent() {
        this.dockReadyEvent.fire((Object)new UberfireDockReadyEvent(this.currentPerspective));
    }

    private void executeDelayedCommands(String perspective) {
        List<Command> commands = this.delayedCommandsPerPerspective.get(perspective);
        if (commands != null) {
            commands.forEach(c -> c.execute());
            this.delayedCommandsPerPerspective.remove(perspective);
        }
    }

    public void remove(UberfireDock ... docks) {
        for (UberfireDock dock : docks) {
            if (dock.getAssociatedPerspective() == null) continue;
            List<UberfireDock> uberfireDocks = this.docksPerPerspective.get(dock.getAssociatedPerspective());
            uberfireDocks.remove(dock);
            this.docksPerPerspective.put(dock.getAssociatedPerspective(), uberfireDocks);
        }
        this.clearAndCollapseDocks(docks);
    }

    public void open(UberfireDock dock) {
        this.executeOnDocks(dock.getAssociatedPerspective(), dock.getDockPosition(), () -> this.docksBars.open(dock));
    }

    private void executeOnDocks(String perspective, UberfireDockPosition position, Command open) {
        if (this.isCurrentPerspective(perspective) && this.docksBars.isReady(position)) {
            open.execute();
        } else {
            this.addDelayedCommand(perspective, open);
        }
    }

    private boolean isCurrentPerspective(String perspective) {
        return perspective == this.currentPerspective;
    }

    private void addDelayedCommand(String perspective, Command delayedCommand) {
        List<Command> commands = this.delayedCommandsPerPerspective.get(perspective);
        if (commands == null) {
            commands = new ArrayList<Command>();
        }
        commands.add(delayedCommand);
        this.delayedCommandsPerPerspective.put(perspective, commands);
    }

    public void close(UberfireDock dock) {
        this.executeOnDocks(dock.getAssociatedPerspective(), dock.getDockPosition(), () -> this.docksBars.close(dock));
    }

    public void toggle(UberfireDock dock) {
        this.executeOnDocks(dock.getAssociatedPerspective(), dock.getDockPosition(), () -> this.docksBars.toggle(dock));
    }

    public void hide(UberfireDockPosition position, String perspectiveName) {
        this.addToDisableDocksList(position, perspectiveName);
        this.executeOnDocks(perspectiveName, position, () -> this.docksBars.clearAndHide(position));
    }

    public void show(UberfireDockPosition position, String perspectiveName) {
        this.removeFromDisableDocksList(position, perspectiveName);
        this.executeOnDocks(perspectiveName, position, () -> this.showDock(position));
    }

    private void showDock(UberfireDockPosition position) {
        List<UberfireDock> docks;
        this.docksBars.clearAndHide(position);
        if (this.currentPerspective != null && (docks = this.docksPerPerspective.get(this.currentPerspective)) != null && !docks.isEmpty()) {
            for (UberfireDock dock : docks) {
                if (!dock.getDockPosition().equals((Object)position)) continue;
                this.docksBars.addDock(dock);
            }
            this.docksBars.show(position);
        }
    }

    private void clearAndCollapseDocks(UberfireDock ... docks) {
        if (docks != null) {
            ArrayList<UberfireDockPosition> processedPositions = new ArrayList<UberfireDockPosition>();
            for (UberfireDock dock : docks) {
                if (processedPositions.contains(dock.getDockPosition())) continue;
                processedPositions.add(dock.getDockPosition());
                if (!this.docksBars.isReady(dock.getDockPosition())) continue;
                this.docksBars.clearAndCollapseDocks(dock.getDockPosition());
            }
        }
    }

    private void updateAllDocks() {
        List<UberfireDock> activeDocks;
        this.docksBars.clearAndHideAllDocks();
        if (this.currentPerspective != null && (activeDocks = this.docksPerPerspective.get(this.currentPerspective)) != null && !activeDocks.isEmpty()) {
            activeDocks.forEach(activeDock -> this.docksBars.addDock((UberfireDock)activeDock));
            this.expandAllAvailableDocks();
        }
    }

    private void expandAllAvailableDocks() {
        for (DocksBar docksBar : this.docksBars.getDocksBars()) {
            if (!this.dockIsEnable(docksBar.getPosition())) continue;
            this.docksBars.show(docksBar);
        }
    }

    private void addToDisableDocksList(UberfireDockPosition position, String perspectiveName) {
        Set<UberfireDockPosition> disableDocks = this.disableDocksPerPerspective.get(perspectiveName);
        if (disableDocks == null) {
            disableDocks = new HashSet<UberfireDockPosition>();
            this.disableDocksPerPerspective.put(perspectiveName, disableDocks);
        }
        disableDocks.add(position);
    }

    private void removeFromDisableDocksList(UberfireDockPosition position, String perspectiveName) {
        Set<UberfireDockPosition> disableDocks = this.disableDocksPerPerspective.get(perspectiveName);
        if (disableDocks != null) {
            disableDocks.remove(position);
        }
    }

    private boolean dockIsEnable(UberfireDockPosition dockPosition) {
        Set<UberfireDockPosition> uberfireDockPositions = this.disableDocksPerPerspective.get(this.currentPerspective);
        return uberfireDockPositions == null || !uberfireDockPositions.contains(dockPosition);
    }
}

