/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.service.backend.test;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.uberfire.ssh.service.backend.keystore.impl.util.SerializingUtils;
import org.uberfire.ssh.service.backend.keystore.model.KeyMetaData;
import org.uberfire.ssh.service.backend.keystore.model.SSHPublicKey;
import org.uberfire.ssh.service.backend.keystore.util.PublicKeyConverter;

public class SSHKeyStoreTestUtils {
    public static final String KEY_NAME = "key name 1";
    public static final String SAMPLE_ID = "1234567890";
    public static final String KEY_FILE = "/pkeys/key.txt";
    public static final String META_FILE = "/pkeys/meta.txt";
    public static final String RESOURCES_FOLDER = "src/test/resources/";
    public static final String CUSTOM_FOLDER = "custom_security/pkeys";
    public static final String DEFAULT_FOLDER = ".security/pkeys";
    public static final String KATY = "katy";
    public static final String JOHN = "john";
    public static final String ADMIN = "admin";
    private static String userDir;

    public static void setupUserDir() {
        userDir = System.getProperty("user.dir");
        if (!userDir.endsWith("/")) {
            userDir = userDir + "/";
        }
        System.setProperty("user.dir", userDir + RESOURCES_FOLDER);
    }

    public static void clearAdminKeysFolder() {
        String userDir = System.getProperty("user.dir");
        FileUtils.deleteQuietly((File)Paths.get(userDir + CUSTOM_FOLDER, new String[0]).resolve(ADMIN).toFile());
        FileUtils.deleteQuietly((File)Paths.get(userDir + DEFAULT_FOLDER, new String[0]).resolve(ADMIN).toFile());
    }

    public static SSHPublicKey readSampleSSHPublicKey() throws Exception {
        KeyMetaData metaData = SerializingUtils.readMetaData((String)IOUtils.toString((URL)SSHKeyStoreTestUtils.class.getResource(META_FILE), (Charset)Charset.defaultCharset()));
        return new SSHPublicKey(SAMPLE_ID, PublicKeyConverter.fromString((String)SSHKeyStoreTestUtils.readSampleSSHKey()), metaData);
    }

    public static String readSampleSSHKey() throws IOException {
        return IOUtils.toString((URL)SSHKeyStoreTestUtils.class.getResource(KEY_FILE), (Charset)Charset.defaultCharset());
    }

    public static void resetUserDir() {
        if (userDir != null) {
            System.setProperty("user.dir", userDir);
        }
    }
}

