/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.service.backend.keystore.impl.storage;

import java.util.Date;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ssh.service.backend.keystore.impl.storage.DefaultSSHKeyStore;
import org.uberfire.ssh.service.backend.keystore.model.SSHPublicKey;
import org.uberfire.ssh.service.backend.test.SSHKeyStoreTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultSSHKeyStoreTest {
    private DefaultSSHKeyStore store;

    @BeforeClass
    public static void init() {
        SSHKeyStoreTestUtils.setupUserDir();
    }

    @Test
    public void testLoadKeysDefaultFolder() {
        this.loadKeys();
    }

    @Test
    public void testLoadKeysCustomFolder() {
        String userDir = System.getProperty("user.dir");
        if (!userDir.endsWith("/")) {
            userDir = userDir + "/";
        }
        System.setProperty("appformer.ssh.keys.storage.folder", userDir + "custom_security/pkeys");
        this.loadKeys();
    }

    @Test
    public void testHandleUserKeysDefaultFolder() throws Exception {
        this.testLoadKeysDefaultFolder();
        this.handleUserKeys();
    }

    @Test
    public void testHandleUserKeysCustomFolder() throws Exception {
        this.testLoadKeysCustomFolder();
        this.handleUserKeys();
    }

    private void handleUserKeys() throws Exception {
        SSHPublicKey key = SSHKeyStoreTestUtils.readSampleSSHPublicKey();
        this.store.addUserKey("admin", key);
        ((IterableAssert)Assertions.assertThat((Iterable)this.store.getUserKeys("admin")).isNotNull()).hasSize(1);
        key = SSHKeyStoreTestUtils.readSampleSSHPublicKey();
        Date date = new Date();
        key.getMetaData().setLastTimeUsed(date);
        this.store.updateUserKey("admin", key);
        Optional optional = this.store.getUserKeyStore("admin").getKeyById("1234567890");
        Assert.assertTrue((boolean)optional.isPresent());
        ((ObjectAssert)Assertions.assertThat((Object)((SSHPublicKey)optional.get()).getMetaData()).isNotNull()).hasFieldOrPropertyWithValue("lastTimeUsed", (Object)date);
        this.store.removeUserKey("admin", key);
        ((IterableAssert)Assertions.assertThat((Iterable)this.store.getUserKeys("admin")).isNotNull()).hasSize(0);
    }

    private void loadKeys() {
        this.store = new DefaultSSHKeyStore();
        this.store.init();
        ((IterableAssert)Assertions.assertThat((Iterable)this.store.getUserKeys("katy")).isNotNull()).hasSize(2);
        ((IterableAssert)Assertions.assertThat((Iterable)this.store.getUserKeys("john")).isNotNull()).hasSize(1);
        ((IterableAssert)Assertions.assertThat((Iterable)this.store.getUserKeys("admin")).isNotNull()).hasSize(0);
    }

    @AfterClass
    public static void clean() {
        SSHKeyStoreTestUtils.cleanResourceKeysFolder();
        SSHKeyStoreTestUtils.resetUserDir();
    }
}

