/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.service.backend.keystore.impl;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ssh.service.backend.keystore.SSHKeyStore;
import org.uberfire.ssh.service.backend.keystore.impl.storage.DefaultSSHKeyStore;
import org.uberfire.ssh.service.backend.test.AbstractSSHKeyStoreServiceImplTest;
import org.uberfire.ssh.service.backend.test.SSHKeyStoreTestUtils;
import org.uberfire.ssh.service.backend.test.TestSSHKeyStore;

@RunWith(value=MockitoJUnitRunner.class)
public class SSHKeyStoreServiceImplTest
extends AbstractSSHKeyStoreServiceImplTest {
    @BeforeClass
    public static void init() {
        SSHKeyStoreTestUtils.setupUserDir();
    }

    @Test
    public void testLoadDefaultSSHKeyStore() {
        System.clearProperty("appformer.ssh.keystore");
        this.runTest(DefaultSSHKeyStore.class);
    }

    @Test
    public void testLoadDefaultSSHKeyStoreUnsatisfied() {
        Mockito.when((Object)this.keyStoreInstance.isUnsatisfied()).thenReturn((Object)true);
        System.clearProperty("appformer.ssh.keystore");
        this.runTest(DefaultSSHKeyStore.class);
    }

    @Test
    public void testCustomSSHKeyStore() {
        System.setProperty("appformer.ssh.keystore", TestSSHKeyStore.class.getName());
        this.runTest(TestSSHKeyStore.class);
    }

    @Test
    public void testWrongCustomSSHKeyStore() {
        System.setProperty("appformer.ssh.keystore", "wrong class name");
        this.runTest(DefaultSSHKeyStore.class);
    }

    private void runTest(Class<? extends SSHKeyStore> expectedKeystore) {
        this.initService();
        SSHKeyStore store = this.keyStoreService.keyStore();
        ((ObjectAssert)Assertions.assertThat((Object)store).isNotNull()).isInstanceOf(expectedKeystore);
        ((IterableAssert)Assertions.assertThat((Iterable)store.getUserKeys("katy")).isNotNull()).hasSize(2);
        ((IterableAssert)Assertions.assertThat((Iterable)store.getUserKeys("john")).isNotNull()).hasSize(1);
        ((IterableAssert)Assertions.assertThat((Iterable)store.getUserKeys("admin")).isNotNull()).hasSize(0);
    }

    @AfterClass
    public static void clean() {
        SSHKeyStoreTestUtils.resetUserDir();
    }
}

