/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.service.backend.auth.impl;

import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.inject.Instance;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.security.WorkbenchUserManager;
import org.uberfire.ssh.service.backend.auth.impl.SSHKeyAuthenticatorImpl;
import org.uberfire.ssh.service.backend.auth.impl.SSHUser;
import org.uberfire.ssh.service.backend.keystore.SSHKeyStoreService;
import org.uberfire.ssh.service.backend.keystore.model.SSHPublicKey;
import org.uberfire.ssh.service.backend.keystore.util.PublicKeyConverter;
import org.uberfire.ssh.service.backend.test.AbstractSSHKeyStoreServiceImplTest;
import org.uberfire.ssh.service.backend.test.SSHKeyStoreTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class SSHKeyAuthenticatorImplTest
extends AbstractSSHKeyStoreServiceImplTest {
    private List<String> validUsers;
    @Mock
    private Instance<WorkbenchUserManager> workbenchUserManagerInstance;
    @Mock
    private WorkbenchUserManager userManagerService;
    private SSHKeyAuthenticatorImpl authenticator;

    @BeforeClass
    public static void init() {
        SSHKeyStoreTestUtils.setupUserDir();
    }

    @Override
    @Before
    public void initTest() {
        super.initTest();
        this.initService();
        this.validUsers = Arrays.asList("katy", "john", "admin");
        Mockito.when((Object)this.workbenchUserManagerInstance.get()).thenReturn((Object)this.userManagerService);
        Mockito.when((Object)this.userManagerService.getUser(ArgumentMatchers.anyString())).thenAnswer(invocationOnMock -> {
            String userName = (String)invocationOnMock.getArguments()[0];
            if (this.validUsers.contains(userName)) {
                return new UserImpl(userName);
            }
            return null;
        });
    }

    @Test
    public void testAuthenticateKaty() throws Exception {
        this.testUserWithKeys("katy", false);
    }

    @Test
    public void testAuthenticateKatyWithDependencyIssues() throws Exception {
        this.testUserWithKeys("katy", true);
    }

    @Test
    public void testAuthenticateJohn() throws Exception {
        this.testUserWithKeys("john", false);
    }

    @Test
    public void testAuthenticateJohnWithDependencyIssues() throws Exception {
        this.testUserWithKeys("john", true);
    }

    @Test
    public void testAuthenticateUserWithoutKeys() throws Exception {
        this.authenticator = new SSHKeyAuthenticatorImpl((SSHKeyStoreService)this.keyStoreService, this.workbenchUserManagerInstance);
        PublicKey publicKey = PublicKeyConverter.fromString((String)SSHKeyStoreTestUtils.readSampleSSHKey());
        Assertions.assertThat((Object)this.authenticator.authenticate("admin", publicKey)).isNull();
    }

    @Test
    public void testAuthenticateNonPlatformUser() throws Exception {
        this.authenticator = new SSHKeyAuthenticatorImpl((SSHKeyStoreService)this.keyStoreService, this.workbenchUserManagerInstance);
        PublicKey publicKey = PublicKeyConverter.fromString((String)SSHKeyStoreTestUtils.readSampleSSHKey());
        Assertions.assertThat((Object)this.authenticator.authenticate("user", publicKey)).isNull();
    }

    private void testUserWithKeys(String userName, boolean dependencyIssue) throws Exception {
        Mockito.when((Object)this.workbenchUserManagerInstance.isUnsatisfied()).thenReturn((Object)dependencyIssue);
        Mockito.when((Object)this.workbenchUserManagerInstance.isAmbiguous()).thenReturn((Object)dependencyIssue);
        this.authenticator = new SSHKeyAuthenticatorImpl((SSHKeyStoreService)this.keyStoreService, this.workbenchUserManagerInstance);
        ((Instance)Mockito.verify(this.workbenchUserManagerInstance, (VerificationMode)(dependencyIssue ? Mockito.never() : Mockito.times((int)1)))).get();
        SSHPublicKey key = (SSHPublicKey)this.keyStoreService.keyStore().getUserKeys(userName).iterator().next();
        Class expectedUserType = dependencyIssue ? SSHUser.class : UserImpl.class;
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)this.authenticator.authenticate(userName, key.getKey())).isNotNull()).hasFieldOrPropertyWithValue("name", (Object)userName)).isInstanceOf(expectedUserType);
        PublicKey publicKey = PublicKeyConverter.fromString((String)SSHKeyStoreTestUtils.readSampleSSHKey());
        Assertions.assertThat((Object)this.authenticator.authenticate(userName, publicKey)).isNull();
        ((WorkbenchUserManager)Mockito.verify((Object)this.userManagerService, (VerificationMode)(dependencyIssue ? Mockito.never() : Mockito.times((int)2)))).getUser((String)ArgumentMatchers.eq((Object)userName));
    }

    @AfterClass
    public static void clean() {
        SSHKeyStoreTestUtils.cleanResourceKeysFolder();
        SSHKeyStoreTestUtils.resetUserDir();
    }
}

