/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.client.editor.component;

import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.ssh.client.editor.component.SSHKeysEditor;
import org.uberfire.ssh.client.editor.component.SSHKeysEditorView;
import org.uberfire.ssh.client.editor.component.creation.NewSSHKeyModal;
import org.uberfire.ssh.client.editor.component.creation.NewSSHKeyModalHandler;
import org.uberfire.ssh.client.editor.component.empty.SSHKeysEditorEmptyStateDisplayer;
import org.uberfire.ssh.client.editor.component.keys.SSHKeysDisplayer;
import org.uberfire.ssh.service.shared.editor.PortableSSHPublicKey;
import org.uberfire.ssh.service.shared.editor.SSHKeyEditorService;

@RunWith(value=MockitoJUnitRunner.class)
public class SSHKeysEditorTest {
    @Mock
    private SSHKeysEditorView view;
    @Mock
    private SSHKeysDisplayer keysDisplayer;
    @Mock
    private SSHKeysEditorEmptyStateDisplayer emptyStateDisplayer;
    @Mock
    private NewSSHKeyModal newSSHKeyModal;
    @Mock
    private SSHKeyEditorService service;
    private CallerMock<SSHKeyEditorService> serviceCaller;
    private SSHKeysEditor editor;

    @Before
    public void init() {
        this.serviceCaller = new CallerMock((Object)this.service);
        this.editor = (SSHKeysEditor)Mockito.spy((Object)new SSHKeysEditor(this.view, this.keysDisplayer, this.emptyStateDisplayer, this.newSSHKeyModal, this.serviceCaller));
    }

    @Test
    public void testBasicFunctionality() {
        this.editor.init();
        ((SSHKeysEditorView)Mockito.verify((Object)this.view)).init((Object)this.editor);
        ((SSHKeysDisplayer)Mockito.verify((Object)this.keysDisplayer)).init((Command)ArgumentMatchers.any(), (ParameterizedCommand)ArgumentMatchers.any());
        ((SSHKeysEditorEmptyStateDisplayer)Mockito.verify((Object)this.emptyStateDisplayer)).init((Command)ArgumentMatchers.any());
        ((NewSSHKeyModal)Mockito.verify((Object)this.newSSHKeyModal)).init((NewSSHKeyModalHandler)ArgumentMatchers.any());
        this.editor.getElement();
        ((SSHKeysEditorView)Mockito.verify((Object)this.view)).getElement();
        this.editor.clear();
        ((SSHKeysEditorView)Mockito.verify((Object)this.view)).clear();
        this.editor.showNewKeyModal();
        ((NewSSHKeyModal)Mockito.verify((Object)this.newSSHKeyModal)).show();
        this.editor.onAddKey();
        ((NewSSHKeyModal)Mockito.verify((Object)this.newSSHKeyModal)).hide();
        ((SSHKeysEditor)Mockito.verify((Object)this.editor)).load();
    }

    @Test
    public void testLoadUserKeys() {
        ArrayList<PortableSSHPublicKey> keys = new ArrayList<PortableSSHPublicKey>();
        keys.add((PortableSSHPublicKey)Mockito.mock(PortableSSHPublicKey.class));
        keys.add((PortableSSHPublicKey)Mockito.mock(PortableSSHPublicKey.class));
        keys.add((PortableSSHPublicKey)Mockito.mock(PortableSSHPublicKey.class));
        keys.add((PortableSSHPublicKey)Mockito.mock(PortableSSHPublicKey.class));
        this.loadUserKeys(keys);
    }

    @Test
    public void testLoadUsersEmptyList() {
        this.loadUserKeys(new ArrayList<PortableSSHPublicKey>());
    }

    private void loadUserKeys(List<PortableSSHPublicKey> keys) {
        Mockito.when((Object)this.service.getUserKeys()).thenReturn(keys);
        this.editor.load();
        ((SSHKeysEditorView)Mockito.verify((Object)this.view)).clear();
        ((SSHKeysEditorView)Mockito.verify((Object)this.view)).show((HTMLElement)ArgumentMatchers.any());
        if (keys.isEmpty()) {
            ((SSHKeysEditorEmptyStateDisplayer)Mockito.verify((Object)this.emptyStateDisplayer)).getElement();
        } else {
            ((SSHKeysDisplayer)Mockito.verify((Object)this.keysDisplayer)).render(keys);
            ((SSHKeysDisplayer)Mockito.verify((Object)this.keysDisplayer)).getElement();
        }
    }

    @Test
    public void testDeleteKey() {
        this.editor.delete((PortableSSHPublicKey)Mockito.mock(PortableSSHPublicKey.class));
        ((SSHKeyEditorService)Mockito.verify((Object)this.service)).deleteKey((PortableSSHPublicKey)ArgumentMatchers.any());
        ((SSHKeysEditor)Mockito.verify((Object)this.editor)).load();
    }
}

