/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.client.editor.component.creation;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.ssh.client.editor.component.creation.NewSSHKeyModal;
import org.uberfire.ssh.client.editor.component.creation.NewSSHKeyModalHandler;
import org.uberfire.ssh.client.editor.component.creation.NewSSHKeyModalView;
import org.uberfire.ssh.service.backend.keystore.util.PublicKeyConverter;
import org.uberfire.ssh.service.shared.editor.SSHKeyEditorService;

@RunWith(value=MockitoJUnitRunner.class)
public class NewSSHKeyModalTest {
    private static final String NAME = "name";
    private static final String EXISTING_KEY_NAME = "existing name";
    private static final String WRONG_KEY = "wrong key";
    private static final String WRONG_KEY_FORMAT = "ssh-rsa wrong key";
    private static final String VALID_KEY = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDNsKIMkhaI8iX69IKsux/LdgG3zP1wW5RNJzbopy7BLqZEmqTZMIfaWEisuH5WZquG3tZ//yNrVNd0Jw5RYQ/fwkyVmmJi9Ir2bo5rex4jbkNwcWb8U57UpIt38JCjjKLCkiYSKNXzrJOmtFsMOuHukoGJbSRLDV3VSmQVIbtrysz8CRCCg2bv2KZkTmKa50O4S0UpjEVeyuy/+sDqbKl9Jrhj0i7PFrB1hJhN4+7SnNDAr6OpdZd0EUUa1TNdDISsdetq9vWMnuYBQPlxHxXnJsJhvdIlLXW6ZfZpsjqxe8jfHsJtmFvD032w/B4kBfGZxQXbPoUUBdrGyrKb2FyAypdDxAotA1Rlsq3S6PWBlp7RjpMYWZb02XqNrN6g6AJCh0uuWCK/jxO6S96MYFyJj7rqUgaRg7SEKwR2lhwWTzUxb5bxbNxsA4eUXnvSr0lqCwcjw3M5WQHocGn4VPjKZl7Jhqxu9evwF5siuZEDL4oK8NgPwAZxMYcFuefdPgpxA/wmqWAh6JPbXLstQlG24bTrxCIzsx7qEfhU65KQJaLi3kso4LA/IDmPRHIFGNUbY3YOwfDpmH/fHFQNY/5uy5/0oICAv9M3QBEMvB2rWpWJT8j2CkISCSjzPNnB490uUv9cxNnLs8tDrOHlAnm+k0iXyJ4hjqtXqSbLCLz2Jw== katy";
    private static final String EXISTING_KEY = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQDmak4Wu23RZ6XmN94bOsqecZxuTa4RRhhQmHmTZjMB7HM57/90u/B/gB/GhsPEu1nAXL0npY56tT/MPQ8vRm2C2W9A7CzN5+z5yyL3W01YZy3kzslk77CjULjfhrcfQSL3b2sPG5jv5E5/nyC/swSytucwT/PE7aXTS9H6cHIKUdYPzIt94SHoBxWRIK7PJi9d+eLB+hmDzvbVa1ezu5a8yu2kcHi6NxxfI5iRj2rsceDTp0imC1jMoC6ZDfBvZSxL9FXTMwFdNnmTlJveBtv9nAbnAvIWlilS0VOkdj1s3GxBxeZYAcKbcsK9sJzusptk5dxGsG2Z8vInaglN6OaOQ7b7tcomzCYYwviGQ9gRX8sGsVrw39gsDIGYP2tA4bRr7ecHnlNg1b0HCchA5+QCDk4Hbz1UrnHmPA2Lg9c3WGm2qedvQdVJXuS3mlwYOqL40aXPs6890PvFJUlpiVSznF50djPnwsMxJZEf1HdTXgZD1Bh54ogZf7czyUNfkNkE69yJDbTHjpQd0cKUQnu9tVxqmBzhX31yF4VcsMeADcf2Z8wlA3n4LZnC/GwonYlq5+G93zJpFOkPhme8c2XuPuCXF795lsxyJ8SB/AlwPJAhEtm0y0s0l1l4eWqxsDxkBOgN+ivU0czrVMssHJEJb4o0FLf7iHhOW56/iMdD9w== katy";
    @Mock
    private NewSSHKeyModalView view;
    @Mock
    private SSHKeyEditorService sshKeyEditorService;
    private CallerMock<SSHKeyEditorService> serviceCaller;
    @Mock
    private TranslationService translationService;
    @Mock
    private NewSSHKeyModalHandler handler;
    private NewSSHKeyModal modal;

    @Before
    public void init() {
        Mockito.when((Object)this.handler.existsKeyName((String)ArgumentMatchers.eq((Object)EXISTING_KEY_NAME))).thenReturn((Object)true);
        Mockito.when((Object)this.handler.existsKey((String)ArgumentMatchers.eq((Object)EXISTING_KEY))).thenReturn((Object)true);
        Mockito.when((Object)this.translationService.format((String)ArgumentMatchers.eq((Object)"Validation.cannotBeEmpty"), (Object[])ArgumentMatchers.any())).thenReturn((Object)"Field cannot be empty");
        ((SSHKeyEditorService)Mockito.doAnswer(invocationOnMock -> {
            String keyContent = (String)invocationOnMock.getArguments()[1];
            PublicKeyConverter.fromString((String)keyContent);
            return null;
        }).when((Object)this.sshKeyEditorService)).addKey(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        this.serviceCaller = new CallerMock((Object)this.sshKeyEditorService);
        this.modal = new NewSSHKeyModal(this.view, this.serviceCaller, this.translationService);
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).init((NewSSHKeyModalView.Presenter)this.modal);
    }

    @Test
    public void testBasicFunctions() {
        this.modal.init(this.handler);
        this.modal.show();
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).show();
        this.modal.hide();
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testNotifyCancel() {
        this.modal.notifyCancel();
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testAddKeyNullValidationFailure() {
        this.testBasicFunctions();
        this.modal.notifyAdd(null, null);
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).resetValidation();
        ((TranslationService)Mockito.verify((Object)this.translationService)).getTranslation((String)ArgumentMatchers.eq((Object)"NewSSHKeyModalViewImpl.name"));
        ((TranslationService)Mockito.verify((Object)this.translationService)).getTranslation((String)ArgumentMatchers.eq((Object)"NewSSHKeyModalViewImpl.key"));
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)VerificationModeFactory.times((int)2))).format((String)ArgumentMatchers.eq((Object)"Validation.cannotBeEmpty"), (Object[])ArgumentMatchers.any());
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation("Validation.keyFormatError");
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation("Validation.keyAlreadyExists");
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)ArgumentMatchers.eq((Object)"Validation.keyNameAlreadyExists"), (Object[])ArgumentMatchers.any());
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).setNameValidationError((String)ArgumentMatchers.any());
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).setKeyValidationError((String)ArgumentMatchers.any());
        ((SSHKeyEditorService)Mockito.verify((Object)this.sshKeyEditorService, (VerificationMode)Mockito.never())).addKey(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((NewSSHKeyModalHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).onAddKey();
    }

    @Test
    public void testAddKeyWrongKeyValidationFailure() {
        this.testBasicFunctions();
        this.modal.notifyAdd(NAME, WRONG_KEY);
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).resetValidation();
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation((String)ArgumentMatchers.eq((Object)"NewSSHKeyModalViewImpl.name"));
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation((String)ArgumentMatchers.eq((Object)"NewSSHKeyModalViewImpl.key"));
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)ArgumentMatchers.eq((Object)"Validation.cannotBeEmpty"), (Object[])ArgumentMatchers.any());
        ((TranslationService)Mockito.verify((Object)this.translationService)).getTranslation("Validation.keyFormatError");
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation("Validation.keyAlreadyExists");
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)ArgumentMatchers.eq((Object)"Validation.keyNameAlreadyExists"), (Object[])ArgumentMatchers.any());
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNameValidationError((String)ArgumentMatchers.any());
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).setKeyValidationError((String)ArgumentMatchers.any());
        ((SSHKeyEditorService)Mockito.verify((Object)this.sshKeyEditorService, (VerificationMode)Mockito.never())).addKey(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((NewSSHKeyModalHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).onAddKey();
    }

    @Test
    public void testAddKeyWrongKeyFormatValidationFailure() {
        this.testBasicFunctions();
        this.modal.notifyAdd(NAME, WRONG_KEY_FORMAT);
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).resetValidation();
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation((String)ArgumentMatchers.eq((Object)"NewSSHKeyModalViewImpl.name"));
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation((String)ArgumentMatchers.eq((Object)"NewSSHKeyModalViewImpl.key"));
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)ArgumentMatchers.eq((Object)"Validation.cannotBeEmpty"), (Object[])ArgumentMatchers.any());
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation("Validation.keyAlreadyExists");
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)ArgumentMatchers.eq((Object)"Validation.keyNameAlreadyExists"), (Object[])ArgumentMatchers.any());
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNameValidationError((String)ArgumentMatchers.any());
        ((SSHKeyEditorService)Mockito.verify((Object)this.sshKeyEditorService)).addKey(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((TranslationService)Mockito.verify((Object)this.translationService)).getTranslation("Validation.keyFormatError");
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).setKeyValidationError((String)ArgumentMatchers.any());
        ((NewSSHKeyModalHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).onAddKey();
    }

    @Test
    public void testAddKeyExistingKeyNameValidationFailure() {
        this.testBasicFunctions();
        this.modal.notifyAdd(EXISTING_KEY_NAME, VALID_KEY);
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).resetValidation();
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation((String)ArgumentMatchers.eq((Object)"NewSSHKeyModalViewImpl.name"));
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation((String)ArgumentMatchers.eq((Object)"NewSSHKeyModalViewImpl.key"));
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)ArgumentMatchers.eq((Object)"Validation.cannotBeEmpty"), (Object[])ArgumentMatchers.any());
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation("Validation.keyAlreadyExists");
        ((TranslationService)Mockito.verify((Object)this.translationService)).format((String)ArgumentMatchers.eq((Object)"Validation.keyNameAlreadyExists"), (Object[])ArgumentMatchers.any());
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).setNameValidationError((String)ArgumentMatchers.any());
        ((SSHKeyEditorService)Mockito.verify((Object)this.sshKeyEditorService, (VerificationMode)Mockito.never())).addKey(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation("Validation.keyFormatError");
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setKeyValidationError((String)ArgumentMatchers.any());
        ((NewSSHKeyModalHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).onAddKey();
    }

    @Test
    public void testAddKeyExistingKeyValidationFailure() {
        this.testBasicFunctions();
        this.modal.notifyAdd(NAME, EXISTING_KEY);
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).resetValidation();
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation((String)ArgumentMatchers.eq((Object)"NewSSHKeyModalViewImpl.name"));
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation((String)ArgumentMatchers.eq((Object)"NewSSHKeyModalViewImpl.key"));
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)ArgumentMatchers.eq((Object)"Validation.cannotBeEmpty"), (Object[])ArgumentMatchers.any());
        ((TranslationService)Mockito.verify((Object)this.translationService)).getTranslation("Validation.keyAlreadyExists");
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)ArgumentMatchers.eq((Object)"Validation.keyNameAlreadyExists"), (Object[])ArgumentMatchers.any());
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNameValidationError((String)ArgumentMatchers.any());
        ((SSHKeyEditorService)Mockito.verify((Object)this.sshKeyEditorService, (VerificationMode)Mockito.never())).addKey(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation("Validation.keyFormatError");
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).setKeyValidationError((String)ArgumentMatchers.any());
        ((NewSSHKeyModalHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).onAddKey();
    }

    @Test
    public void testAddKey() {
        this.testBasicFunctions();
        this.modal.notifyAdd(NAME, VALID_KEY);
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view)).resetValidation();
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation((String)ArgumentMatchers.eq((Object)"NewSSHKeyModalViewImpl.name"));
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation((String)ArgumentMatchers.eq((Object)"NewSSHKeyModalViewImpl.key"));
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)ArgumentMatchers.eq((Object)"Validation.cannotBeEmpty"), (Object[])ArgumentMatchers.any());
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation("Validation.keyFormatError");
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).getTranslation("Validation.keyAlreadyExists");
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)ArgumentMatchers.eq((Object)"Validation.keyNameAlreadyExists"), (Object[])ArgumentMatchers.any());
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNameValidationError((String)ArgumentMatchers.any());
        ((NewSSHKeyModalView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setKeyValidationError((String)ArgumentMatchers.any());
        ((SSHKeyEditorService)Mockito.verify((Object)this.sshKeyEditorService)).addKey(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((NewSSHKeyModalHandler)Mockito.verify((Object)this.handler)).onAddKey();
    }

    @Test
    public void testInitNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.modal.init(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'handler' should be not null!");
    }
}

