/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.guvnor.structure.repositories.GitMetadata;
import org.guvnor.structure.repositories.PullRequest;
import org.guvnor.structure.repositories.impl.PullRequestImpl;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;

@Portable
public class GitMetadataImpl
implements GitMetadata {
    private String origin;
    private List<String> forks;
    private String name;
    private List<PullRequest> pullRequests;

    public GitMetadataImpl(String name) {
        this(name, "", new ArrayList<String>(), new ArrayList<PullRequest>());
    }

    public GitMetadataImpl(String name, String origin) {
        this(name, origin, new ArrayList<String>(), new ArrayList<PullRequest>());
    }

    public GitMetadataImpl(String name, List<String> forks) {
        this(name, "", forks, new ArrayList<PullRequest>());
    }

    public GitMetadataImpl(String name, String origin, List<String> forks) {
        this(name, origin, forks, new ArrayList<PullRequest>());
    }

    public GitMetadataImpl(@MapsTo(value="name") String name, @MapsTo(value="origin") String origin, @MapsTo(value="forks") List<String> forks, @MapsTo(value="pullRequests") List<PullRequest> pullRequests) {
        this.name = PortablePreconditions.checkNotEmpty((String)"name", (String)name);
        this.origin = (String)PortablePreconditions.checkNotNull((String)"origin", (Object)origin);
        this.forks = (List)PortablePreconditions.checkNotNull((String)"forks", forks);
        this.pullRequests = (List)PortablePreconditions.checkNotNull((String)"pullRequests", pullRequests);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getForks() {
        return new ArrayList<String>(this.forks);
    }

    @Override
    public String getOrigin() {
        return this.origin;
    }

    @Override
    public List<PullRequest> getPullRequests() {
        return new ArrayList<PullRequest>(this.pullRequests);
    }

    @Override
    public List<PullRequest> getPullRequests(Predicate<? super PullRequest> filter) {
        List<PullRequest> prs = this.getPullRequests();
        return prs.stream().filter(filter).collect(Collectors.toList());
    }

    @Override
    public PullRequest getPullRequest(long id) {
        List<PullRequest> prs = this.getPullRequests(elem -> elem.getId() == id);
        if (prs.size() == 0) {
            throw new NoSuchElementException("The Pull Request with ID #" + id + " not found");
        }
        PullRequest pr = prs.get(0);
        return new PullRequestImpl(pr.getId(), pr.getSourceRepository(), pr.getSourceBranch(), pr.getTargetRepository(), pr.getTargetBranch(), pr.getStatus());
    }

    @Override
    public boolean exists(PullRequest pullRequest) {
        return this.getPullRequests().stream().anyMatch(pr -> pr.getSourceBranch().equals(pullRequest.getSourceBranch()) && pr.getSourceRepository().equals(pullRequest.getSourceRepository()) && pr.getTargetBranch().equals(pullRequest.getTargetBranch()) && pr.getTargetRepository().equals(pullRequest.getTargetRepository()) && pr.getStatus().equals((Object)pullRequest.getStatus()));
    }
}

