/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.organizationalunit.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.security.ResourceType;
import org.uberfire.spaces.Space;

@Portable
public class OrganizationalUnitImpl
implements OrganizationalUnit {
    private String name;
    private String defaultGroupId;
    private String owner;
    private Collection<Repository> repositories = new ArrayList<Repository>();
    private Collection<String> groups = new ArrayList<String>();
    private Collection<String> contributors = new ArrayList<String>();
    private boolean requiresRefresh = true;

    public OrganizationalUnitImpl() {
    }

    public OrganizationalUnitImpl(String name, String owner, String defaultGroupId) {
        this.name = name;
        this.owner = owner;
        this.defaultGroupId = defaultGroupId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Space getSpace() {
        return new Space(this.name);
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public String getDefaultGroupId() {
        return this.defaultGroupId;
    }

    @Override
    public Collection<Repository> getRepositories() {
        return this.repositories;
    }

    public String getIdentifier() {
        return this.getName();
    }

    public ResourceType getResourceType() {
        return RESOURCE_TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrganizationalUnitImpl)) {
            return false;
        }
        OrganizationalUnitImpl ou = (OrganizationalUnitImpl)o;
        if (this.name != null ? !this.name.equals(ou.name) : ou.name != null) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(ou.owner) : ou.owner != null) {
            return false;
        }
        return !(this.defaultGroupId != null ? !this.defaultGroupId.equals(ou.defaultGroupId) : ou.defaultGroupId != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = ~(~result);
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.defaultGroupId != null ? this.defaultGroupId.hashCode() : 0);
        result = ~(~result);
        return result;
    }

    public String toString() {
        return "OrganizationalUnitImpl [name=" + this.name + ", owner=" + this.owner + ", repositories=" + this.repositories + ", groups=" + this.groups + ", defaultGroupId=" + this.defaultGroupId + "]";
    }

    public void markAsCached() {
        this.requiresRefresh = false;
    }

    public boolean requiresRefresh() {
        return this.requiresRefresh;
    }

    @Override
    public Collection<String> getGroups() {
        return this.groups;
    }

    @Override
    public Collection<String> getContributors() {
        return this.contributors;
    }
}

