/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.organizationalunit.config;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class SpaceInfo {
    private String name;
    private String defaultGroupId;
    private Collection<Contributor> contributors;
    private List<RepositoryInfo> repositories;
    private List<String> securityGroups;

    public SpaceInfo(@MapsTo(value="name") String name, @MapsTo(value="defaultGroupId") String defaultGroupId, @MapsTo(value="contributors") Collection<Contributor> contributors, @MapsTo(value="repositories") List<RepositoryInfo> repositories, @MapsTo(value="securityGroups") List<String> securityGroups) {
        this.name = name;
        this.defaultGroupId = defaultGroupId;
        this.contributors = contributors;
        this.repositories = repositories;
        this.securityGroups = securityGroups;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultGroupId() {
        return this.defaultGroupId;
    }

    public void setDefaultGroupId(String defaultGroupId) {
        this.defaultGroupId = defaultGroupId;
    }

    public Collection<Contributor> getContributors() {
        return this.contributors;
    }

    public void setContributors(Collection<Contributor> contributors) {
        this.contributors = contributors;
    }

    public List<RepositoryInfo> getRepositories() {
        return this.repositories;
    }

    public List<RepositoryInfo> getRepositories(Predicate<RepositoryInfo> query) {
        return this.repositories.stream().filter(query).collect(Collectors.toList());
    }

    public void setRepositories(List<RepositoryInfo> repositories) {
        this.repositories = repositories;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(List<String> securityGroups) {
        this.securityGroups = securityGroups;
    }

    public void removeRepository(String name) {
        this.getRepositories().removeIf(repo -> repo.getName().equals(name));
    }
}

