/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.guvnor.structure.repositories.RepositoryUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RepositoryUtilsTest {
    @Test
    public void cleanUpCredentialsFromEnvMapWhenNotNeededTest() {
        Map<String, Object> envMap = this.createEnvMap(false);
        List result = RepositoryUtils.cleanUpCredentialsFromEnvMap(envMap);
        Assertions.assertThat((List)result).isEmpty();
    }

    @Test
    public void cleanUpCredentialsFromEnvMapWhenNeededTest() {
        Map<String, Object> envMap = this.createEnvMap(true);
        List result = RepositoryUtils.cleanUpCredentialsFromEnvMap(envMap);
        Assertions.assertThat((List)result).isNotEmpty();
        Assertions.assertThat((List)result).contains((Object[])new String[]{"username", "password", "secure:password"});
        Assertions.assertThat(envMap).doesNotContainKeys((Object[])new String[]{"username", "password", "secure:password"});
    }

    private Map<String, Object> createEnvMap(boolean includeCredentials) {
        HashMap<String, Object> envMap = new HashMap<String, Object>();
        envMap.put("foo", true);
        envMap.put("bar", 1);
        if (includeCredentials) {
            envMap.put("username", "user");
            envMap.put("password", "pw");
            envMap.put("secure:password", "spw");
        }
        return envMap;
    }
}

