/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Event;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.config.ConfigurationFactoryImpl;
import org.guvnor.structure.backend.organizationalunit.OrganizationalUnitFactoryImpl;
import org.guvnor.structure.backend.organizationalunit.OrganizationalUnitServiceImpl;
import org.guvnor.structure.organizationalunit.NewOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoAddedToOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoRemovedFromOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.UpdatedOrganizationalUnitEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.security.OrganizationalUnitAction;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.organizationalunit.OrganizationalUnitFactory;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class OrganizationalUnitServiceTest {
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private SpacesAPI spacesAPI;
    @Mock
    private ConfigurationService configurationService;
    @Spy
    @InjectMocks
    private ConfigurationFactoryImpl configurationFactory;
    private OrganizationalUnitFactory organizationalUnitFactory;
    private BackwardCompatibleUtil backward;
    @Mock
    private Event<NewOrganizationalUnitEvent> newOrganizationalUnitEvent;
    @Mock
    private Event<RemoveOrganizationalUnitEvent> removeOrganizationalUnitEvent;
    @Mock
    private Event<RepoAddedToOrganizationalUnitEvent> repoAddedToOrgUnitEvent;
    @Mock
    private Event<RepoRemovedFromOrganizationalUnitEvent> repoRemovedFromOrgUnitEvent;
    @Mock
    private Event<UpdatedOrganizationalUnitEvent> updatedOrganizationalUnitEvent;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private RepositoryService repoService;
    @Mock
    private OrganizationalUnit orgUnit;
    private OrganizationalUnitServiceImpl organizationalUnitService;

    @Before
    public void setUp() throws Exception {
        this.backward = new BackwardCompatibleUtil((ConfigurationFactory)this.configurationFactory);
        this.organizationalUnitFactory = (OrganizationalUnitFactory)Mockito.spy((Object)new OrganizationalUnitFactoryImpl(this.repositoryService, this.backward, this.spacesAPI));
        this.organizationalUnitService = new OrganizationalUnitServiceImpl(this.configurationService, (ConfigurationFactory)this.configurationFactory, this.organizationalUnitFactory, this.repoService, this.backward, this.newOrganizationalUnitEvent, this.removeOrganizationalUnitEvent, this.repoAddedToOrgUnitEvent, this.repoRemovedFromOrgUnitEvent, this.updatedOrganizationalUnitEvent, this.authorizationManager, this.spacesAPI, this.sessionInfo);
        this.organizationalUnitService.registeredOrganizationalUnits.put("A", this.orgUnit);
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.any(User.class))).thenReturn((Object)false);
    }

    @Test
    public void testAllOrgUnits() throws Exception {
        Collection orgUnits = this.organizationalUnitService.getAllOrganizationalUnits();
        Assert.assertEquals((long)orgUnits.size(), (long)1L);
    }

    @Test
    public void testSecuredOrgUnits() throws Exception {
        Collection orgUnits = this.organizationalUnitService.getOrganizationalUnits();
        Assert.assertEquals((long)orgUnits.size(), (long)0L);
    }

    @Test
    public void createOrganizationalUnitWithDuplicatedNameTest() {
        this.setOUCreationPermission(true);
        OrganizationalUnit ou = this.organizationalUnitService.createOrganizationalUnit("a", "owner", "default.group.id");
        Assert.assertNull((Object)ou);
        ((OrganizationalUnitFactory)Mockito.verify((Object)this.organizationalUnitFactory, (VerificationMode)Mockito.never())).newOrganizationalUnit((ConfigGroup)Matchers.any());
    }

    @Test
    public void createValidOrganizationalUnitTest() {
        ArrayList<String> contributors = new ArrayList<String>();
        contributors.add("admin");
        this.setOUCreationPermission(true);
        OrganizationalUnit ou = this.organizationalUnitService.createOrganizationalUnit("name", "owner", "default.group.id", new ArrayList(), contributors);
        Assert.assertNotNull((Object)ou);
        ((OrganizationalUnitFactory)Mockito.verify((Object)this.organizationalUnitFactory)).newOrganizationalUnit((ConfigGroup)Matchers.any());
        Assert.assertEquals((Object)"name", (Object)ou.getName());
        Assert.assertEquals((Object)"owner", (Object)ou.getOwner());
        Assert.assertEquals((Object)"default.group.id", (Object)ou.getDefaultGroupId());
        Assert.assertEquals(contributors, (Object)ou.getContributors());
    }

    @Test
    public void removeOrganizationalUnitRemovesRepositories() throws Exception {
        Repository repoA = (Repository)Mockito.mock(Repository.class);
        Repository repoB = (Repository)Mockito.mock(Repository.class);
        List<Repository> repos = Arrays.asList(repoA, repoB);
        Mockito.when((Object)repoA.getAlias()).thenReturn((Object)"A");
        Mockito.when((Object)repoB.getAlias()).thenReturn((Object)"B");
        Space space = new Space("A");
        Mockito.when((Object)this.orgUnit.getRepositories()).thenReturn(repos);
        Mockito.when((Object)this.orgUnit.getSpace()).thenReturn((Object)space);
        ConfigGroup configGroup = new ConfigGroup();
        configGroup.setName("A");
        Mockito.when((Object)this.configurationService.getConfiguration(ConfigType.SPACE)).thenReturn(Collections.singletonList(configGroup));
        this.organizationalUnitService.removeOrganizationalUnit("A");
        ((RepositoryService)Mockito.verify((Object)this.repoService)).removeRepositories((Space)Matchers.eq((Object)space), (Set)Matchers.eq(new HashSet<String>(Arrays.asList("A", "B"))));
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(RemoveOrganizationalUnitEvent.class);
        ((Event)Mockito.verify(this.removeOrganizationalUnitEvent)).fire(eventCaptor.capture());
        RemoveOrganizationalUnitEvent event = (RemoveOrganizationalUnitEvent)eventCaptor.getValue();
        Assert.assertEquals(repos, (Object)event.getOrganizationalUnit().getRepositories());
    }

    private void setOUCreationPermission(boolean hasPermission) {
        Mockito.when((Object)this.authorizationManager.authorize((ResourceType)Matchers.eq((Object)OrganizationalUnit.RESOURCE_TYPE), (ResourceAction)Matchers.eq((Object)OrganizationalUnitAction.CREATE), (User)Matchers.any(User.class))).thenReturn((Object)hasPermission);
    }
}

