/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.pom;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.assertj.core.api.Assertions;
import org.guvnor.structure.backend.pom.PomStructureEditor;
import org.guvnor.structure.backend.pom.TestUtil;
import org.guvnor.structure.pom.AddPomDependencyEvent;
import org.guvnor.structure.pom.DependencyType;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class PomStructureEditorTest {
    private PomStructureEditor editor;
    private Path tmpRoot;
    private Path tmp;
    private final String POM = "pom.xml";

    @Before
    public void setUp() throws Exception {
        this.tmpRoot = Files.createTempDirectory((String)"repo", (FileAttribute[])new FileAttribute[0]);
        this.tmp = TestUtil.createAndCopyToDirectory(this.tmpRoot, "dummy", "target/test-classes/dummy_empty_deps");
    }

    @Test
    public void onNEwDynamicDependencyEventTest() throws Exception {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = reader.read((InputStream)new ByteArrayInputStream(Files.readAllBytes((Path)Paths.get((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String[])new String[0]))));
        Assertions.assertThat((List)model.getDependencies()).hasSize(0);
        this.editor = new PomStructureEditor();
        AddPomDependencyEvent event = new AddPomDependencyEvent(DependencyType.JPA, PathFactory.newPath((String)this.tmp.getFileName().toString(), (String)(this.tmp.toUri().toString() + File.separator + "pom.xml")));
        this.editor.onNewDynamicDependency(event);
        model = reader.read((InputStream)new ByteArrayInputStream(Files.readAllBytes((Path)Paths.get((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String[])new String[0]))));
        Assertions.assertThat((List)model.getDependencies()).hasSize(1);
        Dependency dep = (Dependency)model.getDependencies().get(0);
        Assertions.assertThat((String)dep.getGroupId()).containsOnlyOnce((CharSequence)"org.hibernate.javax.persistence");
        Assertions.assertThat((String)dep.getArtifactId()).containsOnlyOnce((CharSequence)"hibernate-jpa-2.1-api");
        Assertions.assertThat((String)dep.getVersion()).containsOnlyOnce((CharSequence)"1.0.2.Final");
    }
}

