/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.pom;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.guvnor.structure.pom.DependencyType;
import org.guvnor.structure.pom.DynamicPomDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.attribute.FileAttribute;

class TestUtil {
    public static final String GROUP_ID_TEST = "org.hibernate.javax.persistence";
    public static final String ARTIFACT_ID_TEST = "hibernate-jpa-2.1-api";
    public static final String VERSION_ID_TEST = "1.0.2.Final";
    private static Logger logger = LoggerFactory.getLogger(TestUtil.class);

    TestUtil() {
    }

    public static void testJPADep(Map<DependencyType, List<DynamicPomDependency>> mapping) {
        List<DynamicPomDependency> deps = mapping.get(DependencyType.JPA);
        Assertions.assertThat(deps).hasSize(1);
        DynamicPomDependency dep = deps.get(0);
        Assertions.assertThat((String)dep.getGroupID()).isEqualToIgnoringCase((CharSequence)GROUP_ID_TEST);
        Assertions.assertThat((String)dep.getArtifactID()).isEqualToIgnoringCase((CharSequence)ARTIFACT_ID_TEST);
        Assertions.assertThat((String)dep.getVersion()).isEqualToIgnoringCase((CharSequence)VERSION_ID_TEST);
        Assertions.assertThat((String)dep.getScope()).isEmpty();
    }

    public static Path createAndCopyToDirectory(Path root, String dirName, String copyTree) throws IOException {
        Path dir = Files.createDirectories((Path)Paths.get((String)root.toString(), (String[])new String[]{dirName}), (FileAttribute[])new FileAttribute[0]);
        TestUtil.copyTree(Paths.get((String)copyTree, (String[])new String[0]), dir);
        return dir;
    }

    public static void copyTree(Path source, Path target) throws IOException {
        FileUtils.copyDirectory((File)source.toFile(), (File)target.toFile());
    }

    public static void rm(File f) {
        try {
            FileUtils.deleteDirectory((File)f);
        }
        catch (Exception e) {
            logger.error("Couldn't delete file {}", (Object)f);
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

