/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.Collections;
import java.util.Optional;
import org.guvnor.structure.backend.config.ConfigurationFactoryImpl;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.backend.repositories.RepositoryServiceImpl;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class RepositoryServiceImplTest {
    @Mock
    private Repository repository;
    @Mock
    private ConfiguredRepositories configuredRepositories;
    @Mock
    private ConfigurationService configurationService;
    @Mock
    private RepositoryFactory repositoryFactory;
    @Spy
    ConfigurationFactoryImpl configurationFactory;
    @InjectMocks
    private RepositoryServiceImpl repositoryService;

    @Test
    public void testNotCreateNewAliasIfNecessary() {
        Mockito.when((Object)this.configuredRepositories.getRepositoryByRepositoryAlias((Space)Matchers.any(), (String)Matchers.eq((Object)"other-name"))).thenReturn((Object)this.repository);
        ((Repository)Mockito.doReturn(Optional.of(Mockito.mock(Branch.class))).when((Object)this.repository)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"alias").when((Object)this.repository)).getAlias();
        String newAlias = this.repositoryService.createFreshRepositoryAlias("alias", new Space("alias"));
        Assert.assertEquals((Object)"alias", (Object)newAlias);
    }

    @Test
    public void testCreateNewAliasIfNecessary() {
        Mockito.when((Object)this.configuredRepositories.getRepositoryByRepositoryAlias((Space)Matchers.any(), (String)Matchers.eq((Object)"alias"))).thenReturn((Object)this.repository);
        ((Repository)Mockito.doReturn(Optional.of(Mockito.mock(Branch.class))).when((Object)this.repository)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"alias").when((Object)this.repository)).getAlias();
        String newAlias = this.repositoryService.createFreshRepositoryAlias("alias", new Space("alias"));
        Assert.assertEquals((Object)"alias-1", (Object)newAlias);
    }

    @Test
    public void testCreateSecondNewAliasIfNecessary() {
        Mockito.when((Object)this.configuredRepositories.getRepositoryByRepositoryAlias((Space)Matchers.any(), (String)Matchers.eq((Object)"alias"))).thenReturn((Object)this.repository);
        Mockito.when((Object)this.configuredRepositories.getRepositoryByRepositoryAlias((Space)Matchers.any(), (String)Matchers.eq((Object)"alias-1"))).thenReturn((Object)this.repository);
        ((Repository)Mockito.doReturn(Optional.of(Mockito.mock(Branch.class))).when((Object)this.repository)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"alias").when((Object)this.repository)).getAlias();
        String newAlias = this.repositoryService.createFreshRepositoryAlias("alias", new Space("alias"));
        Assert.assertEquals((Object)"alias-2", (Object)newAlias);
    }

    @Test
    public void updateContributorsTest() {
        Space space = new Space("alias");
        ((Repository)Mockito.doReturn((Object)space).when((Object)this.repository)).getSpace();
        ((Repository)Mockito.doReturn((Object)"alias").when((Object)this.repository)).getAlias();
        ConfigGroup configGroup = new ConfigGroup();
        configGroup.setName("alias");
        configGroup.addConfigItem(this.configurationFactory.newConfigItem("contributors", Collections.emptyList()));
        ((ConfigurationService)Mockito.doReturn(Collections.singletonList(configGroup)).when((Object)this.configurationService)).getConfiguration(ConfigType.REPOSITORY, "alias");
        this.repositoryService.updateContributors(this.repository, Collections.singletonList(new Contributor("admin1", ContributorType.OWNER)));
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).updateConfiguration(configGroup);
    }
}

