/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.organizationalunit.NewOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoAddedToOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoRemovedFromOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.UpdatedOrganizationalUnitEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentUpdatedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.organizationalunit.OrganizationalUnitFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.security.management.api.event.UserDeletedEvent;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@Service
@ApplicationScoped
public class OrganizationalUnitServiceImpl
implements OrganizationalUnitService {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationalUnitServiceImpl.class);
    private ConfigurationService configurationService;
    private ConfigurationFactory configurationFactory;
    private OrganizationalUnitFactory organizationalUnitFactory;
    private BackwardCompatibleUtil backward;
    private Event<NewOrganizationalUnitEvent> newOrganizationalUnitEvent;
    private Event<RemoveOrganizationalUnitEvent> removeOrganizationalUnitEvent;
    private Event<RepoAddedToOrganizationalUnitEvent> repoAddedToOrgUnitEvent;
    private Event<RepoRemovedFromOrganizationalUnitEvent> repoRemovedFromOrgUnitEvent;
    private Event<UpdatedOrganizationalUnitEvent> updatedOrganizationalUnitEvent;
    private AuthorizationManager authorizationManager;
    private SessionInfo sessionInfo;
    Map<String, OrganizationalUnit> registeredOrganizationalUnits = new TreeMap<String, OrganizationalUnit>(String.CASE_INSENSITIVE_ORDER);
    private SpacesAPI spaces;
    private RepositoryService repositoryService;
    private IOService ioService;
    private ConfiguredRepositories configuredRepositories;

    public OrganizationalUnitServiceImpl() {
    }

    @Inject
    public OrganizationalUnitServiceImpl(ConfigurationService configurationService, ConfigurationFactory configurationFactory, OrganizationalUnitFactory organizationalUnitFactory, RepositoryService repositoryService, BackwardCompatibleUtil backward, Event<NewOrganizationalUnitEvent> newOrganizationalUnitEvent, Event<RemoveOrganizationalUnitEvent> removeOrganizationalUnitEvent, Event<RepoAddedToOrganizationalUnitEvent> repoAddedToOrgUnitEvent, Event<RepoRemovedFromOrganizationalUnitEvent> repoRemovedFromOrgUnitEvent, Event<UpdatedOrganizationalUnitEvent> updatedOrganizationalUnitEvent, AuthorizationManager authorizationManager, SpacesAPI spaces, SessionInfo sessionInfo, @Named(value="ioStrategy") IOService ioService, ConfiguredRepositories configuredRepositories) {
        this.configurationService = configurationService;
        this.configurationFactory = configurationFactory;
        this.organizationalUnitFactory = organizationalUnitFactory;
        this.repositoryService = repositoryService;
        this.backward = backward;
        this.newOrganizationalUnitEvent = newOrganizationalUnitEvent;
        this.removeOrganizationalUnitEvent = removeOrganizationalUnitEvent;
        this.repoAddedToOrgUnitEvent = repoAddedToOrgUnitEvent;
        this.repoRemovedFromOrgUnitEvent = repoRemovedFromOrgUnitEvent;
        this.updatedOrganizationalUnitEvent = updatedOrganizationalUnitEvent;
        this.authorizationManager = authorizationManager;
        this.spaces = spaces;
        this.sessionInfo = sessionInfo;
        this.ioService = ioService;
        this.configuredRepositories = configuredRepositories;
    }

    @PostConstruct
    public void loadOrganizationalUnits() {
        List groups = this.configurationService.getConfiguration(ConfigType.SPACE);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                String ouName = groupConfig.getName();
                String defaultGroupId = groupConfig.getConfigItemValue("defaultGroupId");
                if (defaultGroupId == null || defaultGroupId.trim().isEmpty()) {
                    groupConfig.setConfigItem(this.configurationFactory.newConfigItem("defaultGroupId", this.getSanitizedDefaultGroupId(ouName)));
                    this.configurationService.updateConfiguration(groupConfig);
                }
                OrganizationalUnit ou = this.organizationalUnitFactory.newOrganizationalUnit(groupConfig);
                this.registeredOrganizationalUnits.put(ou.getName(), ou);
                this.createSpaceConfigRepositoryIfNecessary(ouName);
            }
        }
        this.configuredRepositories.reloadRepositories();
    }

    public void userRemoved(@Observes UserDeletedEvent event) {
        String removedUserIdentifier = event.getIdentifier();
        for (OrganizationalUnit organizationalUnit : this.getAllOrganizationalUnits()) {
            boolean userRemoved = organizationalUnit.getContributors().removeIf(c -> c.getUsername().equals(removedUserIdentifier));
            if (userRemoved) {
                this.updateOrganizationalUnit(organizationalUnit.getName(), organizationalUnit.getDefaultGroupId(), organizationalUnit.getContributors());
            }
            for (Repository repository : organizationalUnit.getRepositories()) {
                ArrayList<Contributor> updatedRepositoryContributors = new ArrayList<Contributor>(repository.getContributors());
                boolean repositoryContributorRemoved = updatedRepositoryContributors.removeIf(c -> c.getUsername().equals(removedUserIdentifier));
                if (!repositoryContributorRemoved) continue;
                this.repositoryService.updateContributors(repository, updatedRepositoryContributors);
            }
        }
    }

    public OrganizationalUnit getOrganizationalUnit(String name) {
        return this.registeredOrganizationalUnits.get(name);
    }

    public Collection<OrganizationalUnit> getAllOrganizationalUnits() {
        return new ArrayList<OrganizationalUnit>(this.registeredOrganizationalUnits.values());
    }

    public Collection<Space> getAllUserSpaces() {
        return this.registeredOrganizationalUnits.values().stream().map(ou -> this.spaces.getSpace(ou.getName())).collect(Collectors.toList());
    }

    public Collection<OrganizationalUnit> getOrganizationalUnits() {
        ArrayList<OrganizationalUnit> result = new ArrayList<OrganizationalUnit>();
        for (OrganizationalUnit ou : this.registeredOrganizationalUnits.values()) {
            if (!this.authorizationManager.authorize((Resource)ou, this.sessionInfo.getIdentity())) continue;
            result.add(ou);
        }
        return result;
    }

    public OrganizationalUnit createOrganizationalUnit(String name, String defaultGroupId) {
        return this.createOrganizationalUnit(name, defaultGroupId, new ArrayList<Repository>());
    }

    public OrganizationalUnit createOrganizationalUnit(String name, String defaultGroupId, Collection<Repository> repositories) {
        return this.createOrganizationalUnit(name, defaultGroupId, repositories, new ArrayList<Contributor>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationalUnit createOrganizationalUnit(String name, String defaultGroupId, Collection<Repository> repositories, Collection<Contributor> contributors) {
        OrganizationalUnit organizationalUnit;
        if (this.registeredOrganizationalUnits.containsKey(name)) {
            return null;
        }
        OrganizationalUnit newOrganizationalUnit = null;
        try {
            this.configurationService.startBatch();
            ConfigGroup groupConfig = this.configurationFactory.newConfigGroup(ConfigType.SPACE, name, "");
            String _defaultGroupId = defaultGroupId == null || defaultGroupId.trim().isEmpty() ? this.getSanitizedDefaultGroupId(name) : defaultGroupId;
            groupConfig.addConfigItem(this.configurationFactory.newConfigItem("defaultGroupId", _defaultGroupId));
            groupConfig.addConfigItem(this.configurationFactory.newConfigItem("repositories", this.getRepositoryAliases(repositories)));
            groupConfig.addConfigItem(this.configurationFactory.newConfigItem("security:groups", new ArrayList()));
            groupConfig.addConfigItem(this.configurationFactory.newConfigItem("space-contributors", contributors));
            this.configurationService.addConfiguration(groupConfig);
            newOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(groupConfig);
            this.registeredOrganizationalUnits.put(newOrganizationalUnit.getName(), newOrganizationalUnit);
            this.createSpaceConfigRepositoryIfNecessary(name);
            organizationalUnit = newOrganizationalUnit;
        }
        catch (Throwable throwable) {
            this.configurationService.endBatch();
            if (newOrganizationalUnit != null) {
                this.newOrganizationalUnitEvent.fire((Object)new NewOrganizationalUnitEvent(newOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
            }
            throw throwable;
        }
        this.configurationService.endBatch();
        if (newOrganizationalUnit != null) {
            this.newOrganizationalUnitEvent.fire((Object)new NewOrganizationalUnitEvent(newOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
        }
        return organizationalUnit;
    }

    private void createSpaceConfigRepositoryIfNecessary(String spaceName) {
        URI configPath = URI.create(SpacesAPI.resolveConfigFileSystemPath((SpacesAPI.Scheme)SpacesAPI.Scheme.DEFAULT, (String)spaceName));
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
                this.put("internal", Boolean.TRUE);
            }
        };
        try {
            this.ioService.newFileSystem(configPath, (Map)env);
        }
        catch (FileSystemAlreadyExistsException ex) {
            logger.info("Space " + spaceName + " config file system already exists.");
        }
    }

    private List<String> getRepositoryAliases(Collection<Repository> repositories) {
        ArrayList<String> repositoryList = new ArrayList<String>();
        for (Repository repo : repositories) {
            repositoryList.add(repo.getAlias());
        }
        return repositoryList;
    }

    public OrganizationalUnit updateOrganizationalUnit(String name, String defaultGroupId) {
        return this.updateOrganizationalUnit(name, defaultGroupId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationalUnit updateOrganizationalUnit(String name, String defaultGroupId, Collection<Contributor> contributors) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(name);
        if (thisGroupConfig != null) {
            OrganizationalUnit organizationalUnit;
            OrganizationalUnit updatedOrganizationalUnit = null;
            try {
                this.configurationService.startBatch();
                String _defaultGroupId = defaultGroupId == null || defaultGroupId.trim().isEmpty() ? thisGroupConfig.getConfigItemValue("defaultGroupId") : defaultGroupId;
                thisGroupConfig.setConfigItem(this.configurationFactory.newConfigItem("defaultGroupId", _defaultGroupId));
                if (contributors != null) {
                    thisGroupConfig.setConfigItem(this.configurationFactory.newConfigItem("space-contributors", contributors));
                }
                this.configurationService.updateConfiguration(thisGroupConfig);
                updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
                this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
                this.checkChildrenRepositoryContributors(updatedOrganizationalUnit);
                organizationalUnit = updatedOrganizationalUnit;
            }
            catch (Throwable throwable) {
                this.configurationService.endBatch();
                if (updatedOrganizationalUnit != null) {
                    this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                }
                throw throwable;
            }
            this.configurationService.endBatch();
            if (updatedOrganizationalUnit != null) {
                this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
            }
            return organizationalUnit;
        }
        throw new IllegalArgumentException("OrganizationalUnit " + name + " not found");
    }

    private void checkChildrenRepositoryContributors(OrganizationalUnit updatedOrganizationalUnit) {
        this.repositoryService.getAllRepositories(updatedOrganizationalUnit.getSpace()).forEach(repository -> {
            ArrayList repositoryContributors = new ArrayList(repository.getContributors());
            boolean repositoryContributorsChanged = repositoryContributors.retainAll(updatedOrganizationalUnit.getContributors());
            if (repositoryContributorsChanged) {
                this.repositoryService.updateContributors(repository, repositoryContributors);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(OrganizationalUnit organizationalUnit, Repository repository) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
        if (thisGroupConfig != null) {
            try {
                this.configurationService.startBatch();
                ConfigItem repositories = thisGroupConfig.getConfigItem("repositories");
                ((List)repositories.getValue()).add(repository.getAlias());
                this.configurationService.updateConfiguration(thisGroupConfig);
                OrganizationalUnit updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
                this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
            }
            finally {
                this.configurationService.endBatch();
                this.repoAddedToOrgUnitEvent.fire((Object)new RepoAddedToOrganizationalUnitEvent(organizationalUnit, repository, this.getUserInfo(this.sessionInfo)));
            }
        } else {
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepository(OrganizationalUnit organizationalUnit, Repository repository) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
        if (thisGroupConfig != null) {
            try {
                this.configurationService.startBatch();
                ConfigItem repositories = thisGroupConfig.getConfigItem("repositories");
                ((List)repositories.getValue()).remove(repository.getAlias());
                this.configurationService.updateConfiguration(thisGroupConfig);
                OrganizationalUnit updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
                this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
            }
            finally {
                this.configurationService.endBatch();
                this.repoRemovedFromOrgUnitEvent.fire((Object)new RepoRemovedFromOrganizationalUnitEvent(organizationalUnit, repository, this.getUserInfo(this.sessionInfo)));
            }
        } else {
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(OrganizationalUnit organizationalUnit, String group) {
        block5: {
            block4: {
                ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
                if (thisGroupConfig == null) break block4;
                OrganizationalUnit updatedOrganizationalUnit = null;
                try {
                    this.configurationService.startBatch();
                    ConfigItem groups = this.backward.compat(thisGroupConfig).getConfigItem("security:groups");
                    ((List)groups.getValue()).add(group);
                    this.configurationService.updateConfiguration(thisGroupConfig);
                    updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
                    this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
                }
                catch (Throwable throwable) {
                    this.configurationService.endBatch();
                    if (updatedOrganizationalUnit != null) {
                        this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                    }
                    throw throwable;
                }
                this.configurationService.endBatch();
                if (updatedOrganizationalUnit != null) {
                    this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                }
                break block5;
            }
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(OrganizationalUnit organizationalUnit, String group) {
        block5: {
            block4: {
                ConfigGroup thisGroupConfig = this.findGroupConfig(organizationalUnit.getName());
                if (thisGroupConfig == null) break block4;
                OrganizationalUnit updatedOrganizationalUnit = null;
                try {
                    this.configurationService.startBatch();
                    ConfigItem groups = this.backward.compat(thisGroupConfig).getConfigItem("security:groups");
                    ((List)groups.getValue()).remove(group);
                    this.configurationService.updateConfiguration(thisGroupConfig);
                    updatedOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(thisGroupConfig);
                    this.registeredOrganizationalUnits.put(updatedOrganizationalUnit.getName(), updatedOrganizationalUnit);
                }
                catch (Throwable throwable) {
                    this.configurationService.endBatch();
                    if (updatedOrganizationalUnit != null) {
                        this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                    }
                    throw throwable;
                }
                this.configurationService.endBatch();
                if (updatedOrganizationalUnit != null) {
                    this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                }
                break block5;
            }
            throw new IllegalArgumentException("OrganizationalUnit " + organizationalUnit.getName() + " not found");
        }
    }

    protected ConfigGroup findGroupConfig(String name) {
        List groups = this.configurationService.getConfiguration(ConfigType.SPACE);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                if (!groupConfig.getName().equals(name)) continue;
                return groupConfig;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOrganizationalUnit(String groupName) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(groupName);
        if (thisGroupConfig != null) {
            OrganizationalUnit removedOu = null;
            try {
                this.configurationService.startBatch();
                OrganizationalUnit originalOu = this.getOrganizationalUnit(groupName);
                this.repositoryService.removeRepositories(originalOu.getSpace(), originalOu.getRepositories().stream().map(repo -> repo.getAlias()).collect(Collectors.toSet()));
                this.configurationService.removeConfiguration(thisGroupConfig);
                removedOu = this.registeredOrganizationalUnits.remove(groupName);
                this.removeSpaceDirectory(removedOu.getSpace());
            }
            catch (Throwable throwable) {
                this.configurationService.endBatch();
                if (removedOu != null) {
                    this.removeOrganizationalUnitEvent.fire((Object)new RemoveOrganizationalUnitEvent(removedOu, this.getUserInfo(this.sessionInfo)));
                }
                throw throwable;
            }
            this.configurationService.endBatch();
            if (removedOu != null) {
                this.removeOrganizationalUnitEvent.fire((Object)new RemoveOrganizationalUnitEvent(removedOu, this.getUserInfo(this.sessionInfo)));
            }
        }
    }

    private void removeSpaceDirectory(Space space) {
        URI configPathURI = URI.create(SpacesAPI.resolveConfigFileSystemPath((SpacesAPI.Scheme)SpacesAPI.Scheme.DEFAULT, (String)space.getName()));
        Path configPath = this.ioService.get(configPathURI);
        JGitPathImpl configGitPath = (JGitPathImpl)configPath;
        File spacePath = ((JGitFileSystem)configGitPath.getFileSystem()).getGit().getRepository().getDirectory().getParentFile().getParentFile();
        this.ioService.delete(configPath.getFileSystem().getPath("", new String[0]), new DeleteOption[0]);
        spacePath.delete();
    }

    public OrganizationalUnit getParentOrganizationalUnit(Repository repository) {
        for (OrganizationalUnit organizationalUnit : this.registeredOrganizationalUnits.values()) {
            if (organizationalUnit.getRepositories() == null) continue;
            for (Repository ouRepository : organizationalUnit.getRepositories()) {
                if (!ouRepository.getAlias().equals(repository.getAlias())) continue;
                return organizationalUnit;
            }
        }
        return null;
    }

    public List<OrganizationalUnit> getOrganizationalUnits(Repository repository) {
        ArrayList<OrganizationalUnit> result = new ArrayList<OrganizationalUnit>();
        for (OrganizationalUnit organizationalUnit : this.registeredOrganizationalUnits.values()) {
            if (organizationalUnit.getRepositories() == null) continue;
            for (Repository ouRepository : organizationalUnit.getRepositories()) {
                if (!ouRepository.getAlias().equals(repository.getAlias())) continue;
                result.add(organizationalUnit);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public String getSanitizedDefaultGroupId(String proposedGroupId) {
        return proposedGroupId != null ? proposedGroupId.replaceAll("[^A-Za-z0-9_\\-.]", "") : proposedGroupId;
    }

    public Boolean isValidGroupId(String proposedGroupId) {
        if (proposedGroupId != null && !proposedGroupId.trim().isEmpty() && proposedGroupId.length() == this.getSanitizedDefaultGroupId(proposedGroupId).length()) {
            return true;
        }
        return false;
    }

    public void updateRegisteredOUCache(@Observes @org.guvnor.structure.backend.config.Repository SystemRepositoryChangedEvent changedEvent) {
        this.registeredOrganizationalUnits.clear();
        this.loadOrganizationalUnits();
    }

    public void updateRegisteredOUonRepoChange(@Observes RepositoryEnvironmentUpdatedEvent changedEvent) {
        this.registeredOrganizationalUnits.clear();
        this.loadOrganizationalUnits();
    }

    protected String getUserInfo(SessionInfo sessionInfo) {
        try {
            return sessionInfo.getIdentity().getIdentifier();
        }
        catch (Exception e) {
            return "system";
        }
    }
}

