/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.config.ConfigurationFactoryImpl;
import org.guvnor.structure.backend.organizationalunit.OrganizationalUnitFactoryImpl;
import org.guvnor.structure.backend.organizationalunit.OrganizationalUnitServiceImpl;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.NewOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoAddedToOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoRemovedFromOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.UpdatedOrganizationalUnitEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.security.OrganizationalUnitAction;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.organizationalunit.OrganizationalUnitFactory;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class OrganizationalUnitServiceTest {
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private SpacesAPI spacesAPI;
    @Mock
    private ConfigurationService configurationService;
    @Spy
    @InjectMocks
    private ConfigurationFactoryImpl configurationFactory;
    private OrganizationalUnitFactoryImpl organizationalUnitFactory;
    private BackwardCompatibleUtil backward;
    @Mock
    private Event<NewOrganizationalUnitEvent> newOrganizationalUnitEvent;
    @Mock
    private Event<RemoveOrganizationalUnitEvent> removeOrganizationalUnitEvent;
    @Mock
    private Event<RepoAddedToOrganizationalUnitEvent> repoAddedToOrgUnitEvent;
    @Mock
    private Event<RepoRemovedFromOrganizationalUnitEvent> repoRemovedFromOrgUnitEvent;
    @Mock
    private Event<UpdatedOrganizationalUnitEvent> updatedOrganizationalUnitEvent;
    @Mock
    private AuthorizationManager authorizationManager;
    private SessionInfo sessionInfo;
    @Mock
    private RepositoryService repoService;
    @Mock
    private OrganizationalUnit orgUnit;
    @Mock
    private IOService ioService;
    @Mock
    private ConfiguredRepositories configuredRepositories;
    private OrganizationalUnitServiceImpl organizationalUnitService;

    @Before
    public void setUp() throws Exception {
        this.sessionInfo = new SessionInfoMock();
        this.backward = new BackwardCompatibleUtil((ConfigurationFactory)this.configurationFactory);
        this.organizationalUnitFactory = (OrganizationalUnitFactoryImpl)Mockito.spy((Object)new OrganizationalUnitFactoryImpl(this.repositoryService, this.backward, this.spacesAPI, this.configurationService, (ConfigurationFactory)this.configurationFactory));
        this.organizationalUnitService = new OrganizationalUnitServiceImpl(this.configurationService, (ConfigurationFactory)this.configurationFactory, (OrganizationalUnitFactory)this.organizationalUnitFactory, this.repoService, this.backward, this.newOrganizationalUnitEvent, this.removeOrganizationalUnitEvent, this.repoAddedToOrgUnitEvent, this.repoRemovedFromOrgUnitEvent, this.updatedOrganizationalUnitEvent, this.authorizationManager, this.spacesAPI, this.sessionInfo, this.ioService, this.configuredRepositories);
        this.organizationalUnitService.registeredOrganizationalUnits.put("A", this.orgUnit);
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.any(User.class))).thenReturn((Object)false);
    }

    @Test
    public void testAllOrgUnits() throws Exception {
        Collection orgUnits = this.organizationalUnitService.getAllOrganizationalUnits();
        Assert.assertEquals((long)1L, (long)orgUnits.size());
    }

    @Test
    public void testSecuredOrgUnits() throws Exception {
        Collection orgUnits = this.organizationalUnitService.getOrganizationalUnits();
        Assert.assertEquals((long)0L, (long)orgUnits.size());
    }

    @Test
    public void testSecuredOrgUnitsWithPermission() throws Exception {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.any(User.class))).thenReturn((Object)true);
        Collection orgUnits = this.organizationalUnitService.getOrganizationalUnits();
        Assert.assertEquals((long)1L, (long)orgUnits.size());
    }

    @Test
    public void testSecuredOrgUnitsToCollaborators() throws Exception {
        Mockito.when((Object)this.orgUnit.getContributors()).thenReturn(Collections.singletonList(new Contributor("admin", ContributorType.OWNER)));
        Collection orgUnits = this.organizationalUnitService.getOrganizationalUnits();
        Assert.assertEquals((long)1L, (long)orgUnits.size());
    }

    @Test
    public void createOrganizationalUnitWithDuplicatedNameTest() {
        this.setOUCreationPermission(true);
        OrganizationalUnit ou = this.organizationalUnitService.createOrganizationalUnit("a", "default.group.id");
        Assert.assertNull((Object)ou);
        ((OrganizationalUnitFactoryImpl)Mockito.verify((Object)this.organizationalUnitFactory, (VerificationMode)Mockito.never())).newOrganizationalUnit((ConfigGroup)Matchers.any());
    }

    @Test
    public void createValidOrganizationalUnitTest() {
        ArrayList<Contributor> contributors = new ArrayList<Contributor>();
        contributors.add(new Contributor("admin", ContributorType.ADMIN));
        this.setOUCreationPermission(true);
        OrganizationalUnit ou = this.organizationalUnitService.createOrganizationalUnit("name", "default.group.id", new ArrayList(), contributors);
        Assert.assertNotNull((Object)ou);
        ((OrganizationalUnitFactoryImpl)Mockito.verify((Object)this.organizationalUnitFactory)).newOrganizationalUnit((ConfigGroup)Matchers.any());
        Assert.assertEquals((Object)"name", (Object)ou.getName());
        Assert.assertEquals((Object)"default.group.id", (Object)ou.getDefaultGroupId());
        Assert.assertEquals(contributors, (Object)ou.getContributors());
        URI configFSUri = URI.create(SpacesAPI.resolveConfigFileSystemPath((SpacesAPI.Scheme)SpacesAPI.Scheme.DEFAULT, (String)"name"));
        HashMap<String, Object> env = new HashMap<String, Object>(){
            {
                this.put("init", Boolean.TRUE);
                this.put("internal", Boolean.TRUE);
            }
        };
        ((IOService)Mockito.verify((Object)this.ioService)).newFileSystem(configFSUri, (Map)env);
    }

    @Test
    public void removeOrganizationalUnitRemovesRepositories() throws Exception {
        Repository repoA = (Repository)Mockito.mock(Repository.class);
        Repository repoB = (Repository)Mockito.mock(Repository.class);
        List<Repository> repos = Arrays.asList(repoA, repoB);
        Mockito.when((Object)repoA.getAlias()).thenReturn((Object)"A");
        Mockito.when((Object)repoB.getAlias()).thenReturn((Object)"B");
        Space space = new Space("A");
        Mockito.when((Object)this.orgUnit.getRepositories()).thenReturn(repos);
        Mockito.when((Object)this.orgUnit.getSpace()).thenReturn((Object)space);
        ConfigGroup configGroup = new ConfigGroup();
        configGroup.setName("A");
        Mockito.when((Object)this.configurationService.getConfiguration(ConfigType.SPACE)).thenReturn(Collections.singletonList(configGroup));
        JGitPathImpl configPath = (JGitPathImpl)Mockito.mock(JGitPathImpl.class);
        JGitFileSystem fileSystem = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Git git = (Git)Mockito.mock(Git.class);
        org.eclipse.jgit.lib.Repository repository = (org.eclipse.jgit.lib.Repository)Mockito.mock(org.eclipse.jgit.lib.Repository.class);
        File directory = (File)Mockito.mock(File.class);
        Path fsPath = (Path)Mockito.mock(Path.class);
        ((File)Mockito.doReturn((Object)directory).when((Object)directory)).getParentFile();
        ((org.eclipse.jgit.lib.Repository)Mockito.doReturn((Object)directory).when((Object)repository)).getDirectory();
        ((Git)Mockito.doReturn((Object)repository).when((Object)git)).getRepository();
        ((JGitFileSystem)Mockito.doReturn((Object)git).when((Object)fileSystem)).getGit();
        ((JGitFileSystem)Mockito.doReturn((Object)fsPath).when((Object)fileSystem)).getPath("", new String[0]);
        ((JGitPathImpl)Mockito.doReturn((Object)fileSystem).when((Object)configPath)).getFileSystem();
        ((IOService)Mockito.doReturn((Object)configPath).when((Object)this.ioService)).get((URI)Matchers.any(URI.class));
        this.organizationalUnitService.removeOrganizationalUnit("A");
        ((RepositoryService)Mockito.verify((Object)this.repoService)).removeRepositories((Space)Matchers.eq((Object)space), (Set)Matchers.eq(new HashSet<String>(Arrays.asList("A", "B"))));
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(RemoveOrganizationalUnitEvent.class);
        ((Event)Mockito.verify(this.removeOrganizationalUnitEvent)).fire(eventCaptor.capture());
        RemoveOrganizationalUnitEvent event = (RemoveOrganizationalUnitEvent)eventCaptor.getValue();
        Assert.assertEquals(repos, (Object)event.getOrganizationalUnit().getRepositories());
        ((IOService)Mockito.verify((Object)this.ioService)).delete(fsPath, new DeleteOption[0]);
        ((File)Mockito.verify((Object)directory)).delete();
        Assert.assertEquals(repos, (Object)event.getOrganizationalUnit().getRepositories());
    }

    private void setOUCreationPermission(boolean hasPermission) {
        Mockito.when((Object)this.authorizationManager.authorize((ResourceType)Matchers.eq((Object)OrganizationalUnit.RESOURCE_TYPE), (ResourceAction)Matchers.eq((Object)OrganizationalUnitAction.CREATE), (User)Matchers.any(User.class))).thenReturn((Object)hasPermission);
    }
}

