/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import org.guvnor.structure.backend.config.ConfigurationFactoryImpl;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.backend.repositories.ConfiguredRepositoriesImpl;
import org.guvnor.structure.backend.repositories.SystemRepository;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryUpdatedEvent;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfiguredRepositoriesTest {
    public static final Space SPACE1 = new Space("space1");
    public static final String REPO1S1 = "single";
    public static final String REPO2S1 = "multibranch";
    public static final Space SPACE2 = new Space("space2");
    public static final String REPO1S2 = "singles2";
    public static final String REPO2S2 = "multibranchs2";
    public static final String REPO3S2 = "multibranchs3";
    @Mock
    ConfigurationService configurationService;
    @Mock
    RepositoryFactory repositoryFactory;
    @Mock
    Event<RepositoryUpdatedEvent> repositoryUpdatedEvent;
    @Spy
    ConfigurationFactoryImpl configurationFactory;
    private ConfiguredRepositories configuredRepositories;
    @Captor
    ArgumentCaptor<ConfigItem<List<Contributor>>> contributorsArgumentCaptor;

    @Before
    public void setUp() throws Exception {
        HashMap repoConfigsBySpace = new HashMap();
        ArrayList<ConfigGroup> space1RepoConfigs = new ArrayList<ConfigGroup>();
        space1RepoConfigs.add(this.addRepository(SPACE1, REPO1S1, Collections.singletonList(new Contributor("admin1", ContributorType.OWNER)), "master"));
        space1RepoConfigs.add(this.addRepository(SPACE1, REPO2S1, Collections.singletonList(new Contributor("admin1", ContributorType.OWNER)), "master", "dev", "release"));
        repoConfigsBySpace.put(SPACE1.getName(), space1RepoConfigs);
        ArrayList<ConfigGroup> space2RepoConfigs = new ArrayList<ConfigGroup>();
        space2RepoConfigs.add(this.addRepository(SPACE2, REPO1S2, Collections.emptyList(), "master"));
        space2RepoConfigs.add(this.addRepository(SPACE2, REPO2S2, Collections.emptyList(), "master", "dev", "release"));
        space2RepoConfigs.add(this.addRepository(SPACE2, REPO3S2, Collections.emptyList(), "master", "dev", "release"));
        repoConfigsBySpace.put(SPACE2.getName(), space2RepoConfigs);
        Mockito.when((Object)this.configurationService.getConfigurationByNamespace(ConfigType.REPOSITORY)).thenReturn(repoConfigsBySpace);
        List<ConfigGroup> spaces = Arrays.asList(this.createSpaceConfigGroup(SPACE1, Collections.singletonList(new Contributor("admin1", ContributorType.OWNER))), this.createSpaceConfigGroup(SPACE2, Collections.singletonList(new Contributor("admin2", ContributorType.OWNER))));
        Mockito.when((Object)this.configurationService.getConfiguration(ConfigType.SPACE)).thenReturn(spaces);
        this.configuredRepositories = new ConfiguredRepositoriesImpl(this.configurationService, this.repositoryFactory, (Repository)SystemRepository.SYSTEM_REPO, this.repositoryUpdatedEvent, (ConfigurationFactory)this.configurationFactory);
        this.configuredRepositories.reloadRepositories();
    }

    private ConfigGroup createSpaceConfigGroup(Space space, List<Contributor> contributors) {
        ConfigGroup configGroup = (ConfigGroup)Mockito.spy((Object)new ConfigGroup());
        configGroup.setName(space.getName());
        configGroup.addConfigItem(this.configurationFactory.newConfigItem("space-contributors", contributors));
        return configGroup;
    }

    private ConfigGroup addRepository(Space space, String alias, List<Contributor> contributors, String ... branches) {
        ConfigGroup configGroup = (ConfigGroup)Mockito.spy((Object)new ConfigGroup());
        if (contributors != null && !contributors.isEmpty()) {
            configGroup.addConfigItem(this.configurationFactory.newConfigItem("contributors", contributors));
        }
        GitRepository repository = new GitRepository(alias, space);
        HashMap<String, Branch> branchMap = new HashMap<String, Branch>();
        for (String branch : branches) {
            Path path = PathFactory.newPath((String)(alias + ".txt"), (String)("default://master@myteam/mortgages/" + alias + ".txt"));
            branchMap.put(branch, new Branch(branch, path));
        }
        repository.setBranches(branchMap);
        Mockito.when((Object)this.repositoryFactory.newRepository(configGroup)).thenReturn((Object)repository);
        return configGroup;
    }

    @Test
    public void testLoadRepositories() throws Exception {
        Assert.assertEquals((long)2L, (long)this.configuredRepositories.getAllConfiguredRepositories(SPACE1).size());
        Assert.assertEquals((long)3L, (long)this.configuredRepositories.getAllConfiguredRepositories(SPACE2).size());
    }

    @Test
    public void testLoadSingle() throws Exception {
        Repository single = this.configuredRepositories.getRepositoryByRepositoryAlias(SPACE1, REPO1S1);
        Assert.assertEquals((long)1L, (long)single.getBranches().size());
        Assert.assertNotNull((Object)single.getBranch("master"));
    }

    @Test
    public void testLoadMultiBranch() throws Exception {
        Repository single = this.configuredRepositories.getRepositoryByRepositoryAlias(SPACE1, REPO2S1);
        Assert.assertEquals((long)3L, (long)single.getBranches().size());
        Assert.assertNotNull((Object)single.getBranch("master"));
        Assert.assertNotNull((Object)single.getBranch("dev"));
        Assert.assertNotNull((Object)single.getBranch("release"));
    }

    @Test
    public void testRemoveSingle() throws Exception {
        Path root = ((Branch)this.configuredRepositories.getRepositoryByRepositoryAlias(SPACE1, REPO1S1).getDefaultBranch().get()).getPath();
        Assert.assertNotNull((Object)this.configuredRepositories.getRepositoryByRootPath(SPACE1, root));
        Assert.assertNotNull((Object)this.configuredRepositories.remove(SPACE1, REPO1S1));
        Assert.assertFalse((boolean)this.configuredRepositories.containsAlias(SPACE1, REPO1S1));
        Assert.assertNull((Object)this.configuredRepositories.getRepositoryByRootPath(SPACE1, root));
    }

    @Test
    public void testRemoveMultiBranch() throws Exception {
        Branch devBranch = (Branch)this.configuredRepositories.getRepositoryByRepositoryAlias(SPACE1, REPO2S1).getBranch("dev").get();
        Assert.assertNotNull((Object)this.configuredRepositories.getRepositoryByRootPath(SPACE1, devBranch.getPath()));
        Assert.assertNotNull((Object)this.configuredRepositories.remove(SPACE1, REPO2S1));
        Assert.assertFalse((boolean)this.configuredRepositories.containsAlias(SPACE1, REPO2S1));
        Assert.assertNull((Object)this.configuredRepositories.getRepositoryByRootPath(SPACE1, devBranch.getPath()));
    }

    @Test
    public void testContributorsWereSetOnReload() {
        Map repoBySpace = this.configurationService.getConfigurationByNamespace(ConfigType.REPOSITORY);
        repoBySpace.keySet().forEach(space -> ((List)repoBySpace.get(space)).forEach(repoConfigGroup -> {
            if (space.equals(SPACE1.getName())) {
                ((ConfigurationService)Mockito.verify((Object)this.configurationService, (VerificationMode)Mockito.never())).updateConfiguration(repoConfigGroup);
            } else {
                ((ConfigGroup)Mockito.verify((Object)repoConfigGroup)).addConfigItem((ConfigItem)this.contributorsArgumentCaptor.capture());
                ((ConfigurationService)Mockito.verify((Object)this.configurationService)).updateConfiguration(repoConfigGroup);
                ConfigItem configItem = (ConfigItem)this.contributorsArgumentCaptor.getValue();
                Assert.assertEquals((Object)"contributors", (Object)configItem.getName());
                List list = (List)configItem.getValue();
            }
        }));
    }
}

