/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.guvnor.structure.backend.repositories.git.GitMetadataStoreImpl;
import org.guvnor.structure.repositories.GitMetadata;
import org.guvnor.structure.repositories.impl.GitMetadataImpl;
import org.jgroups.util.Util;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.io.object.ObjectStorage;
import org.uberfire.backend.server.spaces.SpacesAPIImpl;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class GitMetadataImplStoreTest {
    private GitMetadataStoreImpl metadataStore;
    @Mock
    private ObjectStorage storage;
    private Map<String, GitMetadataImpl> metadatas;
    private SpacesAPIImpl spaces = new SpacesAPIImpl();

    @Before
    public void setUp() throws Exception {
        this.metadataStore = new GitMetadataStoreImpl(this.storage, (SpacesAPI)this.spaces);
        this.metadatas = new HashMap<String, GitMetadataImpl>();
        ((ObjectStorage)Mockito.doAnswer(invocationOnMock -> {
            String key = (String)invocationOnMock.getArgumentAt(0, String.class);
            GitMetadataImpl metadata = (GitMetadataImpl)invocationOnMock.getArgumentAt(1, GitMetadataImpl.class);
            this.metadatas.put(key, metadata);
            return null;
        }).when((Object)this.storage)).write(Mockito.anyString(), Mockito.any());
        ((ObjectStorage)Mockito.doAnswer(invocationOnMock -> {
            String key = (String)invocationOnMock.getArgumentAt(0, String.class);
            return this.metadatas.get(key);
        }).when((Object)this.storage)).read(Mockito.anyString());
        ((ObjectStorage)Mockito.doAnswer(invocationOnMock -> {
            String key = (String)invocationOnMock.getArgumentAt(0, String.class);
            return this.metadatas.remove(key);
        }).when((Object)this.storage)).delete(Mockito.anyString());
    }

    @Test
    public void testStorageInitialization() {
        this.metadataStore.init();
        ((ObjectStorage)Mockito.verify((Object)this.storage)).init((URI)Matchers.eq((Object)this.metadataStore.getMetadataFS()));
    }

    @Test
    public void testCreatesRightPathToSave() {
        this.metadataStore.write("test/repo", "");
        ((ObjectStorage)Mockito.verify((Object)this.storage)).write((String)Matchers.eq((Object)"/test/repo.metadata"), Matchers.anyObject());
    }

    @Test
    public void testFixRightPathToSave() {
        this.metadataStore.write("/test/repo", "");
        ((ObjectStorage)Mockito.verify((Object)this.storage)).write((String)Matchers.eq((Object)"/test/repo.metadata"), Matchers.anyObject());
    }

    @Test
    public void testWriteNewMetadataWithoutOrigin() {
        this.metadataStore.write("test/repo");
        Util.assertEquals((Object)"test/repo", (Object)this.metadatas.get("/test/repo.metadata").getName());
    }

    @Test
    public void testWriteNewMetadataWithOrigin() {
        this.metadataStore.write("test/repo", "other/repo");
        Util.assertEquals((Object)"test/repo", (Object)this.metadatas.get("/test/repo.metadata").getName());
        Util.assertEquals((Object)"other/repo", (Object)this.metadatas.get("/other/repo.metadata").getName());
    }

    @Test
    public void testChangeOriginFromMetedata() {
        this.metadataStore.write("test/repo", "other/repo");
        Util.assertEquals((Object)"test/repo", (Object)this.metadatas.get("/test/repo.metadata").getName());
        Util.assertEquals((Object)"other/repo", (Object)this.metadatas.get("/test/repo.metadata").getOrigin());
        Util.assertEquals((Object)"other/repo", (Object)this.metadatas.get("/other/repo.metadata").getName());
        this.metadataStore.write("test/repo", "other/otherOrigin");
        Util.assertEquals((Object)"other/otherOrigin", (Object)this.metadatas.get("/test/repo.metadata").getOrigin());
        Util.assertEquals((Object)0, (Object)this.metadatas.get("/other/repo.metadata").getForks().size());
    }

    @Test
    public void testWriteWithNullOrigin() {
        String origin = null;
        this.metadataStore.write("test/repo", origin);
        Util.assertEquals((Object)"test/repo", (Object)this.metadatas.get("/test/repo.metadata").getName());
    }

    @Test
    public void testWriteTwoForks() {
        this.metadataStore.write("test/repo", "origin/repo");
        this.metadataStore.write("fork/repo", "origin/repo");
        Util.assertEquals((Object)3, (Object)this.metadatas.size());
        Util.assertEquals((Object)"test/repo", (Object)this.metadatas.get("/test/repo.metadata").getName());
        Util.assertEquals((Object)"fork/repo", (Object)this.metadatas.get("/fork/repo.metadata").getName());
        Util.assertEquals((Object)"origin/repo", (Object)this.metadatas.get("/origin/repo.metadata").getName());
        Util.assertEquals((Object)2, (Object)this.metadatas.get("/origin/repo.metadata").getForks().size());
    }

    @Test
    public void testComplexForkTracking() {
        this.metadataStore.write("b/repo", "a/repo");
        this.metadataStore.write("c/repo", "b/repo");
        this.metadataStore.write("d/repo", "c/repo");
        Util.assertEquals((Object)"c/repo", (Object)((GitMetadata)this.metadataStore.read("d/repo").get()).getOrigin());
        Util.assertEquals((Object)"b/repo", (Object)((GitMetadata)this.metadataStore.read("c/repo").get()).getOrigin());
        Util.assertEquals((Object)"a/repo", (Object)((GitMetadata)this.metadataStore.read("b/repo").get()).getOrigin());
        Util.assertEquals((Object)"b/repo", ((GitMetadata)this.metadataStore.read("a/repo").get()).getForks().get(0));
        Util.assertEquals((Object)"c/repo", ((GitMetadata)this.metadataStore.read("b/repo").get()).getForks().get(0));
        Util.assertEquals((Object)"d/repo", ((GitMetadata)this.metadataStore.read("c/repo").get()).getForks().get(0));
    }

    @Test
    public void testSimpleDelete() {
        this.metadataStore.write("a/repo", "");
        Util.assertEquals((Object)"", (Object)((GitMetadata)this.metadataStore.read("a/repo").get()).getOrigin());
        this.metadataStore.delete("a/repo");
        Util.assertFalse((boolean)this.metadataStore.read("a/repo").isPresent());
    }

    @Test
    public void testComplexDelete() {
        this.metadataStore.write("b/repo", "a/repo");
        this.metadataStore.write("c/repo", "b/repo");
        this.metadataStore.write("d/repo", "c/repo");
        this.metadataStore.delete("c/repo");
        Util.assertEquals((Object)"", (Object)((GitMetadata)this.metadataStore.read("d/repo").get()).getOrigin());
        Util.assertEquals((Object)"a/repo", (Object)((GitMetadata)this.metadataStore.read("b/repo").get()).getOrigin());
        Util.assertEquals((Object)"b/repo", ((GitMetadata)this.metadataStore.read("a/repo").get()).getForks().get(0));
        Util.assertEquals((Object)0, (Object)((GitMetadata)this.metadataStore.read("b/repo").get()).getForks().size());
        Util.assertFalse((boolean)this.metadataStore.read("c/repo").isPresent());
    }
}

