/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javax.enterprise.event.Event;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.guvnor.structure.backend.repositories.git.GitRepositoryFactoryHelper;
import org.guvnor.structure.backend.repositories.git.hooks.PostCommitNotificationService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryExternalUpdateEvent;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.spaces.SpacesAPIImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.extensions.FileSystemHookExecutionContext;
import org.uberfire.java.nio.file.extensions.FileSystemHooks;
import org.uberfire.spaces.SpacesAPI;

public abstract class GitRepositoryFactoryHelperBaseTest {
    protected Mode mode;
    @Mock
    protected IOService indexed;
    @Mock
    protected IOService notIndexed;
    @Mock
    protected FileSystem fileSystem;
    @Mock
    protected Event<RepositoryExternalUpdateEvent> repositoryExternalUpdate;
    @Mock
    protected PostCommitNotificationService postCommitNotificationService;
    protected GitRepositoryFactoryHelper helper;
    protected ArrayList<Path> rootDirectories;
    protected SpacesAPI spacesAPI;

    public void init() {
        this.spacesAPI = new SpacesAPIImpl();
        this.helper = new GitRepositoryFactoryHelper(this.indexed, this.notIndexed, this.spacesAPI, this.repositoryExternalUpdate, this.postCommitNotificationService);
        if (Mode.INDEXED.equals((Object)this.mode)) {
            this.initServices(this.indexed, this.notIndexed);
        } else {
            this.initServices(this.notIndexed, this.indexed);
        }
        this.rootDirectories = new ArrayList();
        Mockito.when((Object)this.fileSystem.getRootDirectories()).thenReturn(this.rootDirectories);
    }

    private void initServices(IOService normal, IOService withException) {
        Mockito.when((Object)normal.newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap())).thenReturn((Object)this.fileSystem);
        Mockito.when((Object)withException.newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap())).thenThrow(new Throwable[]{new RuntimeException()});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoSchemeConfigItem() throws Exception {
        this.helper.newRepository(new ConfigGroup());
    }

    @Test(expected=IllegalStateException.class)
    public void testNotValid() throws Exception {
        this.helper.newRepository(this.getConfigGroup());
    }

    @Test
    public void testNewRepositoryDontReplaceIfExists() {
        this.rootDirectories.add(this.createPath("default://master@uf-playground"));
        ConfigGroup configGroup = this.getConfigGroup();
        configGroup.setName("test");
        ConfigItem configItem = new ConfigItem();
        configItem.setName("replaceIfExists");
        configItem.setValue((Object)false);
        configGroup.setConfigItem(configItem);
        IOService service = this.getServiceToTest();
        Mockito.when((Object)service.newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap())).thenThrow(new Class[]{FileSystemAlreadyExistsException.class});
        Mockito.when((Object)service.getFileSystem((URI)Matchers.any(URI.class))).thenReturn((Object)this.fileSystem);
        this.helper.newRepository(configGroup);
        ((IOService)Mockito.verify((Object)service, (VerificationMode)Mockito.never())).delete((Path)Matchers.any(Path.class), new DeleteOption[0]);
        ((IOService)Mockito.verify((Object)service, (VerificationMode)Mockito.times((int)1))).newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap());
    }

    @Test
    public void testNewRepositoryReplaceIfExists() {
        this.rootDirectories.add(this.createPath("default://master@uf-playground"));
        ConfigGroup configGroup = this.getConfigGroup();
        configGroup.setName("test");
        ConfigItem configItem = new ConfigItem();
        configItem.setName("replaceIfExists");
        configItem.setValue((Object)true);
        configGroup.setConfigItem(configItem);
        IOService service = this.getServiceToTest();
        Mockito.when((Object)service.newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap())).thenThrow(new Class[]{FileSystemAlreadyExistsException.class}).thenReturn((Object)this.fileSystem);
        Mockito.when((Object)service.getFileSystem((URI)Matchers.any(URI.class))).thenReturn((Object)this.fileSystem);
        this.helper.newRepository(configGroup);
        ((IOService)Mockito.verify((Object)service, (VerificationMode)Mockito.times((int)1))).delete((Path)Matchers.any(Path.class), new DeleteOption[0]);
        ((IOService)Mockito.verify((Object)service, (VerificationMode)Mockito.times((int)2))).newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap());
    }

    @Test
    public void testFileSystemHooks() {
        this.rootDirectories.add(this.createPath("default://master@uf-playground"));
        ConfigGroup configGroup = this.getConfigGroup();
        configGroup.setName("test");
        IOService service = this.getServiceToTest();
        this.helper.newRepository(configGroup);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Map.class);
        ((IOService)Mockito.verify((Object)service)).newFileSystem((URI)Matchers.any(URI.class), (Map)captor.capture());
        Map params = (Map)captor.getValue();
        Assertions.assertThat((Map)params).isNotNull();
        ((AbstractObjectAssert)Assertions.assertThat(params.get(FileSystemHooks.ExternalUpdate.name())).isNotNull()).isInstanceOf(FileSystemHooks.FileSystemHook.class);
        FileSystemHookExecutionContext ctx = new FileSystemHookExecutionContext("test");
        FileSystemHooks.FileSystemHook hook = (FileSystemHooks.FileSystemHook)params.get(FileSystemHooks.ExternalUpdate.name());
        hook.execute(ctx);
        ((Event)Mockito.verify(this.repositoryExternalUpdate)).fire(Matchers.any());
        ((AbstractObjectAssert)Assertions.assertThat(params.get(FileSystemHooks.PostCommit.name())).isNotNull()).isInstanceOf(FileSystemHooks.FileSystemHook.class);
        ctx.addParam("POST_COMMIT_EXIT_CODE", (Object)0);
        hook = (FileSystemHooks.FileSystemHook)params.get(FileSystemHooks.PostCommit.name());
        hook.execute(ctx);
        ((PostCommitNotificationService)Mockito.verify((Object)this.postCommitNotificationService)).notifyUser((GitRepository)Matchers.any(), Integer.valueOf(Mockito.eq((int)0)));
    }

    private IOService getServiceToTest() {
        if (Mode.INDEXED.equals((Object)this.mode)) {
            return this.indexed;
        }
        return this.notIndexed;
    }

    @Test
    public void testBranches() throws Exception {
        this.rootDirectories.add(this.createPath("default://origin@uf-playground"));
        this.rootDirectories.add(this.createPath("default://master@uf-playground"));
        this.rootDirectories.add(this.createPath("default://branch1@uf-playground"));
        ConfigGroup configGroup = this.getConfigGroup();
        configGroup.setName("test");
        Repository repository = this.helper.newRepository(configGroup);
        Assert.assertEquals((long)3L, (long)repository.getBranches().size());
        Assert.assertTrue((boolean)((Branch)repository.getDefaultBranch().get()).getPath().toURI().contains("master"));
    }

    protected Path createPath(String uri) {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.toUri()).thenReturn((Object)URI.create(uri));
        Mockito.when((Object)path.getFileSystem()).thenReturn((Object)this.fileSystem);
        return path;
    }

    protected ConfigGroup getConfigGroup() {
        ConfigGroup repoConfig = new ConfigGroup();
        ConfigItem configItem = new ConfigItem();
        configItem.setName("scheme");
        repoConfig.addConfigItem(configItem);
        configItem = new ConfigItem();
        configItem.setName("space");
        configItem.setValue((Object)"space");
        repoConfig.addConfigItem(configItem);
        return repoConfig;
    }

    static enum Mode {
        INDEXED,
        NOT_INDEXED;

    }
}

