/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.guvnor.structure.backend.repositories.PullRequestServiceImpl;
import org.guvnor.structure.backend.repositories.git.GitMetadataStoreImpl;
import org.guvnor.structure.repositories.GitMetadata;
import org.guvnor.structure.repositories.GitMetadataStore;
import org.guvnor.structure.repositories.PullRequest;
import org.guvnor.structure.repositories.PullRequestAlreadyExistsException;
import org.guvnor.structure.repositories.PullRequestService;
import org.guvnor.structure.repositories.PullRequestStatus;
import org.guvnor.structure.repositories.RepositoryNotFoundException;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.GitMetadataImpl;
import org.guvnor.structure.repositories.impl.PullRequestImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.io.object.ObjectStorage;
import org.uberfire.backend.server.spaces.SpacesAPIImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.MergeCopyOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class PullRequestServiceTest {
    private PullRequestService service;
    private GitMetadataStore metadataStore;
    @Mock
    private IOService ioService;
    @Mock
    private SpacesAPI spaces;
    @Mock
    private ObjectStorage storage;
    private Map<String, GitMetadataImpl> metadatas;

    @Before
    public void setUp() throws Exception {
        this.metadatas = new HashMap<String, GitMetadataImpl>();
        this.metadataStore = new GitMetadataStoreImpl(this.storage, (SpacesAPI)new SpacesAPIImpl());
        this.service = new PullRequestServiceImpl(this.metadataStore, this.ioService, (RepositoryService)Mockito.mock(RepositoryService.class), this.spaces);
        ((ObjectStorage)Mockito.doAnswer(invocationOnMock -> {
            String key = (String)invocationOnMock.getArgumentAt(0, String.class);
            GitMetadataImpl metadata = (GitMetadataImpl)invocationOnMock.getArgumentAt(1, GitMetadataImpl.class);
            this.metadatas.put(key, metadata);
            return null;
        }).when((Object)this.storage)).write(Mockito.anyString(), Mockito.any());
        ((ObjectStorage)Mockito.doAnswer(invocationOnMock -> {
            String key = (String)invocationOnMock.getArgumentAt(0, String.class);
            return this.metadatas.get(key);
        }).when((Object)this.storage)).read(Mockito.anyString());
        ((ObjectStorage)Mockito.doAnswer(invocationOnMock -> {
            String key = (String)invocationOnMock.getArgumentAt(0, String.class);
            return this.metadatas.remove(key);
        }).when((Object)this.storage)).delete(Mockito.anyString());
        this.metadataStore.write("parent/a");
        this.metadataStore.write("child/a", "parent/a");
    }

    @Test(expected=RepositoryNotFoundException.class)
    public void testCreatePullRequestToUnexistentRepository() {
        PullRequest pullRequest = this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "doesNotExist/a", "master");
    }

    @Test
    public void testCreatePullRequest() {
        PullRequest pullRequest = this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
        List pullRequests = this.service.getPullRequestsByBranch(Integer.valueOf(0), Integer.valueOf(0), pullRequest.getTargetRepository(), pullRequest.getTargetBranch());
        Assert.assertEquals((long)1L, (long)pullRequests.size());
        Assert.assertEquals((Object)PullRequestStatus.OPEN, (Object)((PullRequest)pullRequests.get(0)).getStatus());
    }

    @Test
    public void testCreateSeveralPullRequest() {
        String repository = "parent/a";
        String branch = "master";
        this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
        this.service.createPullRequest("test-realm", "child/b", "develop", "test-realm", "parent/a", "otherBranch");
        this.service.createPullRequest("test-realm", "child/c", "develop", "test-realm", "parent/a", "master");
        this.service.createPullRequest("test-realm", "child/d", "develop", "test-realm", "parent/a", "master");
        List pullRequests = this.service.getPullRequestsByRepository(Integer.valueOf(0), Integer.valueOf(0), "parent/a");
        Assert.assertEquals((long)4L, (long)pullRequests.size());
        Assert.assertTrue((boolean)pullRequests.stream().allMatch(elem -> elem.getStatus().equals((Object)PullRequestStatus.OPEN)));
    }

    @Test
    public void testAcceptPullRequest() {
        PullRequest pullRequest = this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
        this.service.acceptPullRequest(pullRequest);
        List pullRequests = this.service.getPullRequestsByBranch(Integer.valueOf(0), Integer.valueOf(0), pullRequest.getTargetRepository(), pullRequest.getTargetBranch());
        Assert.assertEquals((Object)PullRequestStatus.MERGED, (Object)((PullRequest)pullRequests.get(0)).getStatus());
        ((IOService)Mockito.verify((Object)this.ioService)).copy((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), new CopyOption[]{(CopyOption)Mockito.any(MergeCopyOption.class)});
    }

    @Test
    public void testExceptionWhenTryingtoAcceptPullRequest() {
        Mockito.when((Object)this.ioService.copy((Path)Mockito.any(Path.class), (Path)Mockito.any(Path.class), (CopyOption[])Mockito.any())).thenThrow(new Throwable[]{new RuntimeException("Mock exception")});
        PullRequest pullRequest = this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
        try {
            this.service.acceptPullRequest(pullRequest);
            Assert.fail((String)"Should throw exception before this point");
        }
        catch (Exception e) {
            List pullRequests = this.service.getPullRequestsByBranch(Integer.valueOf(0), Integer.valueOf(0), pullRequest.getTargetRepository(), pullRequest.getTargetBranch());
            Assert.assertEquals((Object)PullRequestStatus.OPEN, (Object)((PullRequest)pullRequests.get(0)).getStatus());
        }
    }

    @Test
    public void testFailToCreatePullRequest() {
        PullRequestImpl pullRequest = new PullRequestImpl("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
        ((ObjectStorage)Mockito.doThrow((Throwable)new RuntimeException("Mocked exception")).when((Object)this.storage)).write((String)Mockito.any(String.class), Mockito.any(GitMetadata.class));
        try {
            pullRequest = this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
            Assert.fail((String)"Should throw exception before this point");
        }
        catch (Exception e) {
            List pullRequests = this.service.getPullRequestsByBranch(Integer.valueOf(0), Integer.valueOf(0), pullRequest.getTargetRepository(), pullRequest.getTargetBranch());
            Assert.assertEquals((long)0L, (long)pullRequests.size());
        }
    }

    @Test
    public void testRejectPullRequest() {
        PullRequest pullRequest = this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
        this.service.rejectPullRequest(pullRequest);
        List pullRequests = this.service.getPullRequestsByBranch(Integer.valueOf(0), Integer.valueOf(0), pullRequest.getTargetRepository(), pullRequest.getTargetBranch());
        Assert.assertEquals((Object)PullRequestStatus.REJECTED, (Object)((PullRequest)pullRequests.get(0)).getStatus());
    }

    @Test
    public void testClosePullRequest() {
        PullRequest pullRequest = this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
        this.service.closePullRequest(pullRequest);
        List pullRequests = this.service.getPullRequestsByBranch(Integer.valueOf(0), Integer.valueOf(0), pullRequest.getTargetRepository(), pullRequest.getTargetBranch());
        Assert.assertEquals((Object)PullRequestStatus.CLOSED, (Object)((PullRequest)pullRequests.get(0)).getStatus());
    }

    @Test
    public void testChangeStatusToMergedPullRequest() {
        PullRequest pullRequest = this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
        ((PullRequestServiceImpl)this.service).changePullRequestStatus(pullRequest.getTargetRepository(), pullRequest.getId(), PullRequestStatus.MERGED);
        List pullRequests = this.service.getPullRequestsByBranch(Integer.valueOf(0), Integer.valueOf(0), pullRequest.getTargetRepository(), pullRequest.getTargetBranch());
        Assert.assertEquals((Object)PullRequestStatus.MERGED, (Object)((PullRequest)pullRequests.get(0)).getStatus());
    }

    @Test
    public void testChangeStatusToClosedPullRequest() {
        PullRequest pullRequest = this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
        ((PullRequestServiceImpl)this.service).changePullRequestStatus(pullRequest.getTargetRepository(), pullRequest.getId(), PullRequestStatus.CLOSED);
        List pullRequests = this.service.getPullRequestsByBranch(Integer.valueOf(0), Integer.valueOf(0), pullRequest.getTargetRepository(), pullRequest.getTargetBranch());
        Assert.assertEquals((Object)PullRequestStatus.CLOSED, (Object)((PullRequest)pullRequests.get(0)).getStatus());
    }

    @Test
    public void testDeletePullRequest() {
        PullRequest pullRequest = this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
        this.service.deletePullRequest(pullRequest);
        List pullRequests = this.service.getPullRequestsByBranch(Integer.valueOf(0), Integer.valueOf(0), pullRequest.getTargetRepository(), pullRequest.getTargetBranch());
        Assert.assertEquals((long)0L, (long)pullRequests.size());
    }

    @Test
    public void testGetAllPullRequests() {
        this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
        this.service.createPullRequest("test-realm", "child/b", "develop", "test-realm", "parent/a", "develop");
        this.service.createPullRequest("test-realm", "child/c", "develop", "test-realm", "parent/a", "master");
        List pullRequestsForBranchMaster = this.service.getPullRequestsByBranch(Integer.valueOf(0), Integer.valueOf(0), "parent/a", "master");
        List pullRequestsForBranchDevelop = this.service.getPullRequestsByBranch(Integer.valueOf(0), Integer.valueOf(0), "parent/a", "develop");
        List pullRequestsForRepository = this.service.getPullRequestsByRepository(Integer.valueOf(0), Integer.valueOf(0), "parent/a");
        Assert.assertEquals((long)2L, (long)pullRequestsForBranchMaster.size());
        Assert.assertEquals((long)1L, (long)pullRequestsForBranchDevelop.size());
        Assert.assertEquals((long)3L, (long)pullRequestsForRepository.size());
    }

    @Test
    public void testGetAllPullRequestsWithDifferentStatus() {
        PullRequest pullRequestA = this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
        PullRequest pullRequestB = this.service.createPullRequest("test-realm", "child/b", "develop", "test-realm", "parent/a", "develop");
        PullRequest pullRequestC = this.service.createPullRequest("test-realm", "child/c", "develop", "test-realm", "parent/a", "master");
        PullRequest pullRequestD = this.service.createPullRequest("test-realm", "child/d", "develop", "test-realm", "parent/a", "master");
        this.service.acceptPullRequest(pullRequestA);
        this.service.rejectPullRequest(pullRequestB);
        this.service.closePullRequest(pullRequestC);
        List pullRequestsMerged = this.service.getPullRequestsByStatus(Integer.valueOf(0), Integer.valueOf(0), "parent/a", PullRequestStatus.MERGED);
        List pullRequestsClosed = this.service.getPullRequestsByStatus(Integer.valueOf(0), Integer.valueOf(0), "parent/a", PullRequestStatus.CLOSED);
        List pullRequestsOpened = this.service.getPullRequestsByStatus(Integer.valueOf(0), Integer.valueOf(0), "parent/a", PullRequestStatus.OPEN);
        List pullRequestsRejected = this.service.getPullRequestsByStatus(Integer.valueOf(0), Integer.valueOf(0), "parent/a", PullRequestStatus.REJECTED);
        Assert.assertEquals((long)1L, (long)pullRequestsMerged.size());
        Assert.assertEquals((long)1L, (long)pullRequestsClosed.size());
        Assert.assertEquals((long)1L, (long)pullRequestsOpened.size());
        Assert.assertEquals((long)1L, (long)pullRequestsRejected.size());
    }

    @Test
    public void testGeneratePullRequestId() {
        PullRequest pullRequestOne = this.service.createPullRequest("test-realm", "child/a", "develop", "test-realm", "parent/a", "master");
        PullRequest pullRequestTwo = this.service.createPullRequest("test-realm", "child/a", "fix", "test-realm", "parent/a", "master");
        PullRequest pullRequestThree = this.service.createPullRequest("test-realm", "child/a", "fix", "test-realm", "parent/a", "develop");
        PullRequest pullRequestFour = this.service.createPullRequest("test-realm", "child/b", "fix", "test-realm", "parent/a", "master");
        Assert.assertEquals((long)1L, (long)pullRequestOne.getId());
        Assert.assertEquals((long)2L, (long)pullRequestTwo.getId());
        Assert.assertEquals((long)3L, (long)pullRequestThree.getId());
        Assert.assertEquals((long)4L, (long)pullRequestFour.getId());
    }

    @Test(expected=PullRequestAlreadyExistsException.class)
    public void testCannotCreateSamePullRequest() {
        this.service.createPullRequest("test-realm", "child/a", "fix", "test-realm", "parent/a", "master");
        this.service.createPullRequest("test-realm", "child/a", "fix", "test-realm", "parent/a", "master");
    }

    @Test
    public void testCreateANewPullRequestWhenItISClosed() {
        PullRequest pr1 = this.service.createPullRequest("test-realm", "child/a", "fix", "test-realm", "parent/a", "master");
        this.service.acceptPullRequest(pr1);
        PullRequest pr2 = this.service.createPullRequest("test-realm", "child/a", "fix", "test-realm", "parent/a", "master");
        this.service.acceptPullRequest(pr2);
        Assert.assertEquals((long)2L, (long)pr2.getId());
    }

    @Test
    public void testGeneratedNumbersWhenPRAlreadyExists() {
        PullRequest pr1 = this.service.createPullRequest("test-realm", "child/a", "fix", "test-realm", "parent/a", "master");
        try {
            PullRequest pullRequest = this.service.createPullRequest("test-realm", "child/a", "fix", "test-realm", "parent/a", "master");
        }
        catch (PullRequestAlreadyExistsException pullRequestAlreadyExistsException) {
            // empty catch block
        }
        PullRequest pr2 = this.service.createPullRequest("test-realm", "child/b", "fix", "test-realm", "parent/a", "master");
        Assert.assertEquals((long)2L, (long)pr2.getId());
    }

    @Test
    public void testBuildHiddenPath() {
        ((PullRequestServiceImpl)this.service).buildHiddenPath((PullRequest)new PullRequestImpl(1L, "test-realm", "source/a", "develop", "test-realm", "target/a", "master", PullRequestStatus.OPEN));
        URI uri = URI.create("git://PR-1-source/a/develop-master@target/a");
        ((IOService)Mockito.verify((Object)this.ioService)).get((URI)Mockito.eq((Object)uri));
    }

    @Test
    public void testBuildPath() {
        Path path = ((PullRequestServiceImpl)this.service).buildPath("source/a", "develop");
        URI uri = URI.create("git://develop@source/a");
        ((IOService)Mockito.verify((Object)this.ioService)).get(uri);
    }

    @Test
    public void testPagination() {
        PullRequestImpl pr = new PullRequestImpl(1L, "test-realm", "source/a", "develop", "test-realm", "target/a", "master", PullRequestStatus.OPEN);
        List<PullRequest> pullRequests = Arrays.asList(pr, pr, pr, pr, pr, pr, pr, pr, pr, pr);
        Assert.assertEquals((long)10L, (long)((PullRequestServiceImpl)this.service).paginate(Integer.valueOf(0), Integer.valueOf(0), pullRequests).size());
        Assert.assertEquals((long)10L, (long)((PullRequestServiceImpl)this.service).paginate(Integer.valueOf(0), Integer.valueOf(15), pullRequests).size());
        Assert.assertEquals((long)5L, (long)((PullRequestServiceImpl)this.service).paginate(Integer.valueOf(1), Integer.valueOf(5), pullRequests).size());
        Assert.assertEquals((long)1L, (long)((PullRequestServiceImpl)this.service).paginate(Integer.valueOf(9), Integer.valueOf(1), pullRequests).size());
    }
}

