/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.event.Event;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.config.ConfigurationFactoryImpl;
import org.guvnor.structure.backend.organizationalunit.OrganizationalUnitFactoryImpl;
import org.guvnor.structure.backend.organizationalunit.OrganizationalUnitServiceImpl;
import org.guvnor.structure.organizationalunit.NewOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoAddedToOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoRemovedFromOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.UpdatedOrganizationalUnitEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.security.OrganizationalUnitAction;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.organizationalunit.OrganizationalUnitFactory;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=MockitoJUnitRunner.class)
public class OrganizationalUnitServiceTest {
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private ConfigurationService configurationService;
    @Spy
    @InjectMocks
    private ConfigurationFactoryImpl configurationFactory;
    private OrganizationalUnitFactory organizationalUnitFactory;
    private BackwardCompatibleUtil backward;
    @Mock
    private Event<NewOrganizationalUnitEvent> newOrganizationalUnitEvent;
    @Mock
    private Event<RemoveOrganizationalUnitEvent> removeOrganizationalUnitEvent;
    @Mock
    private Event<RepoAddedToOrganizationalUnitEvent> repoAddedToOrgUnitEvent;
    @Mock
    private Event<RepoRemovedFromOrganizationalUnitEvent> repoRemovedFromOrgUnitEvent;
    @Mock
    private Event<UpdatedOrganizationalUnitEvent> updatedOrganizationalUnitEvent;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private SessionInfo sessionInfo;
    private OrganizationalUnitServiceImpl organizationalUnitService;

    @Before
    public void setUp() throws Exception {
        this.backward = new BackwardCompatibleUtil((ConfigurationFactory)this.configurationFactory);
        this.organizationalUnitFactory = (OrganizationalUnitFactory)Mockito.spy((Object)new OrganizationalUnitFactoryImpl(this.repositoryService, this.backward));
        this.organizationalUnitService = new OrganizationalUnitServiceImpl(this.configurationService, (ConfigurationFactory)this.configurationFactory, this.organizationalUnitFactory, this.backward, this.newOrganizationalUnitEvent, this.removeOrganizationalUnitEvent, this.repoAddedToOrgUnitEvent, this.repoRemovedFromOrgUnitEvent, this.updatedOrganizationalUnitEvent, this.authorizationManager, this.sessionInfo);
        this.organizationalUnitService.registeredOrganizationalUnits.put("A", Mockito.mock(OrganizationalUnit.class));
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(Resource.class), (User)Mockito.any(User.class))).thenReturn((Object)false);
    }

    @Test
    public void testAllOrgUnits() throws Exception {
        Collection orgUnits = this.organizationalUnitService.getAllOrganizationalUnits();
        Assert.assertEquals((long)orgUnits.size(), (long)1L);
    }

    @Test
    public void testSecuredOrgUnits() throws Exception {
        Collection orgUnits = this.organizationalUnitService.getOrganizationalUnits();
        Assert.assertEquals((long)orgUnits.size(), (long)0L);
    }

    @Test
    public void createOrganizationalUnitWithDuplicatedNameTest() {
        this.setOUCreationPermission(true);
        OrganizationalUnit ou = this.organizationalUnitService.createOrganizationalUnit("a", "owner", "default.group.id");
        Assert.assertNull((Object)ou);
        ((OrganizationalUnitFactory)Mockito.verify((Object)this.organizationalUnitFactory, (VerificationMode)Mockito.never())).newOrganizationalUnit((ConfigGroup)Mockito.any());
    }

    @Test
    public void createValidOrganizationalUnitTest() {
        ArrayList<String> contributors = new ArrayList<String>();
        contributors.add("admin");
        this.setOUCreationPermission(true);
        OrganizationalUnit ou = this.organizationalUnitService.createOrganizationalUnit("name", "owner", "default.group.id", new ArrayList(), contributors);
        Assert.assertNotNull((Object)ou);
        ((OrganizationalUnitFactory)Mockito.verify((Object)this.organizationalUnitFactory)).newOrganizationalUnit((ConfigGroup)Mockito.any());
        Assert.assertEquals((Object)"name", (Object)ou.getName());
        Assert.assertEquals((Object)"owner", (Object)ou.getOwner());
        Assert.assertEquals((Object)"default.group.id", (Object)ou.getDefaultGroupId());
        Assert.assertEquals(contributors, (Object)ou.getContributors());
    }

    private void setOUCreationPermission(boolean hasPermission) {
        Mockito.when((Object)this.authorizationManager.authorize((ResourceType)Mockito.eq((Object)OrganizationalUnit.RESOURCE_TYPE), (ResourceAction)Mockito.eq((Object)OrganizationalUnitAction.CREATE), (User)Mockito.any(User.class))).thenReturn((Object)hasPermission);
    }
}

