/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.config.ConfigurationFactoryImpl;
import org.guvnor.structure.backend.organizationalunit.OrganizationalUnitFactoryImpl;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.config.PasswordService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class OrganizationalUnitFactoryImplTest {
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private BackwardCompatibleUtil backward;
    @Mock
    private SpacesAPI spacesAPI;
    @Mock
    private ConfigurationService configurationService;
    @Mock
    private PasswordService secureService;
    private ConfigurationFactory configurationFactory;
    private OrganizationalUnitFactoryImpl factory;

    @Before
    public void setup() {
        ((BackwardCompatibleUtil)Mockito.doAnswer(invocationOnMock -> (ConfigGroup)invocationOnMock.getArgumentAt(0, ConfigGroup.class)).when((Object)this.backward)).compat((ConfigGroup)Matchers.any());
        ((RepositoryService)Mockito.doAnswer(invocationOnMock -> {
            Repository repository = (Repository)Mockito.mock(Repository.class);
            ((Repository)Mockito.doReturn((Object)invocationOnMock.getArgumentAt(0, Space.class)).when((Object)repository)).getSpace();
            ((Repository)Mockito.doReturn((Object)invocationOnMock.getArgumentAt(1, String.class)).when((Object)repository)).getAlias();
            return repository;
        }).when((Object)this.repositoryService)).getRepositoryFromSpace((Space)Matchers.any(Space.class), Matchers.anyString());
        this.configurationFactory = new ConfigurationFactoryImpl(this.secureService);
        this.factory = (OrganizationalUnitFactoryImpl)Mockito.spy((Object)new OrganizationalUnitFactoryImpl(this.repositoryService, this.backward, this.spacesAPI, this.configurationService, this.configurationFactory));
    }

    @Test
    public void newOrganizationalUnitTest() {
        ConfigGroup configGroup = this.generateOUConfigGroup("ou", "groupId", Collections.singletonList("repo1"), Collections.singletonList("group1"));
        List<Contributor> contributors = Arrays.asList(new Contributor("c1", ContributorType.OWNER), new Contributor("c2", ContributorType.ADMIN));
        configGroup.addConfigItem(this.configurationFactory.newConfigItem("space-contributors", contributors));
        OrganizationalUnit organizationalUnit = this.factory.newOrganizationalUnit(configGroup);
        ((ConfigurationService)Mockito.verify((Object)this.configurationService, (VerificationMode)Mockito.never())).updateConfiguration((ConfigGroup)Matchers.any());
        Assert.assertEquals((Object)"ou", (Object)organizationalUnit.getName());
        Assert.assertEquals((Object)"groupId", (Object)organizationalUnit.getDefaultGroupId());
        Assert.assertEquals((long)1L, (long)organizationalUnit.getRepositories().size());
        Assert.assertEquals((Object)"repo1", (Object)((Repository)((List)organizationalUnit.getRepositories()).get(0)).getAlias());
        Assert.assertEquals((long)1L, (long)organizationalUnit.getGroups().size());
        Assert.assertEquals((Object)"group1", ((List)organizationalUnit.getGroups()).get(0));
        Assert.assertEquals((long)2L, (long)organizationalUnit.getContributors().size());
        Assert.assertEquals((Object)"c1", (Object)((Contributor)((List)organizationalUnit.getContributors()).get(0)).getUsername());
        Assert.assertEquals((Object)ContributorType.OWNER, (Object)((Contributor)((List)organizationalUnit.getContributors()).get(0)).getType());
        Assert.assertEquals((Object)"c2", (Object)((Contributor)((List)organizationalUnit.getContributors()).get(1)).getUsername());
        Assert.assertEquals((Object)ContributorType.ADMIN, (Object)((Contributor)((List)organizationalUnit.getContributors()).get(1)).getType());
    }

    @Test
    public void newOrganizationalUnitWithOldContributorsTest() {
        ConfigGroup configGroup = this.generateOUConfigGroup("ou", "groupId", Collections.singletonList("repo1"), Collections.singletonList("group1"));
        configGroup.addConfigItem(this.configurationFactory.newConfigItem("owner", "owner"));
        List<String> contributors = Arrays.asList("c1", "c2");
        configGroup.addConfigItem(this.configurationFactory.newConfigItem("contributors", contributors));
        OrganizationalUnit organizationalUnit = this.factory.newOrganizationalUnit(configGroup);
        ((ConfigurationService)Mockito.verify((Object)this.configurationService)).updateConfiguration((ConfigGroup)Matchers.any());
        Assert.assertEquals((Object)"ou", (Object)organizationalUnit.getName());
        Assert.assertEquals((Object)"groupId", (Object)organizationalUnit.getDefaultGroupId());
        Assert.assertEquals((long)1L, (long)organizationalUnit.getRepositories().size());
        Assert.assertEquals((Object)"repo1", (Object)((Repository)((List)organizationalUnit.getRepositories()).get(0)).getAlias());
        Assert.assertEquals((long)1L, (long)organizationalUnit.getGroups().size());
        Assert.assertEquals((Object)"group1", ((List)organizationalUnit.getGroups()).get(0));
        Assert.assertEquals((long)3L, (long)organizationalUnit.getContributors().size());
        Assert.assertEquals((Object)"owner", (Object)((Contributor)((List)organizationalUnit.getContributors()).get(0)).getUsername());
        Assert.assertEquals((Object)ContributorType.OWNER, (Object)((Contributor)((List)organizationalUnit.getContributors()).get(0)).getType());
        Assert.assertEquals((Object)"c1", (Object)((Contributor)((List)organizationalUnit.getContributors()).get(1)).getUsername());
        Assert.assertEquals((Object)ContributorType.CONTRIBUTOR, (Object)((Contributor)((List)organizationalUnit.getContributors()).get(1)).getType());
        Assert.assertEquals((Object)"c2", (Object)((Contributor)((List)organizationalUnit.getContributors()).get(2)).getUsername());
        Assert.assertEquals((Object)ContributorType.CONTRIBUTOR, (Object)((Contributor)((List)organizationalUnit.getContributors()).get(2)).getType());
    }

    private ConfigGroup generateOUConfigGroup(String name, String defaultGroupId, List<String> repositories, List<String> groups) {
        ConfigGroup configGroup = this.configurationFactory.newConfigGroup(ConfigType.SPACE, name, "");
        configGroup.addConfigItem(this.configurationFactory.newConfigItem("defaultGroupId", defaultGroupId));
        configGroup.addConfigItem(this.configurationFactory.newConfigItem("repositories", repositories));
        configGroup.addConfigItem(this.configurationFactory.newConfigItem("security:groups", groups));
        return configGroup;
    }
}

