/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.pom;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.assertj.core.api.Assertions;
import org.guvnor.structure.backend.pom.PomEditor;
import org.guvnor.structure.backend.pom.PomEditorDefault;
import org.guvnor.structure.backend.pom.TestUtil;
import org.guvnor.structure.pom.DynamicPomDependency;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class PomEditorDefaultTest {
    private final String POM = "pom.xml";
    private PomEditor editor;
    private Path tmpRoot;
    private Path tmp;

    @Before
    public void setUp() throws Exception {
        this.editor = new PomEditorDefault();
        this.tmpRoot = Files.createTempDirectory((String)"repo", (FileAttribute[])new FileAttribute[0]);
        this.tmp = TestUtil.createAndCopyToDirectory(this.tmpRoot, "dummy", "target/test-classes/dummy");
    }

    @After
    public void tearDown() {
        if (this.tmpRoot != null) {
            TestUtil.rm(this.tmpRoot.toFile());
        }
    }

    @Test
    public void addEmptyDepTest() {
        DynamicPomDependency dep = new DynamicPomDependency("", "", "", "");
        boolean result = this.editor.addDependency(dep, PathFactory.newPath((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String)(this.tmp.toUri().toString() + File.separator + "pom.xml")));
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void addNullDepTest() {
        boolean result = this.editor.addDependency(null, PathFactory.newPath((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String)(this.tmp.toUri().toString() + File.separator + "pom.xml")));
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void addNullGroupIDTest() {
        DynamicPomDependency dep = new DynamicPomDependency(null, "junit", "4.12", "");
        boolean result = this.editor.addDependency(dep, PathFactory.newPath((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String)(this.tmp.toUri().toString() + File.separator + "pom.xml")));
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void addNullArtifactIDTest() {
        DynamicPomDependency dep = new DynamicPomDependency("junit", null, "4.12", "");
        boolean result = this.editor.addDependency(dep, PathFactory.newPath((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String)(this.tmp.toUri().toString() + File.separator + "pom.xml")));
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void addDepTest() {
        DynamicPomDependency dep = new DynamicPomDependency("junit", "junit", "4.12", "");
        boolean result = this.editor.addDependency(dep, PathFactory.newPath((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String)(this.tmp.toUri().toString() + File.separator + "pom.xml")));
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    public void addDepsTest() {
        DynamicPomDependency dep = new DynamicPomDependency("junit", "junit", "4.12", "");
        List<DynamicPomDependency> deps = Arrays.asList(dep);
        boolean result = this.editor.addDependencies(deps, PathFactory.newPath((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String)(this.tmp.toUri().toString() + File.separator + "pom.xml")));
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    public void addDuplicatedDepTest() {
        DynamicPomDependency dep = new DynamicPomDependency("javax.persistence", "javax.persistence-api", "2.2", "");
        boolean result = this.editor.addDependency(dep, PathFactory.newPath((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String)(this.tmp.toUri().toString() + File.separator + "pom.xml")));
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void addAndOverrideVersionDepTest() throws Exception {
        this.tmp = TestUtil.createAndCopyToDirectory(this.tmpRoot, "dummyOverride", "target/test-classes/dummy");
        DynamicPomDependency dep = new DynamicPomDependency("javax.persistence", "javax.persistence-api", "1.0.3.Final", "");
        List<DynamicPomDependency> deps = Arrays.asList(dep);
        boolean result = this.editor.addDependencies(deps, PathFactory.newPath((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String)(this.tmp.toUri().toString() + File.separator + "pom.xml")));
        Assertions.assertThat((boolean)result).isTrue();
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = reader.read((InputStream)new ByteArrayInputStream(Files.readAllBytes((Path)Paths.get((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String[])new String[0]))));
        Dependency changedDep = this.getDependency(model.getDependencies(), "javax.persistence", "javax.persistence-api");
        Assertions.assertThat((String)changedDep.getVersion()).isEqualTo((Object)"1.0.3.Final");
    }

    private Dependency getDependency(List<Dependency> deps, String groupId, String artifactId) {
        Dependency dependency = new Dependency();
        for (Dependency dep : deps) {
            if (!dep.getGroupId().equals(groupId) || !dep.getArtifactId().equals(artifactId)) continue;
            dependency.setGroupId(dep.getGroupId());
            dependency.setArtifactId(dep.getArtifactId());
            dependency.setVersion(dep.getVersion());
            dependency.setScope(dep.getScope());
            break;
        }
        return dependency;
    }

    @Test
    public void addDuplicatedDepsTest() {
        DynamicPomDependency dep = new DynamicPomDependency("javax.persistence", "javax.persistence-api", "2.2", "");
        List<DynamicPomDependency> deps = Arrays.asList(dep);
        boolean result = this.editor.addDependencies(deps, PathFactory.newPath((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String)(this.tmp.toUri().toString() + File.separator + "pom.xml")));
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void addAndOverrideVersionDepsTest() throws Exception {
        this.tmp = TestUtil.createAndCopyToDirectory(this.tmpRoot, "dummyOverride", "target/test-classes/dummyOverride");
        DynamicPomDependency dep = new DynamicPomDependency("junit", "junit", "4.13", "");
        DynamicPomDependency depTwo = new DynamicPomDependency("javax.persistence", "javax.persistence-api", "1.0.3.Final", "");
        List<DynamicPomDependency> deps = Arrays.asList(dep, depTwo);
        boolean result = this.editor.addDependencies(deps, PathFactory.newPath((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String)(this.tmp.toUri().toString() + File.separator + "pom.xml")));
        Assertions.assertThat((boolean)result).isTrue();
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = reader.read((InputStream)new ByteArrayInputStream(Files.readAllBytes((Path)Paths.get((String)(this.tmp.toAbsolutePath().toString() + File.separator + "pom.xml"), (String[])new String[0]))));
        Dependency changedDep = this.getDependency(model.getDependencies(), "javax.persistence", "javax.persistence-api");
        Assertions.assertThat((String)changedDep.getVersion()).isEqualTo((Object)"1.0.3.Final");
        changedDep = this.getDependency(model.getDependencies(), "junit", "junit");
        Assertions.assertThat((String)changedDep.getVersion()).isEqualTo((Object)"4.13");
    }
}

