/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.events.RepositoryContributorsUpdatedEvent;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageRegistryImpl;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.backend.repositories.RepositoryServiceImpl;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class RepositoryServiceImplTest {
    @Mock
    private Repository repository;
    @Mock
    private ConfiguredRepositories configuredRepositories;
    @Mock
    private SpaceConfigStorageRegistry registry;
    @Mock
    private Event<RepositoryContributorsUpdatedEvent> updatedEvent;
    @InjectMocks
    @Spy
    private RepositoryServiceImpl repositoryService;
    @Captor
    private ArgumentCaptor<RepositoryContributorsUpdatedEvent> captor;
    @Captor
    private ArgumentCaptor<RepositoryInfo> configCaptor;

    @Test
    public void testNotCreateNewAliasIfNecessary() {
        Mockito.when((Object)this.configuredRepositories.getRepositoryByRepositoryAlias((Space)Matchers.any(), (String)Matchers.eq((Object)"other-name"))).thenReturn((Object)this.repository);
        ((Repository)Mockito.doReturn(Optional.of(Mockito.mock(Branch.class))).when((Object)this.repository)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"alias").when((Object)this.repository)).getAlias();
        String newAlias = this.repositoryService.createFreshRepositoryAlias("alias", new Space("alias"));
        Assert.assertEquals((Object)"alias", (Object)newAlias);
    }

    @Test
    public void testCreateNewAliasIfNecessary() {
        Mockito.when((Object)this.configuredRepositories.getRepositoryByRepositoryAlias((Space)Matchers.any(), (String)Matchers.eq((Object)"alias"), Matchers.eq((boolean)true))).thenReturn((Object)this.repository);
        ((Repository)Mockito.doReturn(Optional.of(Mockito.mock(Branch.class))).when((Object)this.repository)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"alias").when((Object)this.repository)).getAlias();
        String newAlias = this.repositoryService.createFreshRepositoryAlias("alias", new Space("alias"));
        Assert.assertEquals((Object)"alias-1", (Object)newAlias);
    }

    @Test
    public void testCreateSecondNewAliasIfNecessary() {
        Mockito.when((Object)this.configuredRepositories.getRepositoryByRepositoryAlias((Space)Matchers.any(), (String)Matchers.eq((Object)"alias"), Matchers.eq((boolean)true))).thenReturn((Object)this.repository);
        Mockito.when((Object)this.configuredRepositories.getRepositoryByRepositoryAlias((Space)Matchers.any(), (String)Matchers.eq((Object)"alias-1"), Matchers.eq((boolean)true))).thenReturn((Object)this.repository);
        ((Repository)Mockito.doReturn(Optional.of(Mockito.mock(Branch.class))).when((Object)this.repository)).getDefaultBranch();
        ((Repository)Mockito.doReturn((Object)"alias").when((Object)this.repository)).getAlias();
        String newAlias = this.repositoryService.createFreshRepositoryAlias("alias", new Space("alias"));
        Assert.assertEquals((Object)"alias-2", (Object)newAlias);
    }

    @Test
    public void updateContributorsTest() {
        Space space = new Space("space");
        ((Repository)Mockito.doReturn((Object)space).when((Object)this.repository)).getSpace();
        ((Repository)Mockito.doReturn((Object)"alias").when((Object)this.repository)).getAlias();
        ((ConfiguredRepositories)Mockito.doReturn((Object)this.repository).when((Object)this.configuredRepositories)).getRepositoryByRepositoryAlias((Space)Matchers.any(), (String)Matchers.any());
        SpaceConfigStorage spaceConfigStorage = (SpaceConfigStorage)Mockito.mock(SpaceConfigStorage.class);
        ((SpaceConfigStorage)Mockito.doReturn((Object)new SpaceInfo("space", "defaultGroupId", Collections.emptyList(), new ArrayList<RepositoryInfo>(Arrays.asList(new RepositoryInfo("alias", false, new RepositoryConfiguration()))), Collections.emptyList())).when((Object)spaceConfigStorage)).loadSpaceInfo();
        ((SpaceConfigStorage)Mockito.doReturn((Object)true).when((Object)spaceConfigStorage)).isInitialized();
        Mockito.when((Object)this.registry.get(Mockito.anyString())).thenReturn((Object)spaceConfigStorage);
        Mockito.when((Object)this.registry.getBatch(Mockito.anyString())).thenReturn((Object)new SpaceConfigStorageRegistryImpl.SpaceStorageBatchImpl(spaceConfigStorage));
        String username = "admin1";
        this.repositoryService.updateContributors(this.repository, Collections.singletonList(new Contributor(username, ContributorType.OWNER)));
        ((Event)Mockito.verify(this.updatedEvent)).fire(this.captor.capture());
        Assert.assertEquals((Object)"alias", (Object)((RepositoryContributorsUpdatedEvent)this.captor.getValue()).getRepository().getAlias());
        Assert.assertEquals((Object)"space", (Object)((RepositoryContributorsUpdatedEvent)this.captor.getValue()).getRepository().getSpace().getName());
        ((RepositoryServiceImpl)Mockito.verify((Object)this.repositoryService)).saveRepositoryConfig((String)Matchers.eq((Object)"space"), (RepositoryInfo)this.configCaptor.capture());
        Assert.assertEquals((Object)username, (Object)((Contributor)((RepositoryInfo)this.configCaptor.getValue()).getContributors().get(0)).getUsername());
        Assert.assertEquals((Object)ContributorType.OWNER, (Object)((Contributor)((RepositoryInfo)this.configCaptor.getValue()).getContributors().get(0)).getType());
        ((SpaceConfigStorage)Mockito.verify((Object)spaceConfigStorage)).startBatch();
        ((SpaceConfigStorage)Mockito.verify((Object)spaceConfigStorage)).saveSpaceInfo((SpaceInfo)Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)spaceConfigStorage)).endBatch();
    }
}

