/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit.config;

import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageImpl;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.io.object.ObjectStorage;
import org.uberfire.io.IOService;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceConfigStorageImplTest {
    @Mock
    private ObjectStorage objectStorage;
    @Mock
    private IOService ioService;
    private SpaceConfigStorageImpl spaceConfigStorage;

    @Before
    public void setup() {
        this.spaceConfigStorage = (SpaceConfigStorageImpl)Mockito.spy((Object)new SpaceConfigStorageImpl(this.objectStorage, this.ioService));
    }

    @Test
    public void loadCustomBranchPermissionsTest() {
        BranchPermissions customBranchPermissions = (BranchPermissions)Mockito.mock(BranchPermissions.class);
        ((ObjectStorage)Mockito.doReturn((Object)customBranchPermissions).when((Object)this.objectStorage)).read("/config/myProject/myBranch/BranchPermissions.json");
        BranchPermissions branchPermissions = this.spaceConfigStorage.loadBranchPermissions("myBranch", "myProject");
        Assert.assertSame((Object)customBranchPermissions, (Object)branchPermissions);
    }

    @Test
    public void loadDefaultBranchPermissionsTest() {
        BranchPermissions defaultBranchPermissions = (BranchPermissions)Mockito.mock(BranchPermissions.class);
        ((SpaceConfigStorageImpl)Mockito.doReturn((Object)defaultBranchPermissions).when((Object)this.spaceConfigStorage)).getDefaultBranchPermissions("myBranch");
        BranchPermissions branchPermissions = this.spaceConfigStorage.loadBranchPermissions("myBranch", "myProject");
        Assert.assertSame((Object)defaultBranchPermissions, (Object)branchPermissions);
    }

    @Test
    public void saveBranchPermissionsTest() {
        BranchPermissions customBranchPermissions = (BranchPermissions)Mockito.mock(BranchPermissions.class);
        this.spaceConfigStorage.saveBranchPermissions("myBranch", "myProject", customBranchPermissions);
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).write((String)Mockito.eq((Object)"/config/myProject/myBranch/BranchPermissions.json"), Mockito.same((Object)customBranchPermissions));
    }

    @Test
    public void deleteBranchPermissionsTest() {
        this.spaceConfigStorage.deleteBranchPermissions("myBranch", "myProject");
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/config/myProject/myBranch/BranchPermissions.json"));
    }
}

