/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.backend.repositories.ConfiguredRepositoriesBySpace;
import org.guvnor.structure.backend.repositories.SystemRepository;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.spaces.Space;

@ApplicationScoped
public class ConfiguredRepositoriesImpl
implements ConfiguredRepositories {
    private ConfigurationService configurationService;
    private RepositoryFactory repositoryFactory;
    private Repository systemRepository;
    private Map<Space, ConfiguredRepositoriesBySpace> repositoriesBySpace = new HashMap<Space, ConfiguredRepositoriesBySpace>();

    public ConfiguredRepositoriesImpl() {
    }

    @Inject
    public ConfiguredRepositoriesImpl(ConfigurationService configurationService, RepositoryFactory repositoryFactory, @Named(value="system") Repository systemRepository) {
        this.configurationService = configurationService;
        this.repositoryFactory = repositoryFactory;
        this.systemRepository = systemRepository;
    }

    @Override
    @PostConstruct
    public void reloadRepositories() {
        this.repositoriesBySpace.values().forEach(r -> r.clear());
        Map repoConfigsBySpace = this.configurationService.getConfigurationByNamespace(ConfigType.REPOSITORY);
        for (Map.Entry entry : repoConfigsBySpace.entrySet()) {
            Space space = new Space((String)entry.getKey());
            ConfiguredRepositoriesBySpace configuredRepositoriesBySpace = this.getConfiguredRepositoriesBySpace(space);
            for (ConfigGroup repoConfig : (List)entry.getValue()) {
                Repository repository = this.repositoryFactory.newRepository(repoConfig);
                configuredRepositoriesBySpace.add(repository);
            }
        }
    }

    @Override
    public Repository getRepositoryByRepositoryAlias(Space space, String alias) {
        ConfiguredRepositoriesBySpace configuredRepositoriesBySpace = this.getConfiguredRepositoriesBySpace(space);
        return configuredRepositoriesBySpace.get(alias);
    }

    private ConfiguredRepositoriesBySpace getConfiguredRepositoriesBySpace(Space space) {
        this.repositoriesBySpace.putIfAbsent(space, new ConfiguredRepositoriesBySpace());
        return this.repositoriesBySpace.get(space);
    }

    @Override
    public Repository getRepositoryByRepositoryFileSystem(FileSystem fs) {
        if (fs == null) {
            return null;
        }
        if (this.systemRepository.getDefaultBranch().isPresent() && Paths.convert((Path)((Branch)this.systemRepository.getDefaultBranch().get()).getPath()).getFileSystem().equals(fs)) {
            return this.systemRepository;
        }
        for (ConfiguredRepositoriesBySpace configuredRepositoriesBySpace : this.repositoriesBySpace.values()) {
            for (Repository repository : configuredRepositoriesBySpace.getAllConfiguredRepositories()) {
                if (!repository.getDefaultBranch().isPresent() || !Paths.convert((Path)((Branch)repository.getDefaultBranch().get()).getPath()).getFileSystem().equals(fs)) continue;
                return repository;
            }
        }
        return null;
    }

    @Override
    public Repository getRepositoryByRootPath(Space space, Path root) {
        ConfiguredRepositoriesBySpace configuredRepositoriesBySpace = this.getConfiguredRepositoriesBySpace(space);
        return configuredRepositoriesBySpace.get(root);
    }

    @Override
    public List<Repository> getAllConfiguredRepositories(Space space) {
        ConfiguredRepositoriesBySpace configuredRepositoriesBySpace = this.getConfiguredRepositoriesBySpace(space);
        return new ArrayList<Repository>(configuredRepositoriesBySpace.getAllConfiguredRepositories());
    }

    @Override
    public boolean containsAlias(Space space, String alias) {
        ConfiguredRepositoriesBySpace configuredRepositoriesBySpace = this.getConfiguredRepositoriesBySpace(space);
        return configuredRepositoriesBySpace.containsRepository(alias) || SystemRepository.SYSTEM_REPO.getAlias().equals(alias);
    }

    @Override
    public Repository remove(Space space, String alias) {
        ConfiguredRepositoriesBySpace configuredRepositoriesBySpace = this.getConfiguredRepositoriesBySpace(space);
        return configuredRepositoriesBySpace.remove(alias);
    }

    @Override
    public void add(Space space, Repository alias) {
        ConfiguredRepositoriesBySpace configuredRepositoriesBySpace = this.getConfiguredRepositoriesBySpace(space);
        configuredRepositoriesBySpace.add(alias);
    }

    @Override
    public void update(Space space, Repository updatedRepo) {
        ConfiguredRepositoriesBySpace configuredRepositoriesBySpace = this.getConfiguredRepositoriesBySpace(space);
        configuredRepositoriesBySpace.remove(updatedRepo.getAlias());
        configuredRepositoriesBySpace.add(updatedRepo);
    }

    public void flush(@Observes @org.guvnor.structure.backend.config.Repository SystemRepositoryChangedEvent changedEvent) {
        this.reloadRepositories();
    }
}

