/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.net.URI;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.backend.repositories.RepositoryCopierImpl;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mocks.FileSystemTestingUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class RepositoryCopierImplTest {
    private static final String PATH_PREFIX = "git://amend-repo-test/";
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    @Mock
    private EventSourceMock<NewBranchEvent> newBranchEventEvent;
    @Mock
    private ConfiguredRepositories configuredRepositories;
    @Mock
    private RepositoryService repositoryService;
    private RepositoryCopierImpl copier;
    private IOService ioService;

    @Before
    public void setUp() throws Exception {
        fileSystemTestingUtils.setup();
        this.ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        this.copier = new RepositoryCopierImpl(this.ioService, this.newBranchEventEvent, this.configuredRepositories, this.repositoryService);
    }

    @After
    public void cleanupFileSystem() {
        fileSystemTestingUtils.cleanup();
    }

    @Test
    public void makeSafeName() throws Exception {
        Assert.assertEquals((Object)"hello", (Object)this.copier.makeSafeRepositoryName("hello"));
        Assert.assertEquals((Object)"test-this", (Object)this.copier.makeSafeRepositoryName("test this"));
    }

    @Test
    public void withExistingBranch() throws Exception {
        Path nioFrom = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/from"));
        org.uberfire.backend.vfs.Path from = Paths.convert((Path)nioFrom);
        fileSystemTestingUtils.getIoService().createDirectory(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/from/sub1")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createDirectory(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/from/sub2")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/from/sub1/file1.txt")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/from/sub1/file2.txt")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/from/sub2/file3.txt")), new FileAttribute[0]);
        Path nioTo = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/to"));
        org.uberfire.backend.vfs.Path to = Paths.convert((Path)nioTo);
        fileSystemTestingUtils.getIoService().createDirectory(nioTo, new FileAttribute[0]);
        ((RepositoryService)Mockito.doReturn((Object)Mockito.mock(Repository.class)).when((Object)this.repositoryService)).getRepository(to);
        this.copier.copy(from, to);
        ((IOService)Mockito.verify((Object)this.ioService)).startBatch(fileSystemTestingUtils.getFileSystem());
        ((IOService)Mockito.verify((Object)this.ioService)).endBatch();
        ((EventSourceMock)Mockito.verify(this.newBranchEventEvent, (VerificationMode)Mockito.never())).fire(Mockito.any(NewBranchEvent.class));
    }
}

