/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.HashMap;
import javax.enterprise.event.Event;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.backend.repositories.ConfiguredRepositoriesImpl;
import org.guvnor.structure.backend.repositories.SystemRepository;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryUpdatedEvent;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfiguredRepositoriesTest {
    public static final Space SPACE1 = new Space("space1");
    public static final String REPO1S1 = "single";
    public static final String REPO2S1 = "multibranch";
    public static final Space SPACE2 = new Space("space2");
    public static final String REPO1S2 = "singles2";
    public static final String REPO2S2 = "multibranchs2";
    public static final String REPO2S3 = "multibranchs3";
    @Mock
    ConfigurationService configurationService;
    @Mock
    RepositoryFactory repositoryFactory;
    @Mock
    Event<RepositoryUpdatedEvent> repositoryUpdatedEvent;
    private ConfiguredRepositories configuredRepositories;

    @Before
    public void setUp() throws Exception {
        HashMap repoConfigsBySpace = new HashMap();
        ArrayList<ConfigGroup> space1RepoConfigs = new ArrayList<ConfigGroup>();
        space1RepoConfigs.add(this.addRepository(SPACE1, REPO1S1, "master"));
        space1RepoConfigs.add(this.addRepository(SPACE1, REPO2S1, "master", "dev", "release"));
        repoConfigsBySpace.put(SPACE1.getName(), space1RepoConfigs);
        ArrayList<ConfigGroup> space2RepoConfigs = new ArrayList<ConfigGroup>();
        space2RepoConfigs.add(this.addRepository(SPACE2, REPO1S2, "master"));
        space2RepoConfigs.add(this.addRepository(SPACE2, REPO2S2, "master", "dev", "release"));
        space2RepoConfigs.add(this.addRepository(SPACE2, REPO2S3, "master", "dev", "release"));
        repoConfigsBySpace.put(SPACE2.getName(), space2RepoConfigs);
        Mockito.when((Object)this.configurationService.getConfigurationByNamespace(ConfigType.REPOSITORY)).thenReturn(repoConfigsBySpace);
        this.configuredRepositories = new ConfiguredRepositoriesImpl(this.configurationService, this.repositoryFactory, (Repository)SystemRepository.SYSTEM_REPO, this.repositoryUpdatedEvent);
        this.configuredRepositories.reloadRepositories();
    }

    private ConfigGroup addRepository(Space space, String alias, String ... branches) {
        ConfigGroup configGroup = new ConfigGroup();
        GitRepository repository = new GitRepository(alias, space);
        HashMap<String, Branch> branchMap = new HashMap<String, Branch>();
        for (String branch : branches) {
            Path path = PathFactory.newPath((String)(alias + ".txt"), (String)("default://master@myteam/mortgages/" + alias + ".txt"));
            branchMap.put(branch, new Branch(branch, path));
        }
        repository.setBranches(branchMap);
        Mockito.when((Object)this.repositoryFactory.newRepository(configGroup)).thenReturn((Object)repository);
        return configGroup;
    }

    @Test
    public void testLoadRepositories() throws Exception {
        Assert.assertEquals((long)2L, (long)this.configuredRepositories.getAllConfiguredRepositories(SPACE1).size());
        Assert.assertEquals((long)3L, (long)this.configuredRepositories.getAllConfiguredRepositories(SPACE2).size());
    }

    @Test
    public void testLoadSingle() throws Exception {
        Repository single = this.configuredRepositories.getRepositoryByRepositoryAlias(SPACE1, REPO1S1);
        Assert.assertEquals((long)1L, (long)single.getBranches().size());
        Assert.assertNotNull((Object)single.getBranch("master"));
    }

    @Test
    public void testLoadMultiBranch() throws Exception {
        Repository single = this.configuredRepositories.getRepositoryByRepositoryAlias(SPACE1, REPO2S1);
        Assert.assertEquals((long)3L, (long)single.getBranches().size());
        Assert.assertNotNull((Object)single.getBranch("master"));
        Assert.assertNotNull((Object)single.getBranch("dev"));
        Assert.assertNotNull((Object)single.getBranch("release"));
    }

    @Test
    public void testRemoveSingle() throws Exception {
        Path root = ((Branch)this.configuredRepositories.getRepositoryByRepositoryAlias(SPACE1, REPO1S1).getDefaultBranch().get()).getPath();
        Assert.assertNotNull((Object)this.configuredRepositories.getRepositoryByRootPath(SPACE1, root));
        Assert.assertNotNull((Object)this.configuredRepositories.remove(SPACE1, REPO1S1));
        Assert.assertFalse((boolean)this.configuredRepositories.containsAlias(SPACE1, REPO1S1));
        Assert.assertNull((Object)this.configuredRepositories.getRepositoryByRootPath(SPACE1, root));
    }

    @Test
    public void testRemoveMultiBranch() throws Exception {
        Branch devBranch = (Branch)this.configuredRepositories.getRepositoryByRepositoryAlias(SPACE1, REPO2S1).getBranch("dev").get();
        Assert.assertNotNull((Object)this.configuredRepositories.getRepositoryByRootPath(SPACE1, devBranch.getPath()));
        Assert.assertNotNull((Object)this.configuredRepositories.remove(SPACE1, REPO2S1));
        Assert.assertFalse((boolean)this.configuredRepositories.containsAlias(SPACE1, REPO2S1));
        Assert.assertNull((Object)this.configuredRepositories.getRepositoryByRootPath(SPACE1, devBranch.getPath()));
    }
}

