/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import java.net.URI;
import java.util.ArrayList;
import org.guvnor.structure.backend.repositories.git.GitRepositoryFactoryHelper;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.spaces.SpacesAPIImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.spaces.SpacesAPI;

public class GitRepositoryFactoryHelperNoIndexTest {
    private IOService indexed;
    private IOService notIndexed;
    private GitRepositoryFactoryHelper helper;
    private FileSystem fileSystem;
    private ArrayList<Path> rootDirectories;
    private SpacesAPI spacesAPI;

    @Before
    public void setUp() throws Exception {
        this.indexed = (IOService)Mockito.mock(IOService.class);
        this.notIndexed = (IOService)Mockito.mock(IOService.class);
        this.spacesAPI = new SpacesAPIImpl();
        this.helper = new GitRepositoryFactoryHelper(this.indexed, this.notIndexed, this.spacesAPI, null);
        this.fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.notIndexed.newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap())).thenReturn((Object)this.fileSystem);
        Mockito.when((Object)this.indexed.newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap())).thenThrow(new Throwable[]{new RuntimeException()});
        this.rootDirectories = new ArrayList();
        Mockito.when((Object)this.fileSystem.getRootDirectories()).thenReturn(this.rootDirectories);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoSchemeConfigItem() throws Exception {
        this.helper.newRepository(new ConfigGroup());
    }

    @Test(expected=IllegalStateException.class)
    public void testNotValid() throws Exception {
        this.helper.newRepository(this.getConfigGroup());
    }

    @Test
    public void testNewRepositoryDontReplaceIfExists() throws Exception {
        this.rootDirectories.add(this.createPath("default://master@uf-playground"));
        ConfigGroup configGroup = this.getConfigGroup();
        configGroup.setName("test");
        ConfigItem configItem = new ConfigItem();
        configItem.setName("replaceIfExists");
        configItem.setValue((Object)false);
        configGroup.setConfigItem(configItem);
        Mockito.when((Object)this.notIndexed.newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap())).thenThrow(new Class[]{FileSystemAlreadyExistsException.class});
        Mockito.when((Object)this.notIndexed.getFileSystem((URI)Matchers.any(URI.class))).thenReturn((Object)this.fileSystem);
        this.helper.newRepository(configGroup);
        ((IOService)Mockito.verify((Object)this.notIndexed, (VerificationMode)Mockito.never())).delete((Path)Matchers.any(Path.class), new DeleteOption[0]);
        ((IOService)Mockito.verify((Object)this.notIndexed, (VerificationMode)Mockito.times((int)1))).newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap());
    }

    @Test
    public void testNewRepositoryReplaceIfExists() throws Exception {
        this.rootDirectories.add(this.createPath("default://master@uf-playground"));
        ConfigGroup configGroup = this.getConfigGroup();
        configGroup.setName("test");
        ConfigItem configItem = new ConfigItem();
        configItem.setName("replaceIfExists");
        configItem.setValue((Object)true);
        configGroup.setConfigItem(configItem);
        Mockito.when((Object)this.notIndexed.newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap())).thenThrow(new Class[]{FileSystemAlreadyExistsException.class}).thenReturn((Object)this.fileSystem);
        Mockito.when((Object)this.notIndexed.getFileSystem((URI)Matchers.any(URI.class))).thenReturn((Object)this.fileSystem);
        this.helper.newRepository(configGroup);
        ((IOService)Mockito.verify((Object)this.notIndexed, (VerificationMode)Mockito.times((int)1))).delete((Path)Matchers.any(Path.class), new DeleteOption[0]);
        ((IOService)Mockito.verify((Object)this.notIndexed, (VerificationMode)Mockito.times((int)2))).newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap());
    }

    @Test
    public void testBranches() throws Exception {
        this.rootDirectories.add(this.createPath("default://origin@uf-playground"));
        this.rootDirectories.add(this.createPath("default://master@uf-playground"));
        this.rootDirectories.add(this.createPath("default://branch1@uf-playground"));
        ConfigGroup configGroup = this.getConfigGroup();
        configGroup.setName("test");
        Repository repository = this.helper.newRepository(configGroup);
        Assert.assertEquals((long)3L, (long)repository.getBranches().size());
        Assert.assertTrue((boolean)((Branch)repository.getDefaultBranch().get()).getPath().toURI().contains("master"));
    }

    private Path createPath(String uri) {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.toUri()).thenReturn((Object)URI.create(uri));
        Mockito.when((Object)path.getFileSystem()).thenReturn((Object)this.fileSystem);
        return path;
    }

    private ConfigGroup getConfigGroup() {
        ConfigGroup repoConfig = new ConfigGroup();
        ConfigItem configItem = new ConfigItem();
        configItem.setName("scheme");
        repoConfig.addConfigItem(configItem);
        configItem = new ConfigItem();
        configItem.setName("space");
        configItem.setValue((Object)"space");
        repoConfig.addConfigItem(configItem);
        configItem = new ConfigItem();
        configItem.setName("avoid_index");
        configItem.setValue((Object)"true");
        repoConfig.addConfigItem(configItem);
        return repoConfig;
    }
}

