/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.guvnor.structure.backend.repositories.BranchAccessAuthorizer;
import org.guvnor.structure.backend.repositories.ChangeRequestServiceImpl;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequest;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestAlreadyOpenException;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestComment;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestCountSummary;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestListUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatus;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatusUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.portable.NothingToMergeException;
import org.guvnor.structure.repositories.changerequest.portable.PaginatedChangeRequestCommentList;
import org.guvnor.structure.repositories.changerequest.portable.PaginatedChangeRequestList;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.java.nio.base.TextualDiff;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.model.CommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.CommitInfo;
import org.uberfire.java.nio.fs.jgit.util.model.PathInfo;
import org.uberfire.java.nio.fs.jgit.util.model.RevertCommitContent;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class ChangeRequestServiceTest {
    private ChangeRequestServiceImpl service;
    @Mock
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private SpacesAPI spaces;
    @Mock
    private Event<ChangeRequestListUpdatedEvent> changeRequestListUpdatedEvent;
    @Mock
    private Event<ChangeRequestUpdatedEvent> changeRequestUpdatedEvent;
    @Mock
    private Event<ChangeRequestStatusUpdatedEvent> changeRequestStatusUpdatedEventEvent;
    @Mock
    private BranchAccessAuthorizer branchAccessAuthorizer;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private SpaceConfigStorage spaceConfigStorage;
    @Mock
    private Repository repository;
    @Mock
    private Branch sourceBranch;
    @Mock
    private Branch targetBranch;
    @Mock
    private Branch hiddenBranch;
    @Mock
    private Git git;
    @Mock
    private JGitFileSystem fs;
    @Mock
    private RevCommit commonCommit;
    @Mock
    private RevCommit lastCommit;

    @Before
    public void setUp() {
        Space mySpace = (Space)Mockito.mock(Space.class);
        User user = (User)Mockito.mock(User.class);
        ((SessionInfo)Mockito.doReturn((Object)user).when((Object)this.sessionInfo)).getIdentity();
        ((User)Mockito.doReturn((Object)"authorId").when((Object)user)).getIdentifier();
        ((SpaceConfigStorageRegistry)Mockito.doReturn((Object)this.spaceConfigStorage).when((Object)this.spaceConfigStorageRegistry)).get("mySpace");
        ((SpacesAPI)Mockito.doReturn((Object)mySpace).when((Object)this.spaces)).getSpace("mySpace");
        ((RepositoryService)Mockito.doReturn((Object)this.repository).when((Object)this.repositoryService)).getRepositoryFromSpace(mySpace, "myRepository");
        ((Branch)Mockito.doReturn((Object)"sourceBranch").when((Object)this.sourceBranch)).getName();
        ((Branch)Mockito.doReturn((Object)"targetBranch").when((Object)this.targetBranch)).getName();
        ((Branch)Mockito.doReturn((Object)"hiddenBranch").when((Object)this.hiddenBranch)).getName();
        Branch branch = (Branch)Mockito.mock(Branch.class);
        ((Branch)Mockito.doReturn((Object)"branch").when((Object)branch)).getName();
        List branches = Stream.of(this.sourceBranch, this.targetBranch, this.hiddenBranch, branch).collect(Collectors.toList());
        ((Repository)Mockito.doReturn(branches).when((Object)this.repository)).getBranches();
        ((Repository)Mockito.doReturn((Object)"myRepository").when((Object)this.repository)).getAlias();
        ((Repository)Mockito.doReturn((Object)mySpace).when((Object)this.repository)).getSpace();
        ((Space)Mockito.doReturn((Object)"mySpace").when((Object)mySpace)).getName();
        ((Repository)Mockito.doReturn(Optional.of(this.sourceBranch)).when((Object)this.repository)).getBranch("sourceBranch");
        ((Repository)Mockito.doReturn(Optional.of(this.targetBranch)).when((Object)this.repository)).getBranch("targetBranch");
        ((Repository)Mockito.doReturn(Optional.of(this.hiddenBranch)).when((Object)this.repository)).getBranch("hiddenBranch");
        ((Git)Mockito.doReturn((Object)this.commonCommit).when((Object)this.git)).getCommonAncestorCommit("sourceBranch", "targetBranch");
        ((Git)Mockito.doReturn((Object)this.lastCommit).when((Object)this.git)).getLastCommit(Matchers.anyString());
        ((BranchAccessAuthorizer)Mockito.doReturn((Object)true).when((Object)this.branchAccessAuthorizer)).authorize(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (BranchAccessAuthorizer.AccessType)Matchers.any());
        this.service = (ChangeRequestServiceImpl)Mockito.spy((Object)new ChangeRequestServiceImpl(this.spaceConfigStorageRegistry, this.repositoryService, this.spaces, this.changeRequestListUpdatedEvent, this.changeRequestUpdatedEvent, this.changeRequestStatusUpdatedEventEvent, this.branchAccessAuthorizer, this.sessionInfo));
        ((ChangeRequestServiceImpl)Mockito.doReturn((Object)this.fs).when((Object)this.service)).getFileSystemFromBranch(this.repository, "sourceBranch");
        ((ChangeRequestServiceImpl)Mockito.doReturn((Object)this.fs).when((Object)this.service)).getFileSystemFromBranch(this.repository, "targetBranch");
        ((JGitFileSystem)Mockito.doReturn((Object)this.git).when((Object)this.fs)).getGit();
        ((Git)Mockito.doReturn((Object)Mockito.mock(PathInfo.class)).when((Object)this.git)).getPathInfo(Matchers.anyString(), Matchers.anyString());
        ((ChangeRequestServiceImpl)Mockito.doReturn((Object)Mockito.mock(JGitPathImpl.class)).when((Object)this.service)).createJGitPathImpl((JGitFileSystem)Matchers.eq((Object)this.fs), Matchers.anyString(), Matchers.anyString(), (ObjectId)Matchers.any(ObjectId.class), Matchers.anyBoolean());
        ((ChangeRequestServiceImpl)Mockito.doReturn((Object)"commit message").when((Object)this.service)).getFullCommitMessage((RevCommit)Matchers.any(RevCommit.class));
    }

    @Test
    public void createFirstChangeRequestTest() {
        ((SpaceConfigStorage)Mockito.doReturn(Collections.emptyList()).when((Object)this.spaceConfigStorage)).getChangeRequestIds("myRepository");
        ChangeRequest newChangeRequest = this.service.createChangeRequest("mySpace", "myRepository", "sourceBranch", "targetBranch", "summary", "description");
        Assertions.assertThat((long)newChangeRequest.getId()).isEqualTo(1L);
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorageRegistry.get("mySpace"))).saveChangeRequest("myRepository", newChangeRequest);
        ((Event)Mockito.verify(this.changeRequestListUpdatedEvent)).fire(Matchers.any(ChangeRequestListUpdatedEvent.class));
    }

    @Test
    public void createChangeRequestTest() {
        List<Long> ids = Arrays.asList(1L, 10L, 2L, 3L, 4L);
        ((SpaceConfigStorage)Mockito.doReturn(ids).when((Object)this.spaceConfigStorage)).getChangeRequestIds("myRepository");
        ChangeRequest newChangeRequest = this.service.createChangeRequest("mySpace", "myRepository", "sourceBranch", "targetBranch", "summary", "description");
        Assertions.assertThat((long)newChangeRequest.getId()).isEqualTo(11L);
        Assertions.assertThat((Comparable)newChangeRequest.getStatus()).isEqualTo((Object)ChangeRequestStatus.OPEN);
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorageRegistry.get("mySpace"))).saveChangeRequest("myRepository", newChangeRequest);
        ((Event)Mockito.verify(this.changeRequestListUpdatedEvent)).fire(Matchers.any(ChangeRequestListUpdatedEvent.class));
    }

    @Test(expected=ChangeRequestAlreadyOpenException.class)
    public void createChangeRequestFailWhenAlreadyOpenTest() {
        List<ChangeRequest> crList = Collections.singletonList(this.createCommonChangeRequest());
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.createChangeRequest("mySpace", "myRepository", "sourceBranch", "targetBranch", "summary", "description");
    }

    @Test(expected=NoSuchElementException.class)
    public void createChangeRequestInvalidRepositoryTest() {
        this.service.createChangeRequest("mySpace", "myOtherRepository", "sourceBranch", "targetBranch", "summary", "description");
    }

    @Test
    public void getChangeRequestsTest() {
        List<ChangeRequest> crList = Collections.nCopies(5, this.createCommonChangeRequest());
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        List actualList = this.service.getChangeRequests("mySpace", "myRepository");
        Assertions.assertThat((List)actualList).isNotEmpty();
        Assertions.assertThat((List)actualList).hasSize(5);
    }

    @Test
    public void getChangeRequestUserCannotAccessBranchesTest() {
        ((BranchAccessAuthorizer)Mockito.doReturn((Object)false).when((Object)this.branchAccessAuthorizer)).authorize(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (BranchAccessAuthorizer.AccessType)Matchers.any());
        List<Object> crList = Collections.nCopies(5, Mockito.mock(ChangeRequest.class));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        List actualList = this.service.getChangeRequests("mySpace", "myRepository");
        Assertions.assertThat((List)actualList).isEmpty();
    }

    @Test
    public void getChangeRequestUserCanAccessSomeBranchesTest() {
        ((BranchAccessAuthorizer)Mockito.doReturn((Object)false).when((Object)this.branchAccessAuthorizer)).authorize(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"hiddenBranch"), (BranchAccessAuthorizer.AccessType)Matchers.any());
        ((BranchAccessAuthorizer)Mockito.doReturn((Object)true).when((Object)this.branchAccessAuthorizer)).authorize(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"branch"), (BranchAccessAuthorizer.AccessType)Matchers.any());
        ChangeRequest cr1 = this.createCommonChangeRequestWithTargetBranch("hiddenBranch");
        ChangeRequest cr2 = this.createCommonChangeRequestWithTargetBranch("hiddenBranch");
        ChangeRequest cr3 = this.createCommonChangeRequestWithTargetBranch("targetBranch");
        ChangeRequest cr4 = this.createCommonChangeRequestWithTargetBranch("targetBranch");
        List<ChangeRequest> crList = Arrays.asList(cr1, cr2, cr3, cr4);
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        List actualList = this.service.getChangeRequests("mySpace", "myRepository");
        Assertions.assertThat((List)actualList).isNotEmpty();
        Assertions.assertThat((List)actualList).hasSize(2);
    }

    @Test
    public void getChangeRequestsWithFilterTest() {
        ChangeRequest cr1 = this.createCommonChangeRequestWithSummary("findme");
        ChangeRequest cr2 = this.createCommonChangeRequestWithSummary("findme");
        ChangeRequest cr3 = this.createCommonChangeRequestWithSummary("hidden");
        ChangeRequest cr4 = this.createCommonChangeRequestWithSummary("hidden");
        List<ChangeRequest> crList = Arrays.asList(cr1, cr2, cr3, cr4);
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        List actualList = this.service.getChangeRequests("mySpace", "myRepository", "find");
        Assertions.assertThat((List)actualList).isNotEmpty();
        Assertions.assertThat((List)actualList).hasSize(2);
    }

    @Test
    public void getChangeRequestsWithStatusTest() {
        ChangeRequest cr1 = this.createCommonChangeRequestWithStatus(ChangeRequestStatus.OPEN);
        ChangeRequest cr2 = this.createCommonChangeRequestWithStatus(ChangeRequestStatus.REJECTED);
        ChangeRequest cr3 = this.createCommonChangeRequestWithStatus(ChangeRequestStatus.ACCEPTED);
        ChangeRequest cr4 = this.createCommonChangeRequestWithStatus(ChangeRequestStatus.OPEN);
        List<ChangeRequest> crList = Arrays.asList(cr1, cr2, cr3, cr4);
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        ArrayList<ChangeRequestStatus> statusList = new ArrayList<ChangeRequestStatus>(){
            {
                this.add(ChangeRequestStatus.OPEN);
            }
        };
        List actualList = this.service.getChangeRequests("mySpace", "myRepository", (List)statusList);
        Assertions.assertThat((List)actualList).isNotEmpty();
        Assertions.assertThat((List)actualList).hasSize(2);
    }

    @Test
    public void getChangeRequestsWithStatusAndFilterTest() {
        ChangeRequest cr1 = this.createCommonChangeRequestWithStatusSummary(ChangeRequestStatus.OPEN, "findme");
        ChangeRequest cr2 = this.createCommonChangeRequestWithStatusSummary(ChangeRequestStatus.REJECTED, "findme");
        ChangeRequest cr3 = this.createCommonChangeRequestWithStatusSummary(ChangeRequestStatus.ACCEPTED, "findme");
        ChangeRequest cr4 = this.createCommonChangeRequestWithStatusSummary(ChangeRequestStatus.OPEN, "findme");
        List<ChangeRequest> crList = Arrays.asList(cr1, cr2, cr3, cr4);
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        ArrayList<ChangeRequestStatus> statusList = new ArrayList<ChangeRequestStatus>(){
            {
                this.add(ChangeRequestStatus.OPEN);
            }
        };
        List actualList = this.service.getChangeRequests("mySpace", "myRepository", (List)statusList, "find");
        Assertions.assertThat((List)actualList).isNotEmpty();
        Assertions.assertThat((List)actualList).hasSize(2);
    }

    @Test
    public void getChangeRequestsPaginatedWithFilterTest() {
        final ChangeRequest crsWithFilter = this.createCommonChangeRequestWithStatusSummary(ChangeRequestStatus.OPEN, "findme");
        final ChangeRequest crsHidden = this.createCommonChangeRequestWithStatusSummary(ChangeRequestStatus.OPEN, "hidden");
        ArrayList<ChangeRequest> crList = new ArrayList<ChangeRequest>(){
            {
                this.addAll(Collections.nCopies(26, crsWithFilter));
                this.addAll(Collections.nCopies(30, crsHidden));
            }
        };
        ((SpaceConfigStorage)Mockito.doReturn((Object)crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        PaginatedChangeRequestList actualList = this.service.getChangeRequests("mySpace", "myRepository", Integer.valueOf(0), Integer.valueOf(10), "find");
        Assertions.assertThat((List)actualList.getChangeRequests()).isNotEmpty();
        Assert.assertEquals((long)10L, (long)actualList.getChangeRequests().size());
        actualList = this.service.getChangeRequests("mySpace", "myRepository", Integer.valueOf(1), Integer.valueOf(10), "find");
        Assertions.assertThat((List)actualList.getChangeRequests()).isNotEmpty();
        Assert.assertEquals((long)10L, (long)actualList.getChangeRequests().size());
        actualList = this.service.getChangeRequests("mySpace", "myRepository", Integer.valueOf(2), Integer.valueOf(10), "find");
        Assertions.assertThat((List)actualList.getChangeRequests()).isNotEmpty();
        Assert.assertEquals((long)6L, (long)actualList.getChangeRequests().size());
    }

    @Test
    public void getChangeRequestsPaginatedWithStatusAndFilterTest() {
        final ChangeRequest crsWithStatusAndFilter = this.createCommonChangeRequestWithStatusSummary(ChangeRequestStatus.ACCEPTED, "findme");
        final ChangeRequest crsOnlyFilter = this.createCommonChangeRequestWithSummary("findme");
        final ChangeRequest crsOnlyStatus = this.createCommonChangeRequestWithStatus(ChangeRequestStatus.ACCEPTED);
        final ChangeRequest crsHidden = this.createCommonChangeRequestWithSummary("hidden");
        ArrayList<ChangeRequest> crList = new ArrayList<ChangeRequest>(){
            {
                this.addAll(Collections.nCopies(20, crsOnlyStatus));
                this.addAll(Collections.nCopies(26, crsWithStatusAndFilter));
                this.addAll(Collections.nCopies(20, crsOnlyFilter));
                this.addAll(Collections.nCopies(30, crsHidden));
            }
        };
        ArrayList<ChangeRequestStatus> statusList = new ArrayList<ChangeRequestStatus>(){
            {
                this.add(ChangeRequestStatus.ACCEPTED);
            }
        };
        ((SpaceConfigStorage)Mockito.doReturn((Object)crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        PaginatedChangeRequestList actualList = this.service.getChangeRequests("mySpace", "myRepository", Integer.valueOf(0), Integer.valueOf(10), (List)statusList, "find");
        Assertions.assertThat((List)actualList.getChangeRequests()).isNotEmpty();
        Assert.assertEquals((long)10L, (long)actualList.getChangeRequests().size());
        actualList = this.service.getChangeRequests("mySpace", "myRepository", Integer.valueOf(1), Integer.valueOf(10), (List)statusList, "find");
        Assertions.assertThat((List)actualList.getChangeRequests()).isNotEmpty();
        Assert.assertEquals((long)10L, (long)actualList.getChangeRequests().size());
        actualList = this.service.getChangeRequests("mySpace", "myRepository", Integer.valueOf(2), Integer.valueOf(10), (List)statusList, "find");
        Assertions.assertThat((List)actualList.getChangeRequests()).isNotEmpty();
        Assert.assertEquals((long)6L, (long)actualList.getChangeRequests().size());
    }

    @Test
    public void getChangeRequestTest() {
        ChangeRequest cr1 = this.createCommonChangeRequestWithId(1L);
        ChangeRequest cr2 = this.createCommonChangeRequestWithId(2L);
        ChangeRequest cr3 = this.createCommonChangeRequestWithId(3L);
        ChangeRequest cr4 = this.createCommonChangeRequestWithId(4L);
        List<ChangeRequest> crList = Arrays.asList(cr1, cr2, cr3, cr4);
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        ChangeRequest actual = this.service.getChangeRequest("mySpace", "myRepository", Long.valueOf(3L));
        Assertions.assertThat((long)actual.getId()).isEqualTo(3L);
    }

    @Test(expected=NoSuchElementException.class)
    public void getChangeRequestNotFoundTest() {
        this.service.getChangeRequest("mySpace", "myRepository", Long.valueOf(10L));
    }

    @Test
    public void countChangeRequestsTest() {
        ArrayList<ChangeRequest> crList = new ArrayList<ChangeRequest>();
        crList.addAll(Collections.nCopies(15, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.OPEN)));
        crList.addAll(Collections.nCopies(5, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.ACCEPTED)));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        ChangeRequestCountSummary countSummary = this.service.countChangeRequests("mySpace", "myRepository");
        Assert.assertEquals((long)15L, (long)countSummary.getOpen().intValue());
        Assert.assertEquals((long)20L, (long)countSummary.getTotal().intValue());
    }

    @Test
    public void getDiffTestNoResultsTest() {
        ((Git)Mockito.doReturn(Collections.emptyList()).when((Object)this.git)).conflictBranchesChecker(Matchers.anyString(), Matchers.anyString());
        ((Git)Mockito.doReturn(Collections.emptyList()).when((Object)this.git)).textualDiffRefs(Matchers.anyString(), Matchers.anyString());
        List diffs = this.service.getDiff("mySpace", "myRepository", "sourceBranch", "targetBranch");
        Assertions.assertThat((List)diffs).isEmpty();
    }

    @Test
    public void getDiffTestNoResultsForChangeRequestTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequest());
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        ((Git)Mockito.doReturn(Collections.emptyList()).when((Object)this.git)).conflictBranchesChecker(Matchers.anyString(), Matchers.anyString());
        ((Git)Mockito.doReturn(Collections.emptyList()).when((Object)this.git)).textualDiffRefs(Matchers.anyString(), Matchers.anyString());
        List diffs = this.service.getDiff("mySpace", "myRepository", Long.valueOf(1L));
        Assertions.assertThat((List)diffs).isEmpty();
    }

    @Test
    public void getDiffTestWithResultsTest() {
        ((Branch)Mockito.doReturn((Object)Mockito.mock(org.uberfire.backend.vfs.Path.class)).when((Object)this.sourceBranch)).getPath();
        ((Branch)Mockito.doReturn((Object)Mockito.mock(org.uberfire.backend.vfs.Path.class)).when((Object)this.targetBranch)).getPath();
        TextualDiff textualDiff = new TextualDiff("old/file/path", "new/file/path", "ADD", 10, 10, "diff text");
        List<TextualDiff> diffList = Collections.nCopies(10, textualDiff);
        ((Git)Mockito.doReturn(Collections.emptyList()).when((Object)this.git)).conflictBranchesChecker(Matchers.anyString(), Matchers.anyString());
        ((Git)Mockito.doReturn(diffList).when((Object)this.git)).textualDiffRefs(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        List diffs = this.service.getDiff("mySpace", "myRepository", "sourceBranch", "targetBranch");
        Assertions.assertThat((List)diffs).isNotEmpty();
        Assertions.assertThat((List)diffs).hasSize(10);
    }

    @Test
    public void getDiffTestWithResultsForChangeRequestTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequest());
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        ((Branch)Mockito.doReturn((Object)Mockito.mock(org.uberfire.backend.vfs.Path.class)).when((Object)this.sourceBranch)).getPath();
        ((Branch)Mockito.doReturn((Object)Mockito.mock(org.uberfire.backend.vfs.Path.class)).when((Object)this.targetBranch)).getPath();
        TextualDiff textualDiff = new TextualDiff("old/file/path", "new/file/path", "ADD", 10, 10, "diff text");
        List<TextualDiff> diffList = Collections.nCopies(10, textualDiff);
        ((Git)Mockito.doReturn(Collections.emptyList()).when((Object)this.git)).conflictBranchesChecker(Matchers.anyString(), Matchers.anyString());
        ((Git)Mockito.doReturn(diffList).when((Object)this.git)).textualDiffRefs(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        List diffs = this.service.getDiff("mySpace", "myRepository", Long.valueOf(1L));
        Assertions.assertThat((List)diffs).isNotEmpty();
        Assertions.assertThat((List)diffs).hasSize(10);
    }

    @Test(expected=IllegalStateException.class)
    public void getDiffTestInvalidBranchTest() {
        ((Repository)Mockito.doReturn(Optional.ofNullable(null)).when((Object)this.repository)).getBranch("branchA");
        this.service.getDiff("mySpace", "myRepository", "branchA", "branchB");
    }

    @Test(expected=NoSuchElementException.class)
    public void getDiffTestInvalidChangeRequestTest() {
        this.service.getDiff("mySpace", "myRepository", Long.valueOf(10L));
    }

    @Test
    public void deleteChangeRequestsTest() {
        ChangeRequest crs = this.createCommonChangeRequestWithTargetBranch("hiddenBranch");
        List<ChangeRequest> crList = Collections.nCopies(10, crs);
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.deleteChangeRequests("mySpace", "myRepository", "sourceBranch");
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)10))).deleteChangeRequest(Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((Event)Mockito.verify(this.changeRequestListUpdatedEvent)).fire(Matchers.any(ChangeRequestListUpdatedEvent.class));
    }

    @Test
    public void deleteChangeRequestsSomeTest() {
        final ChangeRequest crsSourceBranch = this.createCommonChangeRequestWithSourceTargetBranch("branch", "hiddenBranch");
        final ChangeRequest crsTargetBranch = this.createCommonChangeRequestWithSourceTargetBranch("hiddenBranch", "branch");
        final ChangeRequest crsHidden = this.createCommonChangeRequestWithSourceTargetBranch("hiddenBranch", "hiddenBranch");
        ((Repository)Mockito.doReturn(Optional.of(Mockito.mock(Branch.class))).when((Object)this.repository)).getBranch("branch");
        ArrayList<ChangeRequest> crList = new ArrayList<ChangeRequest>(){
            {
                this.addAll(Collections.nCopies(10, crsSourceBranch));
                this.addAll(Collections.nCopies(20, crsTargetBranch));
                this.addAll(Collections.nCopies(15, crsHidden));
            }
        };
        ((SpaceConfigStorage)Mockito.doReturn((Object)crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.deleteChangeRequests("mySpace", "myRepository", "branch");
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)30))).deleteChangeRequest(Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((Event)Mockito.verify(this.changeRequestListUpdatedEvent)).fire(Matchers.any(ChangeRequestListUpdatedEvent.class));
    }

    @Test
    public void deleteChangeRequestsNoneTest() {
        ChangeRequest crs = this.createCommonChangeRequestWithSourceTargetBranch("hiddenBranch", "hiddenBranch");
        List<ChangeRequest> crList = Collections.nCopies(10, crs);
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.deleteChangeRequests("mySpace", "myRepository", "branch");
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.never())).deleteChangeRequest(Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((Event)Mockito.verify(this.changeRequestListUpdatedEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(ChangeRequestListUpdatedEvent.class));
    }

    @Test
    public void rejectChangeRequestSuccessTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.OPEN));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.rejectChangeRequest("mySpace", "myRepository", Long.valueOf(1L));
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).saveChangeRequest((String)Matchers.eq((Object)"myRepository"), (ChangeRequest)Matchers.any(ChangeRequest.class));
        ((Event)Mockito.verify(this.changeRequestStatusUpdatedEventEvent)).fire(Matchers.any(ChangeRequestStatusUpdatedEvent.class));
    }

    @Test(expected=IllegalStateException.class)
    public void rejectChangeRequestFailWhenChangeRequestNotOpenTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.ACCEPTED));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.rejectChangeRequest("mySpace", "myRepository", Long.valueOf(1L));
    }

    @Test
    public void closeChangeRequestSuccessTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.OPEN));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.closeChangeRequest("mySpace", "myRepository", Long.valueOf(1L));
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).saveChangeRequest((String)Matchers.eq((Object)"myRepository"), (ChangeRequest)Matchers.any(ChangeRequest.class));
        ((Event)Mockito.verify(this.changeRequestStatusUpdatedEventEvent)).fire(Matchers.any(ChangeRequestStatusUpdatedEvent.class));
    }

    @Test(expected=IllegalStateException.class)
    public void closeChangeRequestFailWhenChangeRequestNotOpenTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.ACCEPTED));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.closeChangeRequest("mySpace", "myRepository", Long.valueOf(1L));
    }

    @Test
    public void reopenChangeRequestSuccessTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.CLOSED));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.reopenChangeRequest("mySpace", "myRepository", Long.valueOf(1L));
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).saveChangeRequest((String)Matchers.eq((Object)"myRepository"), (ChangeRequest)Matchers.any(ChangeRequest.class));
        ((Event)Mockito.verify(this.changeRequestStatusUpdatedEventEvent)).fire(Matchers.any(ChangeRequestStatusUpdatedEvent.class));
    }

    @Test(expected=IllegalStateException.class)
    public void reopenChangeRequestFailWhenChangeRequestNotClosedTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.ACCEPTED));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.reopenChangeRequest("mySpace", "myRepository", Long.valueOf(1L));
    }

    @Test(expected=ChangeRequestAlreadyOpenException.class)
    public void reopenChangeRequestFailWhenOtherIsOpenSameBranchesTest() {
        ChangeRequest crToReopen = this.createCommonChangeRequestWithIdStatus(1L, ChangeRequestStatus.REJECTED);
        ChangeRequest otherOpen = this.createCommonChangeRequestWithIdStatus(2L, ChangeRequestStatus.OPEN);
        List crList = Stream.of(crToReopen, otherOpen).collect(Collectors.toList());
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.reopenChangeRequest("mySpace", "myRepository", Long.valueOf(1L));
    }

    @Test
    public void acceptChangeRequestSuccessTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.OPEN));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        DiffEntry diffEntry = (DiffEntry)Mockito.mock(DiffEntry.class);
        ((DiffEntry)Mockito.doReturn((Object)"old/file/path").when((Object)diffEntry)).getOldPath();
        ((DiffEntry)Mockito.doReturn((Object)"new/file/path").when((Object)diffEntry)).getNewPath();
        ((DiffEntry)Mockito.doReturn((Object)DiffEntry.ChangeType.MODIFY).when((Object)diffEntry)).getChangeType();
        List<DiffEntry> diffList = Collections.nCopies(10, diffEntry);
        ((Git)Mockito.doReturn(Collections.emptyList()).when((Object)this.git)).conflictBranchesChecker(Matchers.anyString(), Matchers.anyString());
        ((Git)Mockito.doReturn(diffList).when((Object)this.git)).listDiffs(Matchers.anyString(), Matchers.anyString());
        List commitList = Stream.of("commit-id").collect(Collectors.toList());
        ((Git)Mockito.doReturn(commitList).when((Object)this.git)).merge(Matchers.anyString(), Matchers.anyString(), Matchers.eq((boolean)true));
        boolean result = this.service.acceptChangeRequest("mySpace", "myRepository", Long.valueOf(1L));
        ((Git)Mockito.verify((Object)this.git)).merge(Matchers.anyString(), Matchers.anyString(), Matchers.eq((boolean)true));
        ((JGitFileSystem)Mockito.verify((Object)this.fs)).publishEvents((Path)Matchers.any(Path.class), Matchers.anyList());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).saveChangeRequest((String)Matchers.eq((Object)"myRepository"), (ChangeRequest)Matchers.any(ChangeRequest.class));
        ((Event)Mockito.verify(this.changeRequestStatusUpdatedEventEvent)).fire(Matchers.any(ChangeRequestStatusUpdatedEvent.class));
        Assert.assertTrue((boolean)result);
    }

    @Test(expected=NothingToMergeException.class)
    public void acceptChangeRequestFailWhenThereIsNoChangesTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.OPEN));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        DiffEntry diffEntry = (DiffEntry)Mockito.mock(DiffEntry.class);
        ((DiffEntry)Mockito.doReturn((Object)"old/file/path").when((Object)diffEntry)).getOldPath();
        ((DiffEntry)Mockito.doReturn((Object)"new/file/path").when((Object)diffEntry)).getNewPath();
        ((DiffEntry)Mockito.doReturn((Object)DiffEntry.ChangeType.MODIFY).when((Object)diffEntry)).getChangeType();
        List<DiffEntry> diffList = Collections.nCopies(10, diffEntry);
        ((Git)Mockito.doReturn(Collections.emptyList()).when((Object)this.git)).conflictBranchesChecker(Matchers.anyString(), Matchers.anyString());
        ((Git)Mockito.doReturn(diffList).when((Object)this.git)).listDiffs(Matchers.anyString(), Matchers.anyString());
        ((Git)Mockito.doReturn(Collections.emptyList()).when((Object)this.git)).merge(Matchers.anyString(), Matchers.anyString(), Matchers.eq((boolean)true));
        this.service.acceptChangeRequest("mySpace", "myRepository", Long.valueOf(1L));
    }

    @Test(expected=IllegalStateException.class)
    public void acceptChangeRequestFailWhenChangeRequestNotOpenTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.ACCEPTED));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.acceptChangeRequest("mySpace", "myRepository", Long.valueOf(1L));
    }

    @Test(expected=IllegalStateException.class)
    public void revertChangeRequestFailWhenChangeRequestNotAcceptedTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.REJECTED));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.revertChangeRequest("mySpace", "myRepository", Long.valueOf(1L));
    }

    @Test
    public void revertChangeRequestFailTest() {
        String lastCommitId = "abcde12";
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatusLastCommitId(ChangeRequestStatus.ACCEPTED, "abcde12"));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        ((Git)Mockito.doReturn((Object)false).when((Object)this.git)).revertMerge(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        boolean result = this.service.revertChangeRequest("mySpace", "myRepository", Long.valueOf(1L));
        ((JGitFileSystem)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.never())).publishEvents((Path)Matchers.any(Path.class), Matchers.anyList());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).saveChangeRequest((String)Matchers.eq((Object)"myRepository"), (ChangeRequest)Matchers.any(ChangeRequest.class));
        ((Event)Mockito.verify(this.changeRequestStatusUpdatedEventEvent)).fire(Matchers.any(ChangeRequestStatusUpdatedEvent.class));
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void revertChangeRequestSuccessTest() {
        String lastCommitId = "0000000000000000000000000000000000000000";
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatusLastCommitId(ChangeRequestStatus.ACCEPTED, "0000000000000000000000000000000000000000"));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        RevCommit commit = (RevCommit)Mockito.mock(RevCommit.class);
        ((Git)Mockito.doReturn((Object)commit).when((Object)this.git)).getLastCommit("targetBranch");
        ((Git)Mockito.doReturn((Object)true).when((Object)this.git)).commit((String)Matchers.eq((Object)"targetBranch"), (CommitInfo)Matchers.any(CommitInfo.class), Matchers.eq((boolean)false), (ObjectId)Matchers.any(RevCommit.class), (CommitContent)Matchers.any(RevertCommitContent.class));
        DiffEntry diffEntry = (DiffEntry)Mockito.mock(DiffEntry.class);
        ((DiffEntry)Mockito.doReturn((Object)"old/file/path").when((Object)diffEntry)).getOldPath();
        ((DiffEntry)Mockito.doReturn((Object)"new/file/path").when((Object)diffEntry)).getNewPath();
        ((DiffEntry)Mockito.doReturn((Object)DiffEntry.ChangeType.MODIFY).when((Object)diffEntry)).getChangeType();
        List<DiffEntry> diffList = Collections.nCopies(10, diffEntry);
        ((Git)Mockito.doReturn(Collections.emptyList()).when((Object)this.git)).conflictBranchesChecker(Matchers.anyString(), Matchers.anyString());
        ((Git)Mockito.doReturn(diffList).when((Object)this.git)).listDiffs(Matchers.anyString(), Matchers.anyString());
        ((Git)Mockito.doReturn((Object)true).when((Object)this.git)).revertMerge(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        boolean result = this.service.revertChangeRequest("mySpace", "myRepository", Long.valueOf(1L));
        ((JGitFileSystem)Mockito.verify((Object)this.fs)).publishEvents((Path)Matchers.any(Path.class), Matchers.anyList());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).saveChangeRequest((String)Matchers.eq((Object)"myRepository"), (ChangeRequest)Matchers.any(ChangeRequest.class));
        ((Event)Mockito.verify(this.changeRequestStatusUpdatedEventEvent)).fire(Matchers.any(ChangeRequestStatusUpdatedEvent.class));
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void updateChangeRequestSummaryTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.OPEN));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.updateChangeRequestSummary("mySpace", "myRepository", Long.valueOf(1L), "newSummary");
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).saveChangeRequest((String)Matchers.eq((Object)"myRepository"), (ChangeRequest)Matchers.any(ChangeRequest.class));
        ((Event)Mockito.verify(this.changeRequestUpdatedEvent)).fire(Matchers.any(ChangeRequestUpdatedEvent.class));
    }

    @Test
    public void updateChangeRequestDescriptionTest() {
        List<ChangeRequest> crList = Collections.nCopies(3, this.createCommonChangeRequestWithStatus(ChangeRequestStatus.OPEN));
        ((SpaceConfigStorage)Mockito.doReturn(crList).when((Object)this.spaceConfigStorage)).loadChangeRequests("myRepository");
        this.service.updateChangeRequestDescription("mySpace", "myRepository", Long.valueOf(1L), "newDescription");
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).saveChangeRequest((String)Matchers.eq((Object)"myRepository"), (ChangeRequest)Matchers.any(ChangeRequest.class));
        ((Event)Mockito.verify(this.changeRequestUpdatedEvent)).fire(Matchers.any(ChangeRequestUpdatedEvent.class));
    }

    @Test
    public void getCommentsAllTest() {
        ChangeRequestComment comment = new ChangeRequestComment(Long.valueOf(1L), "author", new Date(), "text");
        List<ChangeRequestComment> commentList = Collections.nCopies(3, comment);
        ((SpaceConfigStorage)Mockito.doReturn(commentList).when((Object)this.spaceConfigStorage)).loadChangeRequestComments("myRepository", Long.valueOf(1L));
        PaginatedChangeRequestCommentList paginatedList = this.service.getComments("mySpace", "myRepository", Long.valueOf(1L), Integer.valueOf(0), Integer.valueOf(0));
        Assert.assertEquals((long)3L, (long)paginatedList.getChangeRequestComments().size());
    }

    @Test
    public void getCommentsPaginatedTest() {
        ChangeRequestComment comment = new ChangeRequestComment(Long.valueOf(1L), "author", new Date(), "text");
        List<ChangeRequestComment> commentList = Collections.nCopies(25, comment);
        ((SpaceConfigStorage)Mockito.doReturn(commentList).when((Object)this.spaceConfigStorage)).loadChangeRequestComments("myRepository", Long.valueOf(1L));
        int page0Size = this.service.getComments("mySpace", "myRepository", Long.valueOf(1L), Integer.valueOf(0), Integer.valueOf(10)).getChangeRequestComments().size();
        int page1Size = this.service.getComments("mySpace", "myRepository", Long.valueOf(1L), Integer.valueOf(1), Integer.valueOf(10)).getChangeRequestComments().size();
        int page2Size = this.service.getComments("mySpace", "myRepository", Long.valueOf(1L), Integer.valueOf(2), Integer.valueOf(10)).getChangeRequestComments().size();
        int page3Size = this.service.getComments("mySpace", "myRepository", Long.valueOf(1L), Integer.valueOf(3), Integer.valueOf(10)).getChangeRequestComments().size();
        Assert.assertEquals((long)10L, (long)page0Size);
        Assert.assertEquals((long)10L, (long)page1Size);
        Assert.assertEquals((long)5L, (long)page2Size);
        Assert.assertEquals((long)0L, (long)page3Size);
    }

    @Test
    public void addCommentTest() {
        ((SpaceConfigStorage)Mockito.doReturn(Collections.emptyList()).when((Object)this.spaceConfigStorage)).getChangeRequestCommentIds("myRepository", Long.valueOf(1L));
        this.service.addComment("mySpace", "myRepository", Long.valueOf(1L), "myComment");
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorageRegistry.get("mySpace"))).saveChangeRequestComment((String)Matchers.eq((Object)"myRepository"), Long.valueOf(Matchers.eq((long)1L)), (ChangeRequestComment)Matchers.any(ChangeRequestComment.class));
        ((Event)Mockito.verify(this.changeRequestUpdatedEvent)).fire(Matchers.any(ChangeRequestUpdatedEvent.class));
    }

    @Test
    public void deleteCommentTest() {
        this.service.deleteComment("mySpace", "myRepository", Long.valueOf(1L), Long.valueOf(1L));
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorageRegistry.get("mySpace"))).deleteChangeRequestComment((String)Matchers.eq((Object)"myRepository"), Long.valueOf(Matchers.eq((long)1L)), Long.valueOf(Matchers.eq((long)1L)));
        ((Event)Mockito.verify(this.changeRequestUpdatedEvent)).fire(Matchers.any(ChangeRequestUpdatedEvent.class));
    }

    private ChangeRequest createCommonChangeRequestWithFields(Long id, String sourceBranch, String targetBranch, ChangeRequestStatus status, String summary, String lastCommitId) {
        return new ChangeRequest(id.longValue(), "mySpace", "myRepository", sourceBranch, targetBranch, status, "author", summary, "description", new Date(), "commonCommitId", lastCommitId, null);
    }

    private ChangeRequest createCommonChangeRequest() {
        return this.createCommonChangeRequestWithFields(1L, "sourceBranch", "targetBranch", ChangeRequestStatus.OPEN, "summary", null);
    }

    private ChangeRequest createCommonChangeRequestWithId(Long id) {
        return this.createCommonChangeRequestWithFields(id, "sourceBranch", "targetBranch", ChangeRequestStatus.OPEN, "summary", null);
    }

    private ChangeRequest createCommonChangeRequestWithStatus(ChangeRequestStatus status) {
        return this.createCommonChangeRequestWithFields(1L, "sourceBranch", "targetBranch", status, "summary", null);
    }

    private ChangeRequest createCommonChangeRequestWithSummary(String summary) {
        return this.createCommonChangeRequestWithFields(1L, "sourceBranch", "targetBranch", ChangeRequestStatus.OPEN, summary, null);
    }

    private ChangeRequest createCommonChangeRequestWithSourceBranch(String sourceBranch) {
        return this.createCommonChangeRequestWithFields(1L, sourceBranch, "targetBranch", ChangeRequestStatus.OPEN, "summary", null);
    }

    private ChangeRequest createCommonChangeRequestWithTargetBranch(String targetBranch) {
        return this.createCommonChangeRequestWithFields(1L, "sourceBranch", targetBranch, ChangeRequestStatus.OPEN, "summary", null);
    }

    private ChangeRequest createCommonChangeRequestWithStatusLastCommitId(ChangeRequestStatus status, String lastCommitId) {
        return this.createCommonChangeRequestWithFields(1L, "sourceBranch", "targetBranch", status, "summary", lastCommitId);
    }

    private ChangeRequest createCommonChangeRequestWithSourceTargetBranch(String sourceBranch, String targetBranch) {
        return this.createCommonChangeRequestWithFields(1L, sourceBranch, targetBranch, ChangeRequestStatus.OPEN, "summary", null);
    }

    private ChangeRequest createCommonChangeRequestWithStatusSummary(ChangeRequestStatus status, String summary) {
        return this.createCommonChangeRequestWithFields(1L, "sourceBranch", "targetBranch", status, summary, null);
    }

    private ChangeRequest createCommonChangeRequestWithIdStatus(Long id, ChangeRequestStatus status) {
        return this.createCommonChangeRequestWithFields(id, "sourceBranch", "targetBranch", status, "summary", null);
    }
}

