/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.SpaceContributorsUpdatedEvent;
import org.guvnor.structure.organizationalunit.NewOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoAddedToOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoRemovedFromOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.UpdatedOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.organizationalunit.OrganizationalUnitFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.ext.security.management.api.event.UserDeletedEvent;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@Service
@ApplicationScoped
public class OrganizationalUnitServiceImpl
implements OrganizationalUnitService {
    public static final String DEFAULT_GROUP_ID = "defaultGroupId";
    public static final String DELETED = "deleted";
    private OrganizationalUnitFactory organizationalUnitFactory;
    private Event<NewOrganizationalUnitEvent> newOrganizationalUnitEvent;
    private Event<RemoveOrganizationalUnitEvent> removeOrganizationalUnitEvent;
    private Event<RepoAddedToOrganizationalUnitEvent> repoAddedToOrgUnitEvent;
    private Event<RepoRemovedFromOrganizationalUnitEvent> repoRemovedFromOrgUnitEvent;
    private Event<UpdatedOrganizationalUnitEvent> updatedOrganizationalUnitEvent;
    private AuthorizationManager authorizationManager;
    private SessionInfo sessionInfo;
    private SpacesAPI spaces;
    private RepositoryService repositoryService;
    private IOService ioService;
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    private FileSystem systemFS;
    private Event<SpaceContributorsUpdatedEvent> spaceContributorsUpdatedEvent;
    private ConfigurationService configurationService;

    public OrganizationalUnitServiceImpl() {
    }

    @Inject
    public OrganizationalUnitServiceImpl(OrganizationalUnitFactory organizationalUnitFactory, RepositoryService repositoryService, Event<NewOrganizationalUnitEvent> newOrganizationalUnitEvent, Event<RemoveOrganizationalUnitEvent> removeOrganizationalUnitEvent, Event<RepoAddedToOrganizationalUnitEvent> repoAddedToOrgUnitEvent, Event<RepoRemovedFromOrganizationalUnitEvent> repoRemovedFromOrgUnitEvent, Event<UpdatedOrganizationalUnitEvent> updatedOrganizationalUnitEvent, AuthorizationManager authorizationManager, SpacesAPI spaces, SessionInfo sessionInfo, @Named(value="ioStrategy") IOService ioService, SpaceConfigStorageRegistry spaceConfigStorageRegistry, @Named(value="systemFS") FileSystem systemFS, Event<SpaceContributorsUpdatedEvent> spaceContributorsUpdatedEvent, ConfigurationService configurationService) {
        this.organizationalUnitFactory = organizationalUnitFactory;
        this.repositoryService = repositoryService;
        this.newOrganizationalUnitEvent = newOrganizationalUnitEvent;
        this.removeOrganizationalUnitEvent = removeOrganizationalUnitEvent;
        this.repoAddedToOrgUnitEvent = repoAddedToOrgUnitEvent;
        this.repoRemovedFromOrgUnitEvent = repoRemovedFromOrgUnitEvent;
        this.updatedOrganizationalUnitEvent = updatedOrganizationalUnitEvent;
        this.authorizationManager = authorizationManager;
        this.spaces = spaces;
        this.sessionInfo = sessionInfo;
        this.ioService = ioService;
        this.spaceConfigStorageRegistry = spaceConfigStorageRegistry;
        this.systemFS = systemFS;
        this.spaceContributorsUpdatedEvent = spaceContributorsUpdatedEvent;
        this.configurationService = configurationService;
    }

    public void userRemoved(@Observes UserDeletedEvent event) {
        String removedUserIdentifier = event.getIdentifier();
        for (OrganizationalUnit organizationalUnit : this.getAllOrganizationalUnits()) {
            boolean userRemoved = organizationalUnit.getContributors().removeIf(c -> c.getUsername().equals(removedUserIdentifier));
            if (userRemoved) {
                this.updateOrganizationalUnit(organizationalUnit.getName(), organizationalUnit.getDefaultGroupId(), organizationalUnit.getContributors());
            }
            for (Repository repository : organizationalUnit.getRepositories()) {
                ArrayList<Contributor> updatedRepositoryContributors = new ArrayList<Contributor>(repository.getContributors());
                boolean repositoryContributorRemoved = updatedRepositoryContributors.removeIf(c -> c.getUsername().equals(removedUserIdentifier));
                if (!repositoryContributorRemoved) continue;
                this.repositoryService.updateContributors(repository, updatedRepositoryContributors);
            }
        }
    }

    public OrganizationalUnit getOrganizationalUnit(String name) {
        return this.getOrganizationalUnit(name, false);
    }

    public OrganizationalUnit getOrganizationalUnit(String name, boolean includeDeleted) {
        if (this.spaceConfigStorageRegistry.exist(name) && !this.isDeleted(name)) {
            SpaceInfo spaceInfo = this.spaceConfigStorageRegistry.get(name).loadSpaceInfo();
            if (spaceInfo != null) {
                return this.organizationalUnitFactory.newOrganizationalUnit(spaceInfo);
            }
        } else if (includeDeleted) {
            return this.getAllDeletedOrganizationalUnit().stream().filter(organizationalUnit -> organizationalUnit.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
        }
        return null;
    }

    public Collection<OrganizationalUnit> getAllOrganizationalUnits() {
        return this.getAllOrganizationalUnits(false);
    }

    public Collection<OrganizationalUnit> getAllOrganizationalUnits(boolean includeDeleted) {
        return this.getAllOrganizationalUnits(includeDeleted, ou -> !ou.getName().startsWith("."));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<OrganizationalUnit> getAllOrganizationalUnits(boolean includeDeleted, Predicate<OrganizationalUnit> filter) {
        ArrayList<OrganizationalUnit> spaces = new ArrayList<OrganizationalUnit>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getNiogitPath());){
            for (Path spacePath : stream) {
                OrganizationalUnit ou;
                SpaceConfigStorage configStorage;
                File spaceDirectory = spacePath.toFile();
                if (!spaceDirectory.isDirectory() || spaceDirectory.getName().equals("system") || this.isDeleted(spaceDirectory.getName()) || !(configStorage = this.spaceConfigStorageRegistry.get(spaceDirectory.getName())).isInitialized() || (ou = this.getOrganizationalUnit(spaceDirectory.getName(), false)) == null) continue;
                spaces.add(ou);
            }
            if (includeDeleted) {
                spaces.addAll(this.getAllDeletedOrganizationalUnit());
            }
            Collection collection = spaces.stream().filter(filter).collect(Collectors.toList());
            return collection;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<OrganizationalUnit> getAllDeletedOrganizationalUnit() {
        List spaceConfiguration = this.configurationService.getConfiguration(ConfigType.SPACE);
        return spaceConfiguration.stream().filter(configGroup -> Optional.ofNullable(configGroup.getConfigItem(DELETED)).isPresent()).map(configGroup -> this.createDeletedOrganizationalUnit((ConfigGroup)configGroup)).collect(Collectors.toList());
    }

    protected boolean isDeleted(String spaceName) {
        List spaceConfigurations = this.configurationService.getConfiguration(ConfigType.SPACE);
        return spaceConfigurations.stream().filter(spaceConfiguration -> spaceConfiguration.getName().equalsIgnoreCase(spaceName) && spaceConfiguration.getConfigItem(DELETED) != null).findFirst().isPresent();
    }

    public void onRemoveOrganizationalUnit(@Observes RemoveOrganizationalUnitEvent event) {
        if (event.getOrganizationalUnit() != null && event.getOrganizationalUnit().getSpace() != null) {
            this.spaceConfigStorageRegistry.remove(event.getOrganizationalUnit().getSpace().getName());
        }
    }

    public Collection<Space> getAllUserSpaces() {
        return this.getAllOrganizationalUnits().stream().map(ou -> this.spaces.getSpace(ou.getName())).collect(Collectors.toList());
    }

    public Collection<OrganizationalUnit> getOrganizationalUnits() {
        return this.getOrganizationalUnits(false);
    }

    public Collection<OrganizationalUnit> getOrganizationalUnits(boolean includeDeleted) {
        ArrayList<OrganizationalUnit> result = new ArrayList<OrganizationalUnit>();
        for (OrganizationalUnit ou : this.getAllOrganizationalUnits(includeDeleted)) {
            if (!this.authorizationManager.authorize((Resource)ou, this.sessionInfo.getIdentity()) && !ou.getContributors().stream().anyMatch(c -> c.getUsername().equals(this.sessionInfo.getIdentity().getIdentifier()))) continue;
            result.add(ou);
        }
        return result;
    }

    public OrganizationalUnit createOrganizationalUnit(String name, String defaultGroupId) {
        return this.createOrganizationalUnit(name, defaultGroupId, new ArrayList<Repository>());
    }

    public OrganizationalUnit createOrganizationalUnit(String name, String defaultGroupId, Collection<Repository> repositories) {
        return this.createOrganizationalUnit(name, defaultGroupId, repositories, new ArrayList<Contributor>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationalUnit createOrganizationalUnit(String name, String defaultGroupId, Collection<Repository> repositories, Collection<Contributor> contributors) {
        OrganizationalUnit organizationalUnit;
        block4: {
            if (this.spaceDirectoryExists(name)) {
                return null;
            }
            OrganizationalUnit newOrganizationalUnit = null;
            try {
                String _defaultGroupId = defaultGroupId == null || defaultGroupId.trim().isEmpty() ? this.getSanitizedDefaultGroupId(name) : defaultGroupId;
                SpaceInfo spaceInfo = new SpaceInfo(name, _defaultGroupId, contributors, this.getRepositoryAliases(repositories), Collections.emptyList());
                this.spaceConfigStorageRegistry.get(name).saveSpaceInfo(spaceInfo);
                organizationalUnit = newOrganizationalUnit = this.organizationalUnitFactory.newOrganizationalUnit(spaceInfo);
                if (newOrganizationalUnit == null) break block4;
            }
            catch (Throwable throwable) {
                if (newOrganizationalUnit != null) {
                    this.newOrganizationalUnitEvent.fire((Object)new NewOrganizationalUnitEvent(newOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                }
                throw throwable;
            }
            this.newOrganizationalUnitEvent.fire((Object)new NewOrganizationalUnitEvent(newOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
        }
        return organizationalUnit;
    }

    private List<RepositoryInfo> getRepositoryAliases(Collection<Repository> repositories) {
        return repositories.stream().map(repository -> new RepositoryInfo(repository.getAlias(), false, new RepositoryConfiguration(repository.getEnvironment()))).collect(Collectors.toList());
    }

    public OrganizationalUnit updateOrganizationalUnit(String name, String defaultGroupId) {
        return this.updateOrganizationalUnit(name, defaultGroupId, null);
    }

    public OrganizationalUnit updateOrganizationalUnit(String name, String defaultGroupId, Collection<Contributor> contributors) {
        return (OrganizationalUnit)this.spaceConfigStorageRegistry.getBatch(name).run(context -> {
            OrganizationalUnit organizationalUnit;
            block6: {
                OrganizationalUnit updatedOrganizationalUnit = null;
                try {
                    SpaceInfo spaceInfo = context.getSpaceInfo();
                    String _defaultGroupId = defaultGroupId == null || defaultGroupId.trim().isEmpty() ? spaceInfo.getDefaultGroupId() : defaultGroupId;
                    spaceInfo.setDefaultGroupId(_defaultGroupId);
                    if (contributors != null) {
                        spaceInfo.setContributors(contributors);
                    }
                    context.saveSpaceInfo();
                    updatedOrganizationalUnit = this.getOrganizationalUnit(name);
                    this.checkChildrenRepositoryContributors(updatedOrganizationalUnit);
                    organizationalUnit = updatedOrganizationalUnit;
                    if (updatedOrganizationalUnit == null) break block6;
                }
                catch (Throwable throwable) {
                    if (updatedOrganizationalUnit != null) {
                        this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                        if (contributors != null) {
                            this.spaceContributorsUpdatedEvent.fire((Object)new SpaceContributorsUpdatedEvent(updatedOrganizationalUnit));
                        }
                    }
                    throw throwable;
                }
                this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                if (contributors != null) {
                    this.spaceContributorsUpdatedEvent.fire((Object)new SpaceContributorsUpdatedEvent(updatedOrganizationalUnit));
                }
            }
            return organizationalUnit;
        });
    }

    void checkChildrenRepositoryContributors(OrganizationalUnit updatedOrganizationalUnit) {
        this.repositoryService.getAllRepositories(updatedOrganizationalUnit.getSpace()).forEach(repository -> {
            List updatedRepositoryContributors = repository.getContributors().stream().filter(contributor -> updatedOrganizationalUnit.getContributors().stream().anyMatch(spaceContributor -> spaceContributor.getUsername().equals(contributor.getUsername()))).collect(Collectors.toList());
            if (updatedRepositoryContributors.size() != repository.getContributors().size()) {
                this.repositoryService.updateContributors(repository, updatedRepositoryContributors);
            }
        });
    }

    public void addRepository(OrganizationalUnit organizationalUnit, Repository repository) {
        this.spaceConfigStorageRegistry.getBatch(organizationalUnit.getName()).run(context -> {
            try {
                context.getSpaceInfo().getRepositories().add(new RepositoryInfo(repository.getAlias(), false, new RepositoryConfiguration(repository.getEnvironment())));
                context.saveSpaceInfo();
            }
            finally {
                this.repoAddedToOrgUnitEvent.fire((Object)new RepoAddedToOrganizationalUnitEvent(organizationalUnit, repository, this.getUserInfo(this.sessionInfo)));
            }
            return null;
        });
    }

    public void removeRepository(OrganizationalUnit organizationalUnit, Repository repository) {
        this.spaceConfigStorageRegistry.getBatch(organizationalUnit.getName()).run(context -> {
            try {
                context.getSpaceInfo().getRepositories().stream().filter(repositoryInfo -> repositoryInfo.getName().equals(repository.getAlias()) && !repositoryInfo.isDeleted()).findFirst().orElseThrow(() -> new RuntimeException("Repository not found")).setDeleted(true);
                context.saveSpaceInfo();
                Object var4_4 = null;
                return var4_4;
            }
            finally {
                this.repoRemovedFromOrgUnitEvent.fire((Object)new RepoRemovedFromOrganizationalUnitEvent(organizationalUnit, repository, this.getUserInfo(this.sessionInfo)));
            }
        });
    }

    public void addGroup(OrganizationalUnit organizationalUnit, String group) {
        this.spaceConfigStorageRegistry.getBatch(organizationalUnit.getName()).run(context -> {
            OrganizationalUnit updatedOrganizationalUnit = null;
            try {
                context.getSpaceInfo().getSecurityGroups().add(group);
                context.saveSpaceInfo();
                updatedOrganizationalUnit = this.getOrganizationalUnit(organizationalUnit.getName());
                Object var5_5 = null;
                return var5_5;
            }
            finally {
                if (updatedOrganizationalUnit != null) {
                    this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                }
            }
        });
    }

    public void removeGroup(OrganizationalUnit organizationalUnit, String group) {
        this.spaceConfigStorageRegistry.getBatch(organizationalUnit.getName()).run(context -> {
            OrganizationalUnit updatedOrganizationalUnit = null;
            try {
                context.getSpaceInfo().getSecurityGroups().remove(group);
                context.saveSpaceInfo();
                updatedOrganizationalUnit = this.getOrganizationalUnit(organizationalUnit.getName());
            }
            finally {
                if (updatedOrganizationalUnit != null) {
                    this.updatedOrganizationalUnitEvent.fire((Object)new UpdatedOrganizationalUnitEvent(updatedOrganizationalUnit, this.getUserInfo(this.sessionInfo)));
                }
            }
            return null;
        });
    }

    public void removeOrganizationalUnit(String groupName) {
        OrganizationalUnit organizationalUnit = this.getOrganizationalUnit(groupName);
        if (organizationalUnit != null) {
            this.repositoryService.removeRepositories(organizationalUnit.getSpace(), organizationalUnit.getRepositories().stream().map(repo -> repo.getAlias()).collect(Collectors.toSet()));
            this.removeSpaceDirectory(organizationalUnit);
            this.removeOrganizationalUnitEvent.fire((Object)new RemoveOrganizationalUnitEvent(organizationalUnit, this.getUserInfo(this.sessionInfo)));
        }
    }

    private void removeSpaceDirectory(OrganizationalUnit organizationalUnit) {
        this.configurationService.startBatch();
        ConfigGroup configGroup = new ConfigGroup();
        configGroup.setType(ConfigType.SPACE);
        configGroup.setName(organizationalUnit.getSpace().getName());
        ConfigItem deletedConfigItem = new ConfigItem();
        deletedConfigItem.setName(DELETED);
        deletedConfigItem.setValue((Object)true);
        configGroup.addConfigItem(deletedConfigItem);
        ConfigItem defaultGroupIdConfigItem = new ConfigItem();
        defaultGroupIdConfigItem.setName(DEFAULT_GROUP_ID);
        defaultGroupIdConfigItem.setValue((Object)organizationalUnit.getDefaultGroupId());
        configGroup.addConfigItem(defaultGroupIdConfigItem);
        this.configurationService.addConfiguration(configGroup);
        this.configurationService.endBatch();
    }

    public OrganizationalUnit getParentOrganizationalUnit(Repository repository) {
        for (OrganizationalUnit organizationalUnit : this.getAllOrganizationalUnits()) {
            if (organizationalUnit.getRepositories() == null) continue;
            for (Repository ouRepository : organizationalUnit.getRepositories()) {
                if (!ouRepository.getAlias().equals(repository.getAlias())) continue;
                return organizationalUnit;
            }
        }
        return null;
    }

    public List<OrganizationalUnit> getOrganizationalUnits(Repository repository) {
        ArrayList<OrganizationalUnit> result = new ArrayList<OrganizationalUnit>();
        for (OrganizationalUnit organizationalUnit : this.getAllOrganizationalUnits()) {
            if (organizationalUnit.getRepositories() == null) continue;
            for (Repository ouRepository : organizationalUnit.getRepositories()) {
                if (!ouRepository.getAlias().equals(repository.getAlias())) continue;
                result.add(organizationalUnit);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public String getSanitizedDefaultGroupId(String proposedGroupId) {
        return proposedGroupId != null ? proposedGroupId.replaceAll("[^A-Za-z0-9_\\-.]", "") : proposedGroupId;
    }

    public Boolean isValidGroupId(String proposedGroupId) {
        if (proposedGroupId != null && !proposedGroupId.trim().isEmpty() && proposedGroupId.length() == this.getSanitizedDefaultGroupId(proposedGroupId).length()) {
            return true;
        }
        return false;
    }

    protected String getUserInfo(SessionInfo sessionInfo) {
        try {
            return sessionInfo.getIdentity().getIdentifier();
        }
        catch (Exception e) {
            return "system";
        }
    }

    Path getNiogitPath() {
        JGitPathImpl systemGitPath = (JGitPathImpl)this.systemFS.getPath("system", new String[0]);
        return ((JGitFileSystem)systemGitPath.getFileSystem()).getGit().getRepository().getDirectory().getParentFile().getParentFile().toPath();
    }

    boolean spaceDirectoryExists(String spaceName) {
        SpaceConfigStorage configStorage = this.spaceConfigStorageRegistry.get(spaceName);
        return this.getNiogitPath().resolve(spaceName).toFile().exists() && configStorage.isInitialized();
    }

    private OrganizationalUnit createDeletedOrganizationalUnit(ConfigGroup configGroup) {
        String spaceName = configGroup.getName();
        String defaultGroupId = configGroup.getConfigItemValue(DEFAULT_GROUP_ID);
        return new OrganizationalUnitImpl(spaceName, defaultGroupId, true);
    }
}

