/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git.hooks.impl;

import java.util.Locale;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.guvnor.structure.backend.repositories.git.hooks.impl.MessageReader;
import org.guvnor.structure.backend.repositories.git.hooks.impl.PostCommitNotificationServiceImpl;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.repositories.impl.git.event.NotificationType;
import org.guvnor.structure.repositories.impl.git.event.PostCommitNotificationEvent;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class PostCommitNotificationServiceImplTest {
    private static final String BUNDLE_PATH = "src/test/resources/bundles/Messages.properties";
    private static final String REPO = "repository.git";
    private static final String VALID_SPACE = "mySpace";
    private static final String SYSTEM_SPACE = "system";
    private static final String EN_SUCCESS = "Success: nothing wrong happens";
    private static final String EN_WARNING = "Warning: check the logs";
    private static final String EN_WARNING_2 = "Warning: check the logs again";
    private static final String EN_ERROR = "Error: run in circles and scream";
    private static final String CA_SUCCESS = "Exit: no passa res";
    private static final String CA_WARNING = "Alerta: mira els logs del servidor";
    private static final String CA_WARNING_2 = "Alerta: mira els logs del servidor un altre cop";
    private static final String CA_ERROR = "Error: corre en cercles i crida";
    private Locale defaultLocale;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private Event<PostCommitNotificationEvent> notificationEvent;
    private Locale locale = Locale.ENGLISH;
    private MessageReader reader;
    private PostCommitNotificationServiceImpl service;

    @Before
    public void init() {
        this.defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        this.reader = new MessageReader(() -> this.locale);
    }

    private void init(String path) {
        System.setProperty("appformer.git.hooks.bundle", path);
        this.service = new PostCommitNotificationServiceImpl(this.sessionInfo, this.notificationEvent, this.reader);
        this.service.init();
    }

    @Test
    public void testLoadWrongBundle() {
        this.init("wrong bundle");
        this.service.notifyUser(new GitRepository(REPO, new Space(VALID_SPACE)), Integer.valueOf(0));
        ((Event)Mockito.verify(this.notificationEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
    }

    @Test
    public void testNoNotification() {
        this.init(BUNDLE_PATH);
        this.service.notifyUser(new GitRepository(REPO, new Space(SYSTEM_SPACE)), Integer.valueOf(0));
        ((Event)Mockito.verify(this.notificationEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
        this.service.notifyUser(new GitRepository(REPO, new Space(VALID_SPACE)), Integer.valueOf(3));
        ((Event)Mockito.verify(this.notificationEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
    }

    @Test
    public void testNotifyEn() {
        this.testNotify(Locale.ENGLISH, EN_SUCCESS, EN_WARNING, EN_WARNING_2, EN_ERROR);
    }

    @Test
    public void testNotifyCa() {
        this.testNotify(new Locale("ca"), CA_SUCCESS, CA_WARNING, CA_WARNING_2, CA_ERROR);
    }

    @Test
    public void testNotifyNonExistingLanguage() {
        this.testNotify(Locale.FRENCH, EN_SUCCESS, EN_WARNING, EN_WARNING_2, EN_ERROR);
    }

    private void testNotify(Locale locale, String successMsg, String warningMsg, String warning2Msg, String errorMsg) {
        this.init(BUNDLE_PATH);
        this.locale = locale;
        this.testNotify(0, successMsg, NotificationType.SUCCESS, 1);
        this.testNotify(1, warningMsg, NotificationType.WARNING, 2);
        this.testNotify(30, warning2Msg, NotificationType.WARNING, 3);
        this.testNotify(31, errorMsg, NotificationType.ERROR, 4);
    }

    private void testNotify(int code, String message, NotificationType notificationType, int times) {
        this.service.notifyUser(new GitRepository(REPO, new Space(VALID_SPACE)), Integer.valueOf(code));
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(PostCommitNotificationEvent.class);
        ((Event)Mockito.verify(this.notificationEvent, (VerificationMode)Mockito.times((int)times))).fire(eventCaptor.capture());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)eventCaptor.getValue()).isNotNull()).hasFieldOrPropertyWithValue("text", (Object)message)).hasFieldOrPropertyWithValue("type", (Object)notificationType);
    }

    @After
    public void finish() {
        Locale.setDefault(this.defaultLocale);
    }
}

