/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.backend.repositories.LoadReposOnAppInit;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class LoadReposOnAppInitTest {
    @Mock
    private ConfiguredRepositories configuredRepositories;
    @Mock
    private OrganizationalUnitService organizationalUnitService;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.organizationalUnitService.getAllOrganizationalUnits()).thenReturn((Object)new ArrayList<OrganizationalUnit>(){
            {
                this.add(new OrganizationalUnitImpl("test", "test"));
            }
        });
    }

    @Test
    public void testLoadRepositories() {
        LoadReposOnAppInit loadReposOnAppInit = (LoadReposOnAppInit)Mockito.spy((Object)new LoadReposOnAppInit(this.configuredRepositories, this.organizationalUnitService));
        ((LoadReposOnAppInit)Mockito.doReturn((Object)true).when((Object)loadReposOnAppInit)).isGitDefaultFileSystem();
        loadReposOnAppInit.execute();
        ((ConfiguredRepositories)Mockito.verify((Object)this.configuredRepositories, (VerificationMode)Mockito.times((int)1))).getAllConfiguredRepositories((Space)Mockito.any());
    }

    @Test
    public void testOnlyRunInBCServerType() {
        LoadReposOnAppInit loadReposOnInit = (LoadReposOnAppInit)Mockito.spy((Object)new LoadReposOnAppInit(this.configuredRepositories, this.organizationalUnitService));
        ((LoadReposOnAppInit)Mockito.doReturn((Object)false).when((Object)loadReposOnInit)).isGitDefaultFileSystem();
        loadReposOnInit.execute();
        ((OrganizationalUnitService)Mockito.verify((Object)this.organizationalUnitService, (VerificationMode)Mockito.never())).getAllOrganizationalUnits();
        loadReposOnInit = (LoadReposOnAppInit)Mockito.spy((Object)new LoadReposOnAppInit(this.configuredRepositories, this.organizationalUnitService));
        ((LoadReposOnAppInit)Mockito.doReturn((Object)true).when((Object)loadReposOnInit)).isGitDefaultFileSystem();
        loadReposOnInit.execute();
        ((OrganizationalUnitService)Mockito.verify((Object)this.organizationalUnitService, (VerificationMode)Mockito.times((int)1))).getAllOrganizationalUnits();
    }
}

