/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.guvnor.structure.backend.repositories.BranchAccessAuthorizer;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.guvnor.structure.organizationalunit.config.RolePermissions;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Repository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class BranchAccessAuthorizerTest {
    @Mock
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    @Mock
    private ConfiguredRepositories configuredRepositories;
    @Mock
    private OrganizationalUnitService organizationalUnitService;
    private BranchAccessAuthorizer branchAccessAuthorizer;

    @Before
    public void setup() {
        this.branchAccessAuthorizer = new BranchAccessAuthorizer(this.spaceConfigStorageRegistry, this.configuredRepositories, this.organizationalUnitService);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        List<Contributor> contributors = Arrays.asList(new Contributor("owner", ContributorType.OWNER), new Contributor("admin", ContributorType.ADMIN), new Contributor("contributor", ContributorType.CONTRIBUTOR));
        ((Repository)Mockito.doReturn(contributors).when((Object)repository)).getContributors();
        ((ConfiguredRepositories)Mockito.doReturn((Object)repository).when((Object)this.configuredRepositories)).getRepositoryByRepositoryAlias(new Space("space"), "repositoryAlias");
        OrganizationalUnit organizationalUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        ((OrganizationalUnit)Mockito.doReturn((Object)new Space("space")).when((Object)organizationalUnit)).getSpace();
        ((OrganizationalUnitService)Mockito.doReturn((Object)organizationalUnit).when((Object)this.organizationalUnitService)).getOrganizationalUnit("space");
        HashMap<String, RolePermissions> permissionsByRole = new HashMap<String, RolePermissions>();
        permissionsByRole.put("OWNER", new RolePermissions("OWNER", true, true, true, true));
        permissionsByRole.put("ADMIN", new RolePermissions("ADMIN", true, true, false, true));
        permissionsByRole.put("CONTRIBUTOR", new RolePermissions("CONTRIBUTOR", true, true, false, false));
        BranchPermissions branchPermissions = new BranchPermissions("branch", permissionsByRole);
        SpaceConfigStorage spaceConfigStorage = (SpaceConfigStorage)Mockito.mock(SpaceConfigStorage.class);
        ((SpaceConfigStorage)Mockito.doReturn((Object)branchPermissions).when((Object)spaceConfigStorage)).loadBranchPermissions("branch", "repositoryIdentifier");
        ((SpaceConfigStorageRegistry)Mockito.doReturn((Object)spaceConfigStorage).when((Object)this.spaceConfigStorageRegistry)).get("space");
    }

    @Test
    public void authorizeOwnerTest() {
        Assert.assertTrue((boolean)this.branchAccessAuthorizer.authorize("owner", "space", "repositoryIdentifier", "repositoryAlias", "branch", BranchAccessAuthorizer.AccessType.READ));
        Assert.assertTrue((boolean)this.branchAccessAuthorizer.authorize("owner", "space", "repositoryIdentifier", "repositoryAlias", "branch", BranchAccessAuthorizer.AccessType.WRITE));
        Assert.assertTrue((boolean)this.branchAccessAuthorizer.authorize("owner", "space", "repositoryIdentifier", "repositoryAlias", "branch", BranchAccessAuthorizer.AccessType.DELETE));
    }

    @Test
    public void authorizeAdminTest() {
        Assert.assertTrue((boolean)this.branchAccessAuthorizer.authorize("admin", "space", "repositoryIdentifier", "repositoryAlias", "branch", BranchAccessAuthorizer.AccessType.READ));
        Assert.assertTrue((boolean)this.branchAccessAuthorizer.authorize("admin", "space", "repositoryIdentifier", "repositoryAlias", "branch", BranchAccessAuthorizer.AccessType.WRITE));
        Assert.assertFalse((boolean)this.branchAccessAuthorizer.authorize("admin", "space", "repositoryIdentifier", "repositoryAlias", "branch", BranchAccessAuthorizer.AccessType.DELETE));
    }

    @Test
    public void authorizeContributorTest() {
        Assert.assertTrue((boolean)this.branchAccessAuthorizer.authorize("contributor", "space", "repositoryIdentifier", "repositoryAlias", "branch", BranchAccessAuthorizer.AccessType.READ));
        Assert.assertTrue((boolean)this.branchAccessAuthorizer.authorize("contributor", "space", "repositoryIdentifier", "repositoryAlias", "branch", BranchAccessAuthorizer.AccessType.WRITE));
        Assert.assertFalse((boolean)this.branchAccessAuthorizer.authorize("contributor", "space", "repositoryIdentifier", "repositoryAlias", "branch", BranchAccessAuthorizer.AccessType.DELETE));
    }
}

