/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.config;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.structure.backend.config.ConfigurationFactoryImpl;
import org.guvnor.structure.backend.config.DefaultPasswordServiceImpl;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.PasswordService;
import org.guvnor.structure.server.config.SecureConfigItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfigurationFactoryImplTest {
    private PasswordService passwordService;
    private ConfigurationFactory configurationFactory;

    @Before
    public void setup() {
        this.passwordService = new DefaultPasswordServiceImpl();
        this.configurationFactory = new ConfigurationFactoryImpl(this.passwordService);
    }

    @Test
    public void newConfigGroupWithoutNamespaceTest() {
        ConfigGroup configGroup = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "my-config", "my-description");
        Assert.assertEquals((Object)ConfigType.GLOBAL, (Object)configGroup.getType());
        Assert.assertEquals((Object)"my-config", (Object)configGroup.getName());
        Assert.assertEquals((Object)"my-description", (Object)configGroup.getDescription());
        Assert.assertTrue((boolean)configGroup.isEnabled());
    }

    @Test(expected=RuntimeException.class)
    public void newConfigGroupWithoutNamespaceButTypeRequiresNamespaceTest() {
        this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "my-config", "my-description");
    }

    @Test
    public void newConfigGroupWithNamespaceTest() {
        ConfigGroup configGroup = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "my-namespace", "my-config", "my-description");
        Assert.assertEquals((Object)ConfigType.REPOSITORY, (Object)configGroup.getType());
        Assert.assertEquals((Object)"my-namespace", (Object)configGroup.getNamespace());
        Assert.assertEquals((Object)"my-config", (Object)configGroup.getName());
        Assert.assertEquals((Object)"my-description", (Object)configGroup.getDescription());
        Assert.assertTrue((boolean)configGroup.isEnabled());
    }

    @Test(expected=RuntimeException.class)
    public void newConfigGroupWithNamespaceButTypeDoesNotSupportNamespacesTest() {
        this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "my-namespace", "my-config", "my-description");
    }

    @Test
    public void newStringConfigItemTest() {
        ConfigItem stringConfigItem = this.configurationFactory.newConfigItem("my-item", "my-value");
        Assert.assertEquals((Object)"my-item", (Object)stringConfigItem.getName());
        Assert.assertEquals((Object)"my-value", (Object)stringConfigItem.getValue());
    }

    @Test
    public void newBooleanConfigItemTest() {
        ConfigItem booleanConfigItem = this.configurationFactory.newConfigItem("my-item", true);
        Assert.assertEquals((Object)"my-item", (Object)booleanConfigItem.getName());
        Assert.assertTrue((boolean)((Boolean)booleanConfigItem.getValue()));
    }

    @Test
    public void newSecuredConfigItemTest() {
        SecureConfigItem securedConfigItem = this.configurationFactory.newSecuredConfigItem("my-item", "my-password");
        Assert.assertEquals((Object)"my-item", (Object)securedConfigItem.getName());
        Assert.assertEquals((Object)"my-password", (Object)this.passwordService.decrypt((String)securedConfigItem.getValue()));
    }

    @Test
    public void newListConfigItemTest() {
        ArrayList<String> values = new ArrayList<String>();
        values.add("value1");
        values.add("value2");
        ConfigItem listConfigItem = this.configurationFactory.newConfigItem("my-item", values);
        Assert.assertEquals((Object)"my-item", (Object)listConfigItem.getName());
        Assert.assertEquals((long)2L, (long)((List)listConfigItem.getValue()).size());
        Assert.assertEquals((Object)"value1", ((List)listConfigItem.getValue()).get(0));
        Assert.assertEquals((Object)"value2", ((List)listConfigItem.getValue()).get(1));
    }

    @Test
    public void newLongConfigItemTest() {
        ConfigItem longConfigItem = this.configurationFactory.newConfigItem("my-item", (Object)2L);
        Assert.assertEquals((Object)"my-item", (Object)longConfigItem.getName());
        Assert.assertEquals((Object)2L, (Object)longConfigItem.getValue());
    }
}

