/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.enterprise.event.Event;
import org.guvnor.structure.backend.FileSystemDeleteWorker;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigurationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class FileSystemDeleteWorkerTest {
    private FileSystemDeleteWorker worker;
    @Mock
    private IOService ioService;
    @Mock
    private OrganizationalUnitService ouService;
    @Mock
    private RepositoryService repoService;
    @Mock
    private FileSystem systemFs;
    @Mock
    private SpaceConfigStorageRegistry registry;
    @Mock
    private Event<RemoveOrganizationalUnitEvent> removeOrganizationalUnitEvent;
    @Mock
    private ConfigurationService configurationService;

    @Before
    public void setUp() throws IOException {
        this.worker = (FileSystemDeleteWorker)Mockito.spy((Object)new FileSystemDeleteWorker(this.ioService, this.ouService, this.repoService, this.systemFs, this.registry, this.removeOrganizationalUnitEvent, this.configurationService));
        ((IOService)Mockito.doAnswer(invocation -> null).when((Object)this.ioService)).delete((Path)Mockito.any(), new DeleteOption[0]);
        ((FileSystemDeleteWorker)Mockito.doAnswer(invocation -> null).when((Object)this.worker)).removeRepository((Repository)Mockito.any());
        ((FileSystemDeleteWorker)Mockito.doAnswer(invocation -> null).when((Object)this.worker)).delete((File)Mockito.any());
        ((Event)Mockito.doAnswer(invocation -> null).when(this.removeOrganizationalUnitEvent)).fire(Mockito.any());
    }

    @Test
    public void testRemoveSpaceDirectory() throws IOException {
        JGitPathImpl configPath = (JGitPathImpl)Mockito.mock(JGitPathImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Space space = (Space)Mockito.mock(Space.class);
        Path deletePath = (Path)Mockito.mock(Path.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)((JGitFileSystem)configPath.getFileSystem()).getPath(Mockito.anyString(), new String[0])).thenReturn((Object)deletePath);
        SpaceConfigStorageImpl configStorage = (SpaceConfigStorageImpl)Mockito.mock(SpaceConfigStorageImpl.class);
        Mockito.when((Object)configStorage.getPath()).thenReturn((Object)configPath);
        Mockito.when((Object)this.registry.get((String)Mockito.any())).thenReturn((Object)configStorage);
        ((RepositoryService)Mockito.doReturn(Collections.singletonList(Mockito.mock(Repository.class))).when((Object)this.repoService)).getAllRepositories((Space)Mockito.eq((Object)space), Mockito.eq((boolean)true));
        ((IOService)Mockito.doReturn((Object)configPath).when((Object)this.ioService)).get((URI)Mockito.any());
        File spacePathFile = (File)Mockito.mock(File.class);
        ((FileSystemDeleteWorker)Mockito.doReturn((Object)spacePathFile).when((Object)this.worker)).getSpacePath((Path)Mockito.any());
        this.worker.removeSpaceDirectory(space);
        ((FileSystemDeleteWorker)Mockito.verify((Object)this.worker, (VerificationMode)Mockito.times((int)1))).removeRepository((Repository)Mockito.any());
        ((IOService)Mockito.verify((Object)this.ioService)).deleteIfExists(deletePath, new DeleteOption[0]);
        ((FileSystemDeleteWorker)Mockito.verify((Object)this.worker)).delete(spacePathFile);
    }

    @Test
    public void testRemoveAllDeletedSpaces() {
        ((FileSystemDeleteWorker)Mockito.doAnswer(invocation -> null).when((Object)this.worker)).removeSpaceDirectory((Space)Mockito.any());
        OrganizationalUnit ou1 = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        ((OrganizationalUnit)Mockito.doReturn((Object)Mockito.mock(Space.class)).when((Object)ou1)).getSpace();
        OrganizationalUnit ou2 = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        ((OrganizationalUnit)Mockito.doReturn((Object)Mockito.mock(Space.class)).when((Object)ou2)).getSpace();
        List<OrganizationalUnit> orgUnits = Arrays.asList(ou1, ou2);
        ((OrganizationalUnitService)Mockito.doReturn(orgUnits).when((Object)this.ouService)).getAllDeletedOrganizationalUnit();
        this.worker.removeAllDeletedSpaces();
        ((FileSystemDeleteWorker)Mockito.verify((Object)this.worker, (VerificationMode)Mockito.times((int)1))).removeSpaceDirectory(ou1.getSpace());
        ((FileSystemDeleteWorker)Mockito.verify((Object)this.worker, (VerificationMode)Mockito.times((int)1))).removeSpaceDirectory(ou2.getSpace());
        ((Event)Mockito.verify(this.removeOrganizationalUnitEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any());
    }

    @Test
    public void testRemoveZeroDeletedSpaces() {
        ((FileSystemDeleteWorker)Mockito.doAnswer(invocation -> null).when((Object)this.worker)).removeSpaceDirectory((Space)Mockito.any());
        ((OrganizationalUnitService)Mockito.doReturn(new ArrayList()).when((Object)this.ouService)).getAllDeletedOrganizationalUnit();
        this.worker.removeAllDeletedSpaces();
        ((FileSystemDeleteWorker)Mockito.verify((Object)this.worker, (VerificationMode)Mockito.never())).removeSpaceDirectory((Space)Mockito.any());
        ((Event)Mockito.verify(this.removeOrganizationalUnitEvent, (VerificationMode)Mockito.never())).fire(Mockito.any());
    }

    @Test
    public void testRemoveAllDeletedRepository() {
        Repository repo1 = (Repository)Mockito.mock(Repository.class);
        Repository repo2 = (Repository)Mockito.mock(Repository.class);
        Repository repo3 = (Repository)Mockito.mock(Repository.class);
        Repository repo4 = (Repository)Mockito.mock(Repository.class);
        Space space1 = (Space)Mockito.mock(Space.class);
        Space space2 = (Space)Mockito.mock(Space.class);
        OrganizationalUnit ou1 = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        OrganizationalUnit ou2 = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        ((OrganizationalUnit)Mockito.doReturn((Object)space1).when((Object)ou1)).getSpace();
        ((OrganizationalUnit)Mockito.doReturn((Object)space2).when((Object)ou2)).getSpace();
        ((OrganizationalUnitService)Mockito.doReturn(Arrays.asList(ou1, ou2)).when((Object)this.ouService)).getAllOrganizationalUnits(Mockito.eq((boolean)false), (Predicate)Mockito.any());
        ((RepositoryService)Mockito.doReturn(Arrays.asList(repo1, repo2)).when((Object)this.repoService)).getAllDeletedRepositories((Space)Mockito.eq((Object)space1));
        ((RepositoryService)Mockito.doReturn(Arrays.asList(repo3, repo4)).when((Object)this.repoService)).getAllDeletedRepositories((Space)Mockito.eq((Object)space2));
        Branch branch = (Branch)Mockito.mock(Branch.class);
        Repository repo = (Repository)Mockito.mock(Repository.class);
        ((Repository)Mockito.doReturn(Optional.of(branch)).when((Object)repo)).getDefaultBranch();
        this.worker.removeAllDeletedRepositories();
        ((FileSystemDeleteWorker)Mockito.verify((Object)this.worker, (VerificationMode)Mockito.times((int)1))).removeRepository(repo1);
        ((FileSystemDeleteWorker)Mockito.verify((Object)this.worker, (VerificationMode)Mockito.times((int)1))).removeRepository(repo2);
        ((FileSystemDeleteWorker)Mockito.verify((Object)this.worker, (VerificationMode)Mockito.times((int)1))).removeRepository(repo3);
        ((FileSystemDeleteWorker)Mockito.verify((Object)this.worker, (VerificationMode)Mockito.times((int)1))).removeRepository(repo4);
    }

    @Test
    public void testMonitoringEnabled() {
        Mockito.when((Object)this.worker.isDeleteWorkerEnabled()).thenReturn((Object)false);
        this.worker.doRemove();
        ((FileSystemDeleteWorker)Mockito.verify((Object)this.worker, (VerificationMode)Mockito.never())).removeAllDeletedSpaces();
    }
}

