/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.guvnor.structure.backend.organizationalunit.OrganizationalUnitFactoryImpl;
import org.guvnor.structure.backend.organizationalunit.OrganizationalUnitServiceImpl;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageRegistryImpl;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.contributors.SpaceContributorsUpdatedEvent;
import org.guvnor.structure.organizationalunit.NewOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoAddedToOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.RepoRemovedFromOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.UpdatedOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.security.OrganizationalUnitAction;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.organizationalunit.OrganizationalUnitFactory;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class OrganizationalUnitServiceTest {
    private static final String SPACE_NAME = "space";
    private static final String SPACE_DESCRIPTION = "This is test space";
    private static final String DEFAULT_GROUP_ID = "default.group.id";
    private static final String REPO_A = "repoA";
    private static final String REPO_B = "repoB";
    private static final String ROLES = "security:roles";
    private static final String ADMIN = "admin";
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private SpacesAPI spacesAPI;
    @Mock
    private ConfigurationService configurationService;
    private OrganizationalUnitFactoryImpl organizationalUnitFactory;
    @Mock
    private Event<NewOrganizationalUnitEvent> newOrganizationalUnitEvent;
    @Mock
    private Event<RemoveOrganizationalUnitEvent> removeOrganizationalUnitEvent;
    @Mock
    private Event<RepoAddedToOrganizationalUnitEvent> repoAddedToOrgUnitEvent;
    @Mock
    private Event<RepoRemovedFromOrganizationalUnitEvent> repoRemovedFromOrgUnitEvent;
    @Mock
    private Event<UpdatedOrganizationalUnitEvent> updatedOrganizationalUnitEvent;
    @Mock
    private AuthorizationManager authorizationManager;
    private SessionInfo sessionInfo;
    @Mock
    private RepositoryService repoService;
    @Mock
    private OrganizationalUnit orgUnit;
    @Mock
    private IOService ioService;
    @Mock
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    @Mock
    private SpaceConfigStorage spaceConfigStorage;
    private SpaceInfo spaceInfo;
    @Mock
    private FileSystem systemFS;
    @Mock
    private Event<SpaceContributorsUpdatedEvent> spaceContributorsUpdatedEvent;
    @Captor
    private ArgumentCaptor<List<Contributor>> contributorsCapture;
    private OrganizationalUnitServiceImpl organizationalUnitService;

    @Before
    public void setUp() throws Exception {
        this.spaceInfo = new SpaceInfo(SPACE_NAME, SPACE_DESCRIPTION, DEFAULT_GROUP_ID, new ArrayList(), new ArrayList(), new ArrayList());
        Mockito.when((Object)this.spaceConfigStorage.loadSpaceInfo()).thenReturn((Object)this.spaceInfo);
        Mockito.when((Object)this.spaceConfigStorage.isInitialized()).thenReturn((Object)true);
        Mockito.when((Object)this.spaceConfigStorageRegistry.get(Mockito.anyString())).thenReturn((Object)this.spaceConfigStorage);
        Mockito.when((Object)this.spaceConfigStorageRegistry.getBatch(Mockito.anyString())).thenReturn((Object)new SpaceConfigStorageRegistryImpl.SpaceStorageBatchImpl(this.spaceConfigStorage));
        Mockito.when((Object)this.spaceConfigStorageRegistry.exist(Mockito.anyString())).thenReturn((Object)true);
        this.sessionInfo = new SessionInfoMock();
        this.organizationalUnitFactory = (OrganizationalUnitFactoryImpl)Mockito.spy((Object)new OrganizationalUnitFactoryImpl(this.repositoryService, this.spacesAPI));
        this.organizationalUnitService = (OrganizationalUnitServiceImpl)Mockito.spy((Object)new OrganizationalUnitServiceImpl((OrganizationalUnitFactory)this.organizationalUnitFactory, this.repoService, this.newOrganizationalUnitEvent, this.removeOrganizationalUnitEvent, this.repoAddedToOrgUnitEvent, this.repoRemovedFromOrgUnitEvent, this.updatedOrganizationalUnitEvent, this.authorizationManager, this.spacesAPI, this.sessionInfo, this.ioService, this.spaceConfigStorageRegistry, this.systemFS, this.spaceContributorsUpdatedEvent, this.configurationService));
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.any(User.class))).thenReturn((Object)false);
        ((OrganizationalUnitServiceImpl)Mockito.doAnswer(invocation -> false).when((Object)this.organizationalUnitService)).isDeleted((String)Matchers.any());
        ((OrganizationalUnitServiceImpl)Mockito.doReturn((Object)Paths.get((String)"src/test/resources/niogit", (String[])new String[0]).toFile().toPath()).when((Object)this.organizationalUnitService)).getNiogitPath();
    }

    @Test
    public void testAllOrgUnits() {
        Collection orgUnits = this.organizationalUnitService.getAllOrganizationalUnits();
        Assert.assertEquals((long)2L, (long)orgUnits.size());
    }

    @Test
    public void testSecuredOrgUnits() {
        Collection orgUnits = this.organizationalUnitService.getOrganizationalUnits();
        Assert.assertEquals((long)0L, (long)orgUnits.size());
    }

    @Test
    public void testSecuredOrgUnitsWithPermission() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.any(User.class))).thenReturn((Object)true);
        Collection orgUnits = this.organizationalUnitService.getOrganizationalUnits();
        Assert.assertEquals((long)2L, (long)orgUnits.size());
    }

    @Test
    public void testSecuredOrgUnitsToCollaborators() {
        Mockito.when((Object)this.orgUnit.getContributors()).thenReturn(Collections.singletonList(new Contributor(ADMIN, ContributorType.OWNER)));
        ((OrganizationalUnitServiceImpl)Mockito.doReturn(Collections.singletonList(this.orgUnit)).when((Object)this.organizationalUnitService)).getAllOrganizationalUnits(Mockito.anyBoolean());
        Collection orgUnits = this.organizationalUnitService.getOrganizationalUnits();
        Assert.assertEquals((long)1L, (long)orgUnits.size());
    }

    @Test
    public void createOrganizationalUnitWithDuplicatedNameTest() {
        this.setOUCreationPermission(true);
        ((OrganizationalUnitServiceImpl)Mockito.doReturn((Object)true).when((Object)this.organizationalUnitService)).spaceDirectoryExists(Mockito.anyString());
        OrganizationalUnit ou = this.organizationalUnitService.createOrganizationalUnit(SPACE_NAME, DEFAULT_GROUP_ID);
        Assert.assertNull((Object)ou);
        ((OrganizationalUnitFactoryImpl)Mockito.verify((Object)this.organizationalUnitFactory, (VerificationMode)Mockito.never())).newOrganizationalUnit((SpaceInfo)Matchers.any());
    }

    @Test
    public void createValidOrganizationalUnitTest() {
        ArrayList<Contributor> contributors = new ArrayList<Contributor>();
        contributors.add(new Contributor(ADMIN, ContributorType.ADMIN));
        this.setOUCreationPermission(true);
        OrganizationalUnit ou = this.organizationalUnitService.createOrganizationalUnit(SPACE_NAME, DEFAULT_GROUP_ID, new ArrayList(), contributors, SPACE_DESCRIPTION);
        Assert.assertNotNull((Object)ou);
        ((OrganizationalUnitFactoryImpl)Mockito.verify((Object)this.organizationalUnitFactory)).newOrganizationalUnit((SpaceInfo)Matchers.any());
        Assert.assertEquals((Object)SPACE_NAME, (Object)ou.getName());
        Assert.assertEquals((Object)SPACE_DESCRIPTION, (Object)ou.getDescription());
        Assert.assertEquals((Object)DEFAULT_GROUP_ID, (Object)ou.getDefaultGroupId());
        Assert.assertEquals(contributors, (Object)ou.getContributors());
    }

    @Test
    public void removeOrganizationalUnitRemovesRepositories() throws Exception {
        Repository repoA = (Repository)Mockito.mock(Repository.class);
        Repository repoB = (Repository)Mockito.mock(Repository.class);
        List<Repository> repos = Arrays.asList(repoA, repoB);
        Mockito.when((Object)repoA.getAlias()).thenReturn((Object)REPO_A);
        Mockito.when((Object)repoB.getAlias()).thenReturn((Object)REPO_B);
        Space space = new Space(SPACE_NAME);
        Mockito.when((Object)this.orgUnit.getRepositories()).thenReturn(repos);
        Mockito.when((Object)this.orgUnit.getSpace()).thenReturn((Object)space);
        ConfigGroup configGroup = new ConfigGroup();
        configGroup.setName(SPACE_NAME);
        Mockito.when((Object)this.configurationService.getConfiguration(ConfigType.SPACE)).thenReturn(Collections.singletonList(configGroup));
        JGitPathImpl configPath = (JGitPathImpl)Mockito.mock(JGitPathImpl.class);
        JGitFileSystem fileSystem = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Git git = (Git)Mockito.mock(Git.class);
        org.eclipse.jgit.lib.Repository repository = (org.eclipse.jgit.lib.Repository)Mockito.mock(org.eclipse.jgit.lib.Repository.class);
        File directory = (File)Mockito.mock(File.class);
        Path fsPath = (Path)Mockito.mock(Path.class);
        ((File)Mockito.doReturn((Object)directory).when((Object)directory)).getParentFile();
        ((org.eclipse.jgit.lib.Repository)Mockito.doReturn((Object)directory).when((Object)repository)).getDirectory();
        ((Git)Mockito.doReturn((Object)repository).when((Object)git)).getRepository();
        ((JGitFileSystem)Mockito.doReturn((Object)git).when((Object)fileSystem)).getGit();
        ((JGitFileSystem)Mockito.doReturn((Object)fsPath).when((Object)fileSystem)).getPath("", new String[0]);
        ((JGitPathImpl)Mockito.doReturn((Object)fileSystem).when((Object)configPath)).getFileSystem();
        ((IOService)Mockito.doReturn((Object)configPath).when((Object)this.ioService)).get((URI)Matchers.any(URI.class));
        ((OrganizationalUnitServiceImpl)Mockito.doReturn((Object)this.orgUnit).when((Object)this.organizationalUnitService)).getOrganizationalUnit(SPACE_NAME);
        this.organizationalUnitService.removeOrganizationalUnit(SPACE_NAME);
        ((RepositoryService)Mockito.verify((Object)this.repoService)).removeRepositories((Space)Matchers.eq((Object)space), (Set)Matchers.eq(new HashSet<String>(Arrays.asList(REPO_A, REPO_B))));
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(RemoveOrganizationalUnitEvent.class);
        ((Event)Mockito.verify(this.removeOrganizationalUnitEvent)).fire(eventCaptor.capture());
        RemoveOrganizationalUnitEvent event = (RemoveOrganizationalUnitEvent)eventCaptor.getValue();
        Assert.assertEquals(repos, (Object)event.getOrganizationalUnit().getRepositories());
    }

    @Test
    public void testOnRemoveOrgUnit() {
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl(SPACE_NAME, DEFAULT_GROUP_ID);
        RemoveOrganizationalUnitEvent event = new RemoveOrganizationalUnitEvent((OrganizationalUnit)organizationalUnit, ADMIN);
        this.organizationalUnitService.onRemoveOrganizationalUnit(event);
        ((SpaceConfigStorageRegistry)Mockito.verify((Object)this.spaceConfigStorageRegistry)).remove(SPACE_NAME);
    }

    @Test
    public void testUpdateOrganizationalUnit() {
        String newGroupId = "newGroupId";
        OrganizationalUnit organizationalUnit = this.organizationalUnitService.updateOrganizationalUnit(SPACE_NAME, "newGroupId", Collections.emptyList());
        ((ObjectAssert)Assertions.assertThat((Object)organizationalUnit).hasFieldOrPropertyWithValue("name", (Object)SPACE_NAME)).hasFieldOrPropertyWithValue("defaultGroupId", (Object)"newGroupId");
        ((ObjectAssert)Assertions.assertThat((Object)this.spaceInfo).hasFieldOrPropertyWithValue("name", (Object)SPACE_NAME)).hasFieldOrPropertyWithValue("defaultGroupId", (Object)"newGroupId");
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).startBatch();
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).saveSpaceInfo((SpaceInfo)Matchers.eq((Object)this.spaceInfo));
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).endBatch();
    }

    @Test
    public void testCheckChildrenRepositoryContributors() {
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl(SPACE_NAME, DEFAULT_GROUP_ID);
        organizationalUnit.getContributors().add(new Contributor("contributor1", ContributorType.OWNER));
        organizationalUnit.getContributors().add(new Contributor("contributor2", ContributorType.ADMIN));
        organizationalUnit.getContributors().add(new Contributor("contributor3", ContributorType.CONTRIBUTOR));
        Repository repository = (Repository)Mockito.mock(Repository.class);
        ArrayList<Contributor> repositoryContributors = new ArrayList<Contributor>();
        repositoryContributors.add(new Contributor("contributor1", ContributorType.OWNER));
        repositoryContributors.add(new Contributor("contributor2", ContributorType.CONTRIBUTOR));
        repositoryContributors.add(new Contributor("contributor4", ContributorType.ADMIN));
        ((Repository)Mockito.doReturn(repositoryContributors).when((Object)repository)).getContributors();
        ((RepositoryService)Mockito.doReturn(Collections.singletonList(repository)).when((Object)this.repoService)).getAllRepositories((Space)Matchers.any());
        this.organizationalUnitService.checkChildrenRepositoryContributors((OrganizationalUnit)organizationalUnit);
        ((RepositoryService)Mockito.verify((Object)this.repoService)).updateContributors((Repository)Matchers.same((Object)repository), (List)this.contributorsCapture.capture());
        List updateRepositoryContributors = (List)this.contributorsCapture.getValue();
        Assert.assertEquals((long)2L, (long)updateRepositoryContributors.size());
        Assert.assertEquals((Object)"contributor1", (Object)((Contributor)updateRepositoryContributors.get(0)).getUsername());
        Assert.assertEquals((Object)ContributorType.OWNER, (Object)((Contributor)updateRepositoryContributors.get(0)).getType());
        Assert.assertEquals((Object)"contributor2", (Object)((Contributor)updateRepositoryContributors.get(1)).getUsername());
        Assert.assertEquals((Object)ContributorType.CONTRIBUTOR, (Object)((Contributor)updateRepositoryContributors.get(1)).getType());
    }

    @Test
    public void testAddGroup() {
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl(SPACE_NAME, DEFAULT_GROUP_ID);
        this.organizationalUnitService.addGroup((OrganizationalUnit)organizationalUnit, ROLES);
        ArgumentCaptor captor = ArgumentCaptor.forClass(UpdatedOrganizationalUnitEvent.class);
        ((Event)Mockito.verify(this.updatedOrganizationalUnitEvent)).fire(captor.capture());
        Assert.assertSame((Object)ADMIN, (Object)((UpdatedOrganizationalUnitEvent)captor.getValue()).getUserName());
        ((ObjectAssert)Assertions.assertThat((Object)((UpdatedOrganizationalUnitEvent)captor.getValue()).getOrganizationalUnit()).hasFieldOrPropertyWithValue("name", (Object)SPACE_NAME)).hasFieldOrPropertyWithValue("defaultGroupId", (Object)DEFAULT_GROUP_ID);
        ((IterableAssert)Assertions.assertThat((Iterable)((UpdatedOrganizationalUnitEvent)captor.getValue()).getOrganizationalUnit().getGroups()).hasSize(1)).containsExactly((Object[])new String[]{ROLES});
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).startBatch();
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).saveSpaceInfo((SpaceInfo)Matchers.eq((Object)this.spaceInfo));
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).endBatch();
        ((ListAssert)Assertions.assertThat((List)this.spaceInfo.getSecurityGroups()).hasSize(1)).contains((Object[])new String[]{ROLES});
    }

    @Test
    public void testRemoveGroup() {
        this.testAddGroup();
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl(SPACE_NAME, DEFAULT_GROUP_ID);
        this.organizationalUnitService.removeGroup((OrganizationalUnit)organizationalUnit, ROLES);
        ArgumentCaptor captor = ArgumentCaptor.forClass(UpdatedOrganizationalUnitEvent.class);
        ((Event)Mockito.verify(this.updatedOrganizationalUnitEvent, (VerificationMode)Mockito.times((int)2))).fire(captor.capture());
        Assert.assertSame((Object)ADMIN, (Object)((UpdatedOrganizationalUnitEvent)captor.getValue()).getUserName());
        ((ObjectAssert)Assertions.assertThat((Object)((UpdatedOrganizationalUnitEvent)captor.getValue()).getOrganizationalUnit()).hasFieldOrPropertyWithValue("name", (Object)SPACE_NAME)).hasFieldOrPropertyWithValue("defaultGroupId", (Object)DEFAULT_GROUP_ID);
        Assertions.assertThat((Iterable)((UpdatedOrganizationalUnitEvent)captor.getValue()).getOrganizationalUnit().getGroups()).isEmpty();
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)2))).startBatch();
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)2))).saveSpaceInfo((SpaceInfo)Matchers.eq((Object)this.spaceInfo));
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)2))).endBatch();
    }

    @Test
    public void testAddRepository() {
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl(SPACE_NAME, DEFAULT_GROUP_ID);
        Repository repoA = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repoA.getAlias()).thenReturn((Object)REPO_A);
        this.organizationalUnitService.addRepository((OrganizationalUnit)organizationalUnit, repoA);
        this.checkRepos(1, REPO_A, false);
        ArgumentCaptor captor = ArgumentCaptor.forClass(RepoAddedToOrganizationalUnitEvent.class);
        ((Event)Mockito.verify(this.repoAddedToOrgUnitEvent)).fire(captor.capture());
        Assert.assertSame((Object)repoA, (Object)((RepoAddedToOrganizationalUnitEvent)captor.getValue()).getRepository());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).startBatch();
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).saveSpaceInfo((SpaceInfo)Matchers.eq((Object)this.spaceInfo));
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage)).endBatch();
        Repository repoB = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repoB.getAlias()).thenReturn((Object)REPO_B);
        this.organizationalUnitService.addRepository((OrganizationalUnit)organizationalUnit, repoB);
        this.checkRepos(2, REPO_B, false);
        captor = ArgumentCaptor.forClass(RepoAddedToOrganizationalUnitEvent.class);
        ((Event)Mockito.verify(this.repoAddedToOrgUnitEvent, (VerificationMode)Mockito.times((int)2))).fire(captor.capture());
        Assert.assertSame((Object)repoB, (Object)((RepoAddedToOrganizationalUnitEvent)captor.getValue()).getRepository());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)2))).startBatch();
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)2))).saveSpaceInfo((SpaceInfo)Matchers.eq((Object)this.spaceInfo));
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)2))).endBatch();
    }

    @Test
    public void testRemoveRepository() {
        this.testAddRepository();
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl(SPACE_NAME, DEFAULT_GROUP_ID);
        Repository repoA = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repoA.getAlias()).thenReturn((Object)REPO_A);
        this.organizationalUnitService.removeRepository((OrganizationalUnit)organizationalUnit, repoA);
        this.checkRepos(2, REPO_A, true);
        ArgumentCaptor captor = ArgumentCaptor.forClass(RepoRemovedFromOrganizationalUnitEvent.class);
        ((Event)Mockito.verify(this.repoRemovedFromOrgUnitEvent)).fire(captor.capture());
        Assert.assertSame((Object)repoA, (Object)((RepoRemovedFromOrganizationalUnitEvent)captor.getValue()).getRepository());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)3))).startBatch();
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)3))).saveSpaceInfo((SpaceInfo)Matchers.eq((Object)this.spaceInfo));
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)3))).endBatch();
        Repository repoB = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repoB.getAlias()).thenReturn((Object)REPO_B);
        this.organizationalUnitService.removeRepository((OrganizationalUnit)organizationalUnit, repoB);
        this.checkRepos(2, REPO_B, true);
        captor = ArgumentCaptor.forClass(RepoRemovedFromOrganizationalUnitEvent.class);
        ((Event)Mockito.verify(this.repoRemovedFromOrgUnitEvent, (VerificationMode)Mockito.times((int)2))).fire(captor.capture());
        Assert.assertSame((Object)repoB, (Object)((RepoRemovedFromOrganizationalUnitEvent)captor.getValue()).getRepository());
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)4))).startBatch();
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)4))).saveSpaceInfo((SpaceInfo)Matchers.eq((Object)this.spaceInfo));
        ((SpaceConfigStorage)Mockito.verify((Object)this.spaceConfigStorage, (VerificationMode)Mockito.times((int)4))).endBatch();
    }

    private void checkRepos(int expectedRepos, String repoName, boolean deleted) {
        ((ListAssert)Assertions.assertThat((List)this.spaceInfo.getRepositories()).hasSize(expectedRepos)).areAtLeastOne(new Condition(repositoryInfo -> repositoryInfo.getName().equals(repoName) && repositoryInfo.isDeleted() == deleted, "RepositoryInfo {name: '" + repoName + "', deleted: " + deleted + "}", new Object[0]));
    }

    private void setOUCreationPermission(boolean hasPermission) {
        Mockito.when((Object)this.authorizationManager.authorize((ResourceType)Matchers.eq((Object)OrganizationalUnit.RESOURCE_TYPE), (ResourceAction)Matchers.eq((Object)OrganizationalUnitAction.CREATE), (User)Matchers.any(User.class))).thenReturn((Object)hasPermission);
    }
}

