/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.config;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import org.guvnor.structure.backend.config.ConfigGroupMarshaller;
import org.guvnor.structure.backend.config.ConfigurationFactoryImpl;
import org.guvnor.structure.backend.config.ConfigurationServiceImpl;
import org.guvnor.structure.backend.config.DefaultPasswordServiceImpl;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.config.PasswordService;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.mocks.FileSystemTestingUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfigurationServiceImplTest {
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    @Mock
    private Repository systemRepository;
    @Mock
    private User identity;
    @Mock
    private Event<SystemRepositoryChangedEvent> repoChangedEvent;
    @Mock
    private Event<SystemRepositoryChangedEvent> spaceChangedEvent;
    @Mock
    private Event<SystemRepositoryChangedEvent> changedEvent;
    private ConfigGroupMarshaller marshaller;
    private IOService ioService;
    private ConfigurationFactory configurationFactory;
    private ConfigurationService configurationService;

    @Before
    public void setup() throws IOException {
        fileSystemTestingUtils.setup();
        Mockito.when((Object)this.systemRepository.getUri()).thenReturn((Object)"git://amend-repo-test");
        this.marshaller = new ConfigGroupMarshaller();
        this.configurationFactory = new ConfigurationFactoryImpl((PasswordService)new DefaultPasswordServiceImpl());
        this.ioService = this.mockIoService();
        this.configurationService = new ConfigurationServiceImpl(this.systemRepository, this.marshaller, this.identity, this.ioService, this.repoChangedEvent, this.spaceChangedEvent, this.changedEvent, fileSystemTestingUtils.getFileSystem());
    }

    @After
    public void cleanupFileSystem() {
        fileSystemTestingUtils.cleanup();
    }

    @Test
    public void addAndGetConfigurationWithoutNamespaceTest() {
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "global1", "global1-description"));
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.SPACE, "space1", "space1-description"));
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "global2", "global2-description"));
        List globalConfigGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        Assert.assertEquals((long)2L, (long)globalConfigGroups.size());
        Assert.assertEquals((Object)"global1", (Object)((ConfigGroup)globalConfigGroups.get(0)).getName());
        Assert.assertEquals((Object)"global2", (Object)((ConfigGroup)globalConfigGroups.get(1)).getName());
        List spaceConfigGroups = this.configurationService.getConfiguration(ConfigType.SPACE);
        Assert.assertEquals((long)1L, (long)spaceConfigGroups.size());
        Assert.assertEquals((Object)"space1", (Object)((ConfigGroup)spaceConfigGroups.get(0)).getName());
    }

    @Test(expected=RuntimeException.class)
    public void addAndGetConfigurationWithoutNamespaceButTypeRequiresNamespaceTest() {
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace1", "global1", "global1-description"));
        this.configurationService.getConfiguration(ConfigType.REPOSITORY);
    }

    @Test
    public void addAndGetConfigurationWithNamespaceTest() {
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace1", "repo1", "repo1-description"));
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace1", "repo2", "repo2-description"));
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "global1", "global1-description"));
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace2", "repo3", "repo3-description"));
        List repositoryNamespace1ConfigGroups = this.configurationService.getConfiguration(ConfigType.REPOSITORY, "namespace1");
        Assert.assertEquals((long)2L, (long)repositoryNamespace1ConfigGroups.size());
        Assert.assertEquals((Object)"repo1", (Object)((ConfigGroup)repositoryNamespace1ConfigGroups.get(0)).getName());
        Assert.assertEquals((Object)"repo2", (Object)((ConfigGroup)repositoryNamespace1ConfigGroups.get(1)).getName());
        List repositoryNamespace2ConfigGroups = this.configurationService.getConfiguration(ConfigType.REPOSITORY, "namespace2");
        Assert.assertEquals((long)1L, (long)repositoryNamespace2ConfigGroups.size());
        Assert.assertEquals((Object)"repo3", (Object)((ConfigGroup)repositoryNamespace2ConfigGroups.get(0)).getName());
        List globalConfigGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        Assert.assertEquals((long)1L, (long)globalConfigGroups.size());
        Assert.assertEquals((Object)"global1", (Object)((ConfigGroup)globalConfigGroups.get(0)).getName());
    }

    @Test(expected=RuntimeException.class)
    public void addAndGetConfigurationWithNamespaceButTypeDoesNotSupportNamespacesTest() {
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "global1", "global1-description"));
        this.configurationService.getConfiguration(ConfigType.GLOBAL, "namespace1");
    }

    @Test
    public void addAndGetConfigurationByNamespaceTest() {
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace1", "repo1", "repo1-description"));
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace1", "repo2", "repo2-description"));
        this.configurationService.addConfiguration(this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace2", "repo3", "repo3-description"));
        Map configGroupsByNamespace = this.configurationService.getConfigurationByNamespace(ConfigType.REPOSITORY);
        Assert.assertEquals((long)2L, (long)configGroupsByNamespace.size());
        List repositoryNamespace1ConfigGroups = (List)configGroupsByNamespace.get("namespace1");
        Assert.assertEquals((long)2L, (long)repositoryNamespace1ConfigGroups.size());
        Assert.assertEquals((Object)"repo1", (Object)((ConfigGroup)repositoryNamespace1ConfigGroups.get(0)).getName());
        Assert.assertEquals((Object)"repo2", (Object)((ConfigGroup)repositoryNamespace1ConfigGroups.get(1)).getName());
        List repositoryNamespace2ConfigGroups = (List)configGroupsByNamespace.get("namespace2");
        Assert.assertEquals((long)1L, (long)repositoryNamespace2ConfigGroups.size());
        Assert.assertEquals((Object)"repo3", (Object)((ConfigGroup)repositoryNamespace2ConfigGroups.get(0)).getName());
    }

    @Test
    public void updateConfigurationWithoutNamespaceTest() {
        ConfigGroup config = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "config", "description");
        this.configurationService.addConfiguration(config);
        config.setDescription("new-description");
        this.configurationService.updateConfiguration(config);
        List configGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        Assert.assertEquals((long)1L, (long)configGroups.size());
        Assert.assertEquals((Object)"config", (Object)((ConfigGroup)configGroups.get(0)).getName());
        Assert.assertEquals((Object)"new-description", (Object)((ConfigGroup)configGroups.get(0)).getDescription());
    }

    @Test
    public void updateConfigurationWithNamespaceTest() {
        ConfigGroup config = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace", "config", "description");
        this.configurationService.addConfiguration(config);
        config.setDescription("new-description");
        this.configurationService.updateConfiguration(config);
        List configGroups = this.configurationService.getConfiguration(ConfigType.REPOSITORY, "namespace");
        Assert.assertEquals((long)1L, (long)configGroups.size());
        Assert.assertEquals((Object)"config", (Object)((ConfigGroup)configGroups.get(0)).getName());
        Assert.assertEquals((Object)"namespace", (Object)((ConfigGroup)configGroups.get(0)).getNamespace());
        Assert.assertEquals((Object)"new-description", (Object)((ConfigGroup)configGroups.get(0)).getDescription());
    }

    @Test
    public void removeConfigurationWithoutNamespaceTest() {
        ConfigGroup config = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "config", "description");
        this.configurationService.removeConfiguration(config);
        List configGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        Assert.assertEquals((long)0L, (long)configGroups.size());
    }

    @Test
    public void removeConfigurationWithNamespaceTest() {
        ConfigGroup config = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace", "config", "description");
        this.configurationService.addConfiguration(config);
        this.configurationService.removeConfiguration(config);
        List configGroups = this.configurationService.getConfiguration(ConfigType.REPOSITORY, "namespace");
        Assert.assertEquals((long)0L, (long)configGroups.size());
    }

    @Test
    public void cleanUpSystemRepositoryTest() {
        ConfigGroup config = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, "namespace", "config", "description");
        this.configurationService.addConfiguration(config);
        boolean result = this.configurationService.cleanUpSystemRepository();
        Assert.assertTrue((boolean)result);
    }

    private IOService mockIoService() {
        IOService ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        ((IOService)Mockito.doNothing().when((Object)ioService)).startBatch((FileSystem)Matchers.any(FileSystem.class));
        ((IOService)Mockito.doNothing().when((Object)ioService)).endBatch();
        return ioService;
    }
}

