/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.guvnor.common.services.project.events.RepositoryContributorsUpdatedEvent;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageRegistryImpl;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.backend.repositories.RepositoryServiceImpl;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.repositories.GitMetadataStore;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.server.config.PasswordService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class RepositoryServiceImplTest {
    @Mock
    private Repository repository;
    @Mock
    private ConfiguredRepositories configuredRepositories;
    @Mock
    private SpaceConfigStorageRegistry registry;
    @Mock
    private Event<RepositoryContributorsUpdatedEvent> updatedEvent;
    @Mock
    private GitMetadataStore gitMetadataStore;
    @Mock
    private OrganizationalUnitService organizationalUnitService;
    @Mock
    private SpacesAPI spacesAPI;
    @Mock
    private PasswordService passwordService;
    @Mock
    private RepositoryFactory repositoryFactory;
    @InjectMocks
    @Spy
    private RepositoryServiceImpl repositoryService;
    @Captor
    private ArgumentCaptor<RepositoryContributorsUpdatedEvent> captor;
    @Captor
    private ArgumentCaptor<RepositoryInfo> configCaptor;

    @Before
    public void setUp() {
        ((GitMetadataStore)Mockito.doAnswer(invocationOnMock -> null).when((Object)this.gitMetadataStore)).delete(Mockito.anyString());
    }

    @Test
    public void testNotCreateNewAliasIfNecessary() {
        String newAlias = this.repositoryService.createFreshRepositoryAlias("alias", new Space("alias"));
        Assert.assertEquals((Object)"alias", (Object)newAlias);
    }

    @Test
    public void testCreateNewAliasIfNecessary() {
        Mockito.when((Object)this.configuredRepositories.getRepositoryByRepositoryAlias((Space)Matchers.any(), (String)Matchers.eq((Object)"alias"), Matchers.eq((boolean)true))).thenReturn((Object)this.repository);
        String newAlias = this.repositoryService.createFreshRepositoryAlias("alias", new Space("alias"));
        Assert.assertEquals((Object)"alias-1", (Object)newAlias);
    }

    @Test
    public void testCreateSecondNewAliasIfNecessary() {
        Mockito.when((Object)this.configuredRepositories.getRepositoryByRepositoryAlias((Space)Matchers.any(), (String)Matchers.eq((Object)"alias"), Matchers.eq((boolean)true))).thenReturn((Object)this.repository);
        Mockito.when((Object)this.configuredRepositories.getRepositoryByRepositoryAlias((Space)Matchers.any(), (String)Matchers.eq((Object)"alias-1"), Matchers.eq((boolean)true))).thenReturn((Object)this.repository);
        String newAlias = this.repositoryService.createFreshRepositoryAlias("alias", new Space("alias"));
        Assert.assertEquals((Object)"alias-2", (Object)newAlias);
    }

    @Test
    public void updateContributorsTest() {
        Space space = new Space("space");
        ((Repository)Mockito.doReturn((Object)space).when((Object)this.repository)).getSpace();
        ((Repository)Mockito.doReturn((Object)"alias").when((Object)this.repository)).getAlias();
        ((ConfiguredRepositories)Mockito.doReturn((Object)this.repository).when((Object)this.configuredRepositories)).getRepositoryByRepositoryAlias((Space)Matchers.any(), (String)Matchers.any());
        SpaceConfigStorage spaceConfigStorage = (SpaceConfigStorage)Mockito.mock(SpaceConfigStorage.class);
        ((SpaceConfigStorage)Mockito.doReturn((Object)new SpaceInfo("space", "Test space", "defaultGroupId", Collections.emptyList(), new ArrayList<RepositoryInfo>(Arrays.asList(new RepositoryInfo("alias", false, new RepositoryConfiguration()))), Collections.emptyList())).when((Object)spaceConfigStorage)).loadSpaceInfo();
        Mockito.when((Object)this.registry.get(Mockito.anyString())).thenReturn((Object)spaceConfigStorage);
        Mockito.when((Object)this.registry.getBatch(Mockito.anyString())).thenReturn((Object)new SpaceConfigStorageRegistryImpl.SpaceStorageBatchImpl(spaceConfigStorage));
        String username = "admin1";
        this.repositoryService.updateContributors(this.repository, Collections.singletonList(new Contributor(username, ContributorType.OWNER)));
        ((Event)Mockito.verify(this.updatedEvent)).fire(this.captor.capture());
        Assert.assertEquals((Object)"alias", (Object)((RepositoryContributorsUpdatedEvent)this.captor.getValue()).getRepository().getAlias());
        Assert.assertEquals((Object)"space", (Object)((RepositoryContributorsUpdatedEvent)this.captor.getValue()).getRepository().getSpace().getName());
        ((RepositoryServiceImpl)Mockito.verify((Object)this.repositoryService)).saveRepositoryConfig((String)Matchers.eq((Object)"space"), (RepositoryInfo)this.configCaptor.capture());
        Assert.assertEquals((Object)username, (Object)((Contributor)((RepositoryInfo)this.configCaptor.getValue()).getContributors().get(0)).getUsername());
        Assert.assertEquals((Object)ContributorType.OWNER, (Object)((Contributor)((RepositoryInfo)this.configCaptor.getValue()).getContributors().get(0)).getType());
        ((SpaceConfigStorage)Mockito.verify((Object)spaceConfigStorage)).startBatch();
        ((SpaceConfigStorage)Mockito.verify((Object)spaceConfigStorage)).saveSpaceInfo((SpaceInfo)Matchers.any());
        ((SpaceConfigStorage)Mockito.verify((Object)spaceConfigStorage)).endBatch();
    }

    @Test
    public void testDoRemoveInOrder() {
        Consumer notification = (Consumer)Mockito.mock(Consumer.class);
        OrganizationalUnit orgUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        String alias = "alias";
        Optional<Object> repositoryConfig = Optional.of(Mockito.mock(RepositoryInfo.class));
        ((RepositoryServiceImpl)Mockito.doAnswer(invocationOnMock -> null).when((Object)this.repositoryService)).close((Optional)Matchers.any());
        Mockito.when((Object)this.configuredRepositories.getRepositoryByRepositoryAlias((Space)Matchers.any(), Mockito.anyString())).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getAlias()).thenReturn((Object)alias);
        Mockito.when((Object)orgUnit.getRepositories()).thenReturn(Collections.singletonList(this.repository));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.organizationalUnitService, notification});
        this.repositoryService.doRemoveRepository(orgUnit, alias, repositoryConfig, notification, false);
        ((OrganizationalUnitService)inOrder.verify((Object)this.organizationalUnitService)).removeRepository((OrganizationalUnit)Matchers.any(), (Repository)Matchers.any());
        ((Consumer)inOrder.verify((Object)notification)).accept(this.repository);
    }

    @Test
    public void testCreateRepositoryConfiguration() {
        String space = "space";
        String scheme = "git";
        String repoName = "test";
        String userName = "user";
        String password = "pass";
        OrganizationalUnit orgUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        Mockito.when((Object)orgUnit.getName()).thenReturn((Object)"space");
        SpaceConfigStorage spaceConfigStorage = (SpaceConfigStorage)Mockito.mock(SpaceConfigStorage.class);
        Mockito.when((Object)this.registry.getBatch(Mockito.anyString())).thenReturn((Object)new SpaceConfigStorageRegistryImpl.SpaceStorageBatchImpl(spaceConfigStorage));
        Mockito.when((Object)this.spacesAPI.getSpace(Mockito.anyString())).thenAnswer(invocationOnMock -> new Space(invocationOnMock.getArguments()[0].toString()));
        Mockito.when((Object)this.passwordService.encrypt(Mockito.anyString())).thenAnswer(invocationOnMock -> invocationOnMock.getArguments()[0].toString());
        RepositoryEnvironmentConfigurations configurations = new RepositoryEnvironmentConfigurations();
        configurations.setUserName("user");
        configurations.setPassword("pass");
        configurations.setOrigin("https://github.com/kiegroup/appformer.git");
        this.repositoryService.createRepository(orgUnit, "git", "test", configurations, Collections.emptyList());
        ((PasswordService)Mockito.verify((Object)this.passwordService, (VerificationMode)Mockito.times((int)1))).encrypt((String)Matchers.eq((Object)"pass"));
        ArgumentCaptor captor = ArgumentCaptor.forClass(RepositoryInfo.class);
        ((RepositoryFactory)Mockito.verify((Object)this.repositoryFactory)).newRepository((RepositoryInfo)captor.capture());
        RepositoryInfo info = (RepositoryInfo)captor.getValue();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)info).isNotNull()).hasFieldOrPropertyWithValue("name", (Object)"test")).hasFieldOrPropertyWithValue("deleted", (Object)false);
        Assert.assertEquals((Object)"git", (Object)info.getScheme());
        Assert.assertEquals((Object)"space", (Object)info.getSpace());
        Assert.assertEquals((Object)"user", (Object)info.getConfiguration().get(String.class, "username"));
        Assert.assertEquals((Object)"pass", (Object)info.getConfiguration().get(String.class, "secure:password"));
    }
}

