/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.guvnor.structure.backend.repositories.BranchAccessAuthorizer;
import org.guvnor.structure.backend.repositories.git.GitRepositoryFactoryHelper;
import org.guvnor.structure.backend.repositories.git.hooks.PostCommitNotificationService;
import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryExternalUpdateEvent;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.PasswordService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.spaces.SpacesAPIImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.extensions.FileSystemHookExecutionContext;
import org.uberfire.java.nio.file.extensions.FileSystemHooks;
import org.uberfire.spaces.SpacesAPI;

public abstract class GitRepositoryFactoryHelperBaseTest {
    protected Mode mode;
    @Mock
    protected IOService indexed;
    @Mock
    protected IOService notIndexed;
    @Mock
    protected FileSystem fileSystem;
    @Mock
    protected Event<RepositoryExternalUpdateEvent> repositoryExternalUpdate;
    @Mock
    protected PostCommitNotificationService postCommitNotificationService;
    @Mock
    protected BranchAccessAuthorizer branchAccessAuthorizer;
    @Mock
    private PasswordService passwordService;
    protected GitRepositoryFactoryHelper helper;
    protected ArrayList<Path> rootDirectories;
    protected SpacesAPI spacesAPI;

    public void init() {
        Mockito.when((Object)this.passwordService.decrypt(Mockito.anyString())).thenAnswer(invocationOnMock -> invocationOnMock.getArguments()[0].toString());
        this.spacesAPI = new SpacesAPIImpl();
        this.helper = new GitRepositoryFactoryHelper(this.indexed, this.notIndexed, this.spacesAPI, this.repositoryExternalUpdate, this.postCommitNotificationService, this.branchAccessAuthorizer, this.passwordService);
        if (Mode.INDEXED.equals((Object)this.mode)) {
            this.initServices(this.indexed, this.notIndexed);
        } else {
            this.initServices(this.notIndexed, this.indexed);
        }
        this.rootDirectories = new ArrayList();
        Mockito.when((Object)this.fileSystem.getRootDirectories()).thenReturn(this.rootDirectories);
    }

    private void initServices(IOService normal, IOService withException) {
        Mockito.when((Object)normal.newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap())).thenReturn((Object)this.fileSystem);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoSchemeConfigItem() {
        this.helper.newRepository(new RepositoryInfo("test", false, new RepositoryConfiguration()));
    }

    @Test(expected=IllegalStateException.class)
    public void testNotValid() {
        this.helper.newRepository(new RepositoryInfo(null, false, this.getConfig()));
    }

    @Test
    public void testNewRepositoryReplaceIfExists() {
        this.rootDirectories.add(this.createPath("default://master@uf-playground"));
        RepositoryConfiguration config = this.getConfig();
        config.add("replaceIfExists", (Object)true);
        RepositoryInfo repositoryInfo = new RepositoryInfo("test", false, config);
        IOService service = this.getServiceToTest();
        Mockito.when((Object)service.newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap())).thenThrow(FileSystemAlreadyExistsException.class).thenReturn((Object)this.fileSystem);
        Mockito.when((Object)service.getFileSystem((URI)Matchers.any(URI.class))).thenReturn((Object)this.fileSystem);
        this.helper.newRepository(repositoryInfo);
        ((PasswordService)Mockito.verify((Object)this.passwordService)).decrypt(Mockito.anyString());
        ((IOService)Mockito.verify((Object)service, (VerificationMode)Mockito.times((int)1))).delete((Path)Matchers.any(), new DeleteOption[0]);
        ((IOService)Mockito.verify((Object)service, (VerificationMode)Mockito.times((int)2))).newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap());
    }

    @Test
    public void testFileSystemHooks() {
        this.rootDirectories.add(this.createPath("default://master@uf-playground"));
        RepositoryInfo repositoryInfo = new RepositoryInfo("test", false, this.getConfig());
        IOService service = this.getServiceToTest();
        this.helper.newRepository(repositoryInfo);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Map.class);
        ((IOService)Mockito.verify((Object)service)).newFileSystem((URI)Matchers.any(URI.class), (Map)captor.capture());
        Map params = (Map)captor.getValue();
        Assertions.assertThat((Map)params).isNotNull();
        ((ObjectAssert)Assertions.assertThat(params.get(FileSystemHooks.ExternalUpdate.name())).isNotNull()).isInstanceOf(FileSystemHooks.FileSystemHook.class);
        FileSystemHookExecutionContext ctx = new FileSystemHookExecutionContext("test");
        FileSystemHooks.FileSystemHook hook = (FileSystemHooks.FileSystemHook)params.get(FileSystemHooks.ExternalUpdate.name());
        hook.execute(ctx);
        ((Event)Mockito.verify(this.repositoryExternalUpdate)).fire(Matchers.any());
        ((ObjectAssert)Assertions.assertThat(params.get(FileSystemHooks.PostCommit.name())).isNotNull()).isInstanceOf(FileSystemHooks.FileSystemHook.class);
        ctx.addParam("POST_COMMIT_EXIT_CODE", (Object)0);
        hook = (FileSystemHooks.FileSystemHook)params.get(FileSystemHooks.PostCommit.name());
        hook.execute(ctx);
        ((PostCommitNotificationService)Mockito.verify((Object)this.postCommitNotificationService)).notifyUser((GitRepository)Matchers.any(), Integer.valueOf(Mockito.eq((int)0)));
    }

    private IOService getServiceToTest() {
        if (Mode.INDEXED.equals((Object)this.mode)) {
            return this.indexed;
        }
        return this.notIndexed;
    }

    @Test
    public void testBranches() {
        this.rootDirectories.add(this.createPath("default://origin@uf-playground"));
        this.rootDirectories.add(this.createPath("default://master@uf-playground"));
        this.rootDirectories.add(this.createPath("default://branch1@uf-playground"));
        RepositoryInfo repositoryInfo = new RepositoryInfo("test", false, this.getConfig());
        Repository repository = this.helper.newRepository(repositoryInfo);
        Assert.assertEquals((long)3L, (long)repository.getBranches().size());
        Assert.assertTrue((boolean)((Branch)repository.getDefaultBranch().get()).getPath().toURI().contains("master"));
    }

    @Test
    public void testCredentialsAreNotStoredAfterRepositoryCreation() {
        RepositoryInfo repositoryInfo = new RepositoryInfo("myRepository", false, this.getConfig());
        Repository repository = this.helper.newRepository(repositoryInfo);
        Assert.assertFalse((boolean)repository.getEnvironment().containsKey("username"));
        Assert.assertFalse((boolean)repository.getEnvironment().containsKey("password"));
        Assert.assertFalse((boolean)repository.getEnvironment().containsKey("secure:password"));
    }

    protected Path createPath(String uri) {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.toUri()).thenReturn((Object)URI.create(uri));
        Mockito.when((Object)path.getFileSystem()).thenReturn((Object)this.fileSystem);
        return path;
    }

    protected RepositoryConfiguration getConfig() {
        RepositoryConfiguration repositoryConfiguration = new RepositoryConfiguration();
        repositoryConfiguration.add("username", (Object)"user");
        repositoryConfiguration.add("password", (Object)"pw");
        repositoryConfiguration.add("secure:password", (Object)"pass");
        repositoryConfiguration.add("scheme", (Object)"git");
        repositoryConfiguration.add("space", (Object)"space");
        return repositoryConfiguration;
    }

    static enum Mode {
        INDEXED,
        NOT_INDEXED;

    }
}

