/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import java.util.Optional;
import org.guvnor.structure.backend.repositories.git.GitPathUtil;
import org.junit.Assert;
import org.junit.Test;

public class GitPathUtilTest {
    @Test
    public void extractPresentBranchName() throws Exception {
        Optional result = GitPathUtil.extractBranch((String)"git://master@space/repo/some/path");
        Assert.assertEquals(Optional.of("master"), (Object)result);
    }

    @Test
    public void extractBranchNameWithSlashes() throws Exception {
        Optional result = GitPathUtil.extractBranch((String)"git://my/master/branch@space/repo/some/path");
        Assert.assertEquals(Optional.of("my/master/branch"), (Object)result);
    }

    @Test
    public void extractMissingBranchName() throws Exception {
        Optional result = GitPathUtil.extractBranch((String)"git://space/repo/some/path");
        Assert.assertEquals(Optional.empty(), (Object)result);
    }

    @Test
    public void extractLocalBranchNameFromRef() throws Exception {
        Optional result = GitPathUtil.extractBranchFromRef((String)"refs/heads/master");
        Assert.assertEquals((Object)"master", result.get());
    }

    @Test
    public void extractLocalBranchNameWithSlashFromRef() throws Exception {
        Optional result = GitPathUtil.extractBranchFromRef((String)"refs/heads/my/branch");
        Assert.assertEquals((Object)"my/branch", result.get());
    }

    @Test
    public void extractRemoteBranchNameFromRef() throws Exception {
        Optional result = GitPathUtil.extractBranchFromRef((String)"refs/remotes/upstream/master");
        Assert.assertEquals((Object)"master", result.get());
    }

    @Test
    public void extractRemoteBranchNameWithSlashFromRef() throws Exception {
        Optional result = GitPathUtil.extractBranchFromRef((String)"refs/remotes/upstream/my/branch");
        Assert.assertEquals((Object)"my/branch", result.get());
    }
}

