/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit.config;

import java.util.function.Function;
import javax.enterprise.inject.Instance;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageRegistryImpl;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageBatch;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceConfigStorageRegistryImplTest {
    private static final String SPACE_NAME = "mySpace";
    @Mock
    private Instance<SpaceConfigStorage> spaceConfigStorages;
    private SpaceConfigStorageRegistryImpl spaceConfigStorageRegistry;
    @Mock
    private SpaceConfigStorage mySpaceConfigStorage;
    @Mock
    private SpaceConfigStorage otherSpaceConfigStorage;

    @Before
    public void setup() {
        this.spaceConfigStorageRegistry = new SpaceConfigStorageRegistryImpl(this.spaceConfigStorages);
    }

    @Test
    public void getTest() {
        ((Instance)Mockito.doReturn((Object)this.mySpaceConfigStorage).when(this.spaceConfigStorages)).get();
        SpaceConfigStorage spaceConfigStorage1 = this.spaceConfigStorageRegistry.get(SPACE_NAME);
        Assert.assertSame((Object)this.mySpaceConfigStorage, (Object)spaceConfigStorage1);
        SpaceConfigStorage spaceConfigStorage2 = this.spaceConfigStorageRegistry.get(SPACE_NAME);
        Assert.assertSame((Object)this.mySpaceConfigStorage, (Object)spaceConfigStorage2);
    }

    @Test
    public void getBatchTest() {
        ((Instance)Mockito.doReturn((Object)this.mySpaceConfigStorage).when(this.spaceConfigStorages)).get();
        SpaceInfo spaceInfo = (SpaceInfo)Mockito.mock(SpaceInfo.class);
        SpaceConfigStorageBatch batch = (SpaceConfigStorageBatch)Mockito.spy((Object)this.spaceConfigStorageRegistry.getBatch(SPACE_NAME));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> batch.run(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'function' should be not null!");
        Function<SpaceConfigStorageBatch.SpaceConfigStorageBatchContext, Void> function = context -> {
            context.saveSpaceInfo();
            return null;
        };
        batch.run(function);
        ((SpaceConfigStorage)Mockito.verify((Object)this.mySpaceConfigStorage)).saveSpaceInfo((SpaceInfo)ArgumentMatchers.any());
    }
}

