/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.backend.repositories.ConfiguredRepositoriesImpl;
import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.security.Contributor;
import org.uberfire.security.ContributorType;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfiguredRepositoriesTest {
    public static final Space SPACE1 = new Space("space1");
    public static final String REPO1S1 = "single";
    public static final String REPO2S1 = "multibranch";
    public static final Space SPACE2 = new Space("space2");
    public static final String REPO1S2 = "singles2";
    public static final String REPO2S2 = "multibranchs2";
    public static final String REPO3S2 = "multibranchs3";
    @Mock
    private RepositoryFactory repositoryFactory;
    private ConfiguredRepositories configuredRepositories;
    @Mock
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;

    @Before
    public void setUp() throws Exception {
        ArrayList<RepositoryInfo> repositoriesSpace1 = new ArrayList<RepositoryInfo>();
        repositoriesSpace1.add(this.addRepository(SPACE1, REPO1S1, this.createAdminContributors("admin1"), "main"));
        repositoriesSpace1.add(this.addRepository(SPACE1, REPO2S1, this.createAdminContributors("admin1"), "main", "dev", "release"));
        SpaceInfo space1 = new SpaceInfo(SPACE1.getName(), "Test Space", "com.space1", this.createAdminContributors("admin1"), repositoriesSpace1, Collections.emptyList());
        ArrayList<RepositoryInfo> repositoriesSpace2 = new ArrayList<RepositoryInfo>();
        repositoriesSpace2.add(this.addRepository(SPACE2, REPO1S2, Collections.emptyList(), "main"));
        repositoriesSpace2.add(this.addRepository(SPACE2, REPO2S2, Collections.emptyList(), "main", "dev", "release"));
        repositoriesSpace2.add(this.addRepository(SPACE2, REPO3S2, Collections.emptyList(), "main", "dev", "release"));
        SpaceInfo space2 = new SpaceInfo(SPACE2.getName(), "Test space", "com.space2", this.createAdminContributors("admin2"), repositoriesSpace2, Collections.emptyList());
        HashMap<String, SpaceInfo> spaces = new HashMap<String, SpaceInfo>();
        spaces.put(SPACE1.getName(), space1);
        spaces.put(SPACE2.getName(), space2);
        ((SpaceConfigStorageRegistry)Mockito.doAnswer(invocationOnMock -> {
            SpaceConfigStorage spaceConfigStorage = (SpaceConfigStorage)Mockito.mock(SpaceConfigStorage.class);
            String spaceName = (String)invocationOnMock.getArguments()[0];
            ((SpaceConfigStorage)Mockito.doReturn(spaces.get(spaceName)).when((Object)spaceConfigStorage)).loadSpaceInfo();
            return spaceConfigStorage;
        }).when((Object)this.spaceConfigStorageRegistry)).get((String)Mockito.any());
        this.configuredRepositories = new ConfiguredRepositoriesImpl(this.repositoryFactory, this.spaceConfigStorageRegistry);
    }

    private List<Contributor> createAdminContributors(String ... username) {
        ArrayList<Contributor> contributors = new ArrayList<Contributor>();
        for (int i = 0; i < username.length; ++i) {
            contributors.add(new Contributor(username[i], ContributorType.OWNER));
        }
        return contributors;
    }

    private RepositoryInfo addRepository(Space space, String alias, List<Contributor> contributors, String ... branches) {
        RepositoryConfiguration config = new RepositoryConfiguration();
        RepositoryInfo repositoryInfo = new RepositoryInfo(alias, false, config);
        config.add("contributors", contributors);
        GitRepository repository = new GitRepository(alias, space);
        HashMap<String, Branch> branchMap = new HashMap<String, Branch>();
        for (String branch : branches) {
            Path path = PathFactory.newPath((String)(alias + ".txt"), (String)("default://main@myteam/mortgages/" + alias + ".txt"));
            branchMap.put(branch, new Branch(branch, path));
        }
        repository.setBranches(branchMap);
        Mockito.when((Object)this.repositoryFactory.newRepository(repositoryInfo)).thenReturn((Object)repository);
        return repositoryInfo;
    }

    @Test
    public void testLoadRepositories() {
        Assert.assertEquals((long)2L, (long)this.configuredRepositories.getAllConfiguredRepositories(SPACE1).size());
        Assert.assertEquals((long)3L, (long)this.configuredRepositories.getAllConfiguredRepositories(SPACE2).size());
    }

    @Test
    public void testLoadSingle() {
        Repository single = this.configuredRepositories.getRepositoryByRepositoryAlias(SPACE1, REPO1S1);
        Assert.assertEquals((long)1L, (long)single.getBranches().size());
        Assert.assertNotNull((Object)single.getBranch("main"));
    }

    @Test
    public void testLoadMultiBranch() {
        Repository single = this.configuredRepositories.getRepositoryByRepositoryAlias(SPACE1, REPO2S1);
        Assert.assertEquals((long)3L, (long)single.getBranches().size());
        Assert.assertNotNull((Object)single.getBranch("main"));
        Assert.assertNotNull((Object)single.getBranch("dev"));
        Assert.assertNotNull((Object)single.getBranch("release"));
    }
}

