/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.guvnor.structure.backend.organizationalunit.OrganizationalUnitFactoryImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.PasswordService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.security.Contributor;
import org.uberfire.security.ContributorType;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@RunWith(value=MockitoJUnitRunner.class)
public class OrganizationalUnitFactoryImplTest {
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private SpacesAPI spacesAPI;
    @Mock
    private PasswordService secureService;
    private OrganizationalUnitFactoryImpl factory;

    @Before
    public void setup() {
        ((RepositoryService)Mockito.doAnswer(invocationOnMock -> {
            Repository repository = (Repository)Mockito.mock(Repository.class);
            ((Repository)Mockito.doReturn((Object)invocationOnMock.getArgument(1, String.class)).when((Object)repository)).getAlias();
            return repository;
        }).when((Object)this.repositoryService)).getRepositoryFromSpace((Space)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.factory = (OrganizationalUnitFactoryImpl)Mockito.spy((Object)new OrganizationalUnitFactoryImpl(this.repositoryService, this.spacesAPI));
    }

    @Test
    public void newOrganizationalUnitTest() {
        List<Contributor> contributors = Arrays.asList(new Contributor("c1", ContributorType.OWNER), new Contributor("c2", ContributorType.ADMIN));
        SpaceInfo spaceInfo = new SpaceInfo("ou", "test space", "groupId", contributors, Collections.singletonList(new RepositoryInfo("repo1", false, new RepositoryConfiguration())), Collections.singletonList("group1"));
        OrganizationalUnit organizationalUnit = this.factory.newOrganizationalUnit(spaceInfo);
        Assert.assertEquals((Object)"ou", (Object)organizationalUnit.getName());
        Assert.assertEquals((Object)"groupId", (Object)organizationalUnit.getDefaultGroupId());
        Assert.assertEquals((Object)"test space", (Object)organizationalUnit.getDescription());
        Assert.assertEquals((long)1L, (long)organizationalUnit.getRepositories().size());
        Assert.assertEquals((Object)"repo1", (Object)((Repository)((List)organizationalUnit.getRepositories()).get(0)).getAlias());
        Assert.assertEquals((long)1L, (long)organizationalUnit.getGroups().size());
        Assert.assertEquals((Object)"group1", ((List)organizationalUnit.getGroups()).get(0));
        Assert.assertEquals((long)2L, (long)organizationalUnit.getContributors().size());
        Assert.assertEquals((Object)"c1", (Object)((Contributor)((List)organizationalUnit.getContributors()).get(0)).getUsername());
        Assert.assertEquals((Object)ContributorType.OWNER, (Object)((Contributor)((List)organizationalUnit.getContributors()).get(0)).getType());
        Assert.assertEquals((Object)"c2", (Object)((Contributor)((List)organizationalUnit.getContributors()).get(1)).getUsername());
        Assert.assertEquals((Object)ContributorType.ADMIN, (Object)((Contributor)((List)organizationalUnit.getContributors()).get(1)).getType());
    }
}

