/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.Repository;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigCleanUp;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.FileSystemLock;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.util.Git;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceConfigCleanUpTest {
    private SpaceConfigCleanUp spaceConfigCleanUp;
    @Mock
    private OrganizationalUnitService orgUnitService;
    @Mock
    private SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    @Mock
    private Git git;

    @Before
    public void setup() throws IOException {
        this.spaceConfigCleanUp = (SpaceConfigCleanUp)Mockito.spy((Object)new SpaceConfigCleanUp(this.orgUnitService, this.spaceConfigStorageRegistry));
        ((SpaceConfigCleanUp)Mockito.doReturn((Object)true).when((Object)this.spaceConfigCleanUp)).isGitDefaultFileSystem();
        ((SpaceConfigCleanUp)Mockito.doReturn((Object)Mockito.mock(FileSystemLock.class)).when((Object)this.spaceConfigCleanUp)).createLock((File)ArgumentMatchers.any(File.class));
    }

    @Test
    public void cleanUpSpaceConfigStorageWhenAlreadyDoneTest() throws IOException {
        SpaceConfigStorageImpl spaceConfigStorage = this.setupConfigStorage();
        this.setupMarker(true);
        this.spaceConfigCleanUp.postConstruct();
        ((SpaceConfigStorageImpl)Mockito.verify((Object)spaceConfigStorage, (VerificationMode)Mockito.never())).loadSpaceInfo();
        ((SpaceConfigStorageImpl)Mockito.verify((Object)spaceConfigStorage, (VerificationMode)Mockito.never())).saveSpaceInfo((SpaceInfo)ArgumentMatchers.any());
        ((Git)Mockito.verify((Object)this.git, (VerificationMode)Mockito.never())).resetWithSquash(ArgumentMatchers.anyString());
    }

    @Test
    public void cleanUpSpaceConfigStorageWhenUpdateNotNeededTest() throws IOException {
        SpaceConfigStorageImpl spaceConfigStorage = this.setupConfigStorage();
        this.setupMarker(false);
        SpaceInfo spaceInfo = (SpaceInfo)Mockito.mock(SpaceInfo.class);
        ((SpaceConfigStorageImpl)Mockito.doReturn((Object)spaceInfo).when((Object)spaceConfigStorage)).loadSpaceInfo();
        RepositoryInfo repositoryInfo = this.setupRepositoryInfo(this.createEnvMap(false));
        ((SpaceInfo)Mockito.doReturn(Collections.nCopies(5, repositoryInfo)).when((Object)spaceInfo)).getRepositories();
        this.spaceConfigCleanUp.postConstruct();
        ((SpaceConfigStorageImpl)Mockito.verify((Object)spaceConfigStorage, (VerificationMode)Mockito.never())).saveSpaceInfo((SpaceInfo)ArgumentMatchers.any());
        ((Git)Mockito.verify((Object)this.git, (VerificationMode)Mockito.never())).resetWithSquash(ArgumentMatchers.anyString());
    }

    @Test
    public void cleanUpSpaceConfigStorageWhenUpdateNeededTest() throws IOException {
        SpaceConfigStorageImpl spaceConfigStorage = this.setupConfigStorage();
        this.setupMarker(false);
        SpaceInfo spaceInfo = (SpaceInfo)Mockito.mock(SpaceInfo.class);
        ((SpaceConfigStorageImpl)Mockito.doReturn((Object)spaceInfo).when((Object)spaceConfigStorage)).loadSpaceInfo();
        RepositoryInfo repositoryInfo = this.setupRepositoryInfo(this.createEnvMap(true));
        ((SpaceInfo)Mockito.doReturn(Collections.nCopies(5, repositoryInfo)).when((Object)spaceInfo)).getRepositories();
        this.spaceConfigCleanUp.postConstruct();
        ((SpaceConfigStorageImpl)Mockito.verify((Object)spaceConfigStorage)).saveSpaceInfo((SpaceInfo)ArgumentMatchers.any());
        ((Git)Mockito.verify((Object)this.git)).resetWithSquash(ArgumentMatchers.anyString());
    }

    @Test
    public void cleanUpSpaceConfigStorageWhenUpdatePartiallyNeededTest() throws IOException {
        SpaceConfigStorageImpl spaceConfigStorage = this.setupConfigStorage();
        this.setupMarker(false);
        SpaceInfo spaceInfo = (SpaceInfo)Mockito.mock(SpaceInfo.class);
        ((SpaceConfigStorageImpl)Mockito.doReturn((Object)spaceInfo).when((Object)spaceConfigStorage)).loadSpaceInfo();
        ArrayList<RepositoryInfo> repositoryInfos = new ArrayList<RepositoryInfo>();
        repositoryInfos.addAll(Collections.nCopies(3, this.setupRepositoryInfo(this.createEnvMap(true))));
        repositoryInfos.addAll(Collections.nCopies(3, this.setupRepositoryInfo(this.createEnvMap(false))));
        ((SpaceInfo)Mockito.doReturn(repositoryInfos).when((Object)spaceInfo)).getRepositories();
        this.spaceConfigCleanUp.postConstruct();
        ((SpaceConfigStorageImpl)Mockito.verify((Object)spaceConfigStorage)).saveSpaceInfo((SpaceInfo)ArgumentMatchers.any());
        ((Git)Mockito.verify((Object)this.git)).resetWithSquash(ArgumentMatchers.anyString());
    }

    private SpaceConfigStorageImpl setupConfigStorage() {
        String spaceName = "MySpace";
        OrganizationalUnit orgUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        ((OrganizationalUnit)Mockito.doReturn((Object)"MySpace").when((Object)orgUnit)).getName();
        ((OrganizationalUnitService)Mockito.doReturn(Collections.singletonList(orgUnit)).when((Object)this.orgUnitService)).getAllOrganizationalUnits();
        SpaceConfigStorageImpl spaceConfigStorage = (SpaceConfigStorageImpl)Mockito.mock(SpaceConfigStorageImpl.class);
        Path path = (Path)Mockito.mock(Path.class);
        JGitFileSystem fs = (JGitFileSystem)Mockito.mock(JGitFileSystem.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        File directory = (File)Mockito.mock(File.class);
        ((File)Mockito.doReturn((Object)directory).when((Object)directory)).getParentFile();
        ((Repository)Mockito.doReturn((Object)directory).when((Object)repository)).getDirectory();
        ((Git)Mockito.doReturn((Object)repository).when((Object)this.git)).getRepository();
        ((JGitFileSystem)Mockito.doReturn((Object)this.git).when((Object)fs)).getGit();
        ((Path)Mockito.doReturn((Object)fs).when((Object)path)).getFileSystem();
        ((SpaceConfigStorageImpl)Mockito.doReturn((Object)path).when((Object)spaceConfigStorage)).getPath();
        ((SpaceConfigStorageRegistry)Mockito.doReturn((Object)spaceConfigStorage).when((Object)this.spaceConfigStorageRegistry)).get("MySpace");
        return spaceConfigStorage;
    }

    private RepositoryInfo setupRepositoryInfo(Map<String, Object> envMap) {
        RepositoryInfo repositoryInfo = (RepositoryInfo)Mockito.mock(RepositoryInfo.class);
        RepositoryConfiguration configuration = (RepositoryConfiguration)Mockito.mock(RepositoryConfiguration.class);
        ((RepositoryConfiguration)Mockito.doReturn(envMap).when((Object)configuration)).getEnvironment();
        ((RepositoryInfo)Mockito.doReturn((Object)configuration).when((Object)repositoryInfo)).getConfiguration();
        return repositoryInfo;
    }

    private void setupMarker(boolean exists) {
        File marker = (File)Mockito.mock(File.class);
        ((File)Mockito.doReturn((Object)exists).when((Object)marker)).exists();
        ((SpaceConfigCleanUp)Mockito.doReturn((Object)marker).when((Object)this.spaceConfigCleanUp)).createMarker((File)ArgumentMatchers.any(File.class));
    }

    private Map<String, Object> createEnvMap(boolean includeCredentials) {
        HashMap<String, Object> envMap = new HashMap<String, Object>();
        envMap.put("foo", true);
        envMap.put("bar", 1);
        if (includeCredentials) {
            envMap.put("username", "user");
            envMap.put("password", "pw");
            envMap.put("secure:password", "spw");
        }
        return envMap;
    }
}

