/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.util.Arrays;
import java.util.Collection;
import org.guvnor.structure.backend.organizationalunit.OrganizationalUnitSearchServiceImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class OrganizationalUnitSearchServiceTest {
    @Mock
    OrganizationalUnitService resourceService;
    @Mock
    OrganizationalUnit itemA;
    @Mock
    OrganizationalUnit itemB;
    private OrganizationalUnitSearchServiceImpl searchService;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.itemA.getIdentifier()).thenReturn((Object)"itemA");
        Mockito.when((Object)this.itemB.getIdentifier()).thenReturn((Object)"itemB");
        Mockito.when((Object)this.itemA.getName()).thenReturn((Object)"Item A");
        Mockito.when((Object)this.itemB.getName()).thenReturn((Object)"Item B");
        Mockito.when((Object)this.resourceService.getAllOrganizationalUnits()).thenReturn(Arrays.asList(this.itemA, this.itemB));
        this.searchService = new OrganizationalUnitSearchServiceImpl(this.resourceService);
    }

    @Test
    public void testSearchById() throws Exception {
        Collection result = this.searchService.searchById(Arrays.asList("itemA"));
        Assert.assertEquals((long)result.size(), (long)1L);
        Assert.assertEquals((Object)((OrganizationalUnit)result.iterator().next()).getName(), (Object)"Item A");
    }

    @Test
    public void testSearchByAlias() throws Exception {
        Collection result = this.searchService.searchByName("Item", 10, true);
        Assert.assertEquals((long)result.size(), (long)2L);
    }

    @Test
    public void testSearchCaseSensitiveEmpty() throws Exception {
        Collection result = this.searchService.searchByName("item", 10, true);
        Assert.assertEquals((long)result.size(), (long)0L);
    }

    @Test
    public void testSearchCaseUnsensitive() throws Exception {
        Collection result = this.searchService.searchByName("item", 10, false);
        Assert.assertEquals((long)result.size(), (long)2L);
    }

    @Test
    public void testSearchMaxItems() throws Exception {
        Collection result = this.searchService.searchByName("item", 1, false);
        Assert.assertEquals((long)result.size(), (long)1L);
    }
}

