/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageImpl;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequest;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestComment;
import org.jboss.errai.marshalling.client.api.exceptions.MarshallingException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.server.io.object.ObjectStorage;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.mocks.FileSystemTestingUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceConfigStorageImplTest {
    private static final String PATH_PREFIX = "git://amend-repo-test/";
    @Mock
    private ObjectStorage objectStorage;
    private IOService ioService;
    private SpaceConfigStorageImpl spaceConfigStorage;
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();

    @Before
    public void setup() throws Exception {
        fileSystemTestingUtils.setup();
        this.ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        this.spaceConfigStorage = (SpaceConfigStorageImpl)Mockito.spy((Object)new SpaceConfigStorageImpl(this.objectStorage, this.ioService));
    }

    @After
    public void cleanupFileSystem() {
        fileSystemTestingUtils.cleanup();
    }

    @Test
    public void loadCustomBranchPermissionsTest() {
        BranchPermissions customBranchPermissions = (BranchPermissions)Mockito.mock(BranchPermissions.class);
        ((ObjectStorage)Mockito.doReturn((Object)customBranchPermissions).when((Object)this.objectStorage)).read("/config/myProject/myBranch/BranchPermissions.json");
        BranchPermissions branchPermissions = this.spaceConfigStorage.loadBranchPermissions("myBranch", "myProject");
        Assert.assertSame((Object)customBranchPermissions, (Object)branchPermissions);
    }

    @Test
    public void loadDefaultBranchPermissionsTest() {
        BranchPermissions defaultBranchPermissions = (BranchPermissions)Mockito.mock(BranchPermissions.class);
        ((SpaceConfigStorageImpl)Mockito.doReturn((Object)defaultBranchPermissions).when((Object)this.spaceConfigStorage)).getDefaultBranchPermissions("myBranch");
        BranchPermissions branchPermissions = this.spaceConfigStorage.loadBranchPermissions("myBranch", "myProject");
        Assert.assertSame((Object)defaultBranchPermissions, (Object)branchPermissions);
    }

    @Test
    public void saveBranchPermissionsTest() {
        BranchPermissions customBranchPermissions = (BranchPermissions)Mockito.mock(BranchPermissions.class);
        this.spaceConfigStorage.saveBranchPermissions("myBranch", "myProject", customBranchPermissions);
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).write((String)Mockito.eq((Object)"/config/myProject/myBranch/BranchPermissions.json"), (Object)((BranchPermissions)Mockito.same((Object)customBranchPermissions)));
    }

    @Test
    public void deleteBranchPermissionsTest() {
        this.spaceConfigStorage.deleteBranchPermissions("myBranch", "myProject");
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/config/myProject/myBranch/BranchPermissions.json"));
    }

    @Test
    public void loadChangeRequestsTest() {
        ArrayList<Long> ids = new ArrayList<Long>(){
            {
                this.add(1L);
                this.add(2L);
            }
        };
        ChangeRequest expectedChangeRequest0 = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ChangeRequest expectedChangeRequest1 = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((SpaceConfigStorageImpl)Mockito.doReturn((Object)ids).when((Object)this.spaceConfigStorage)).getChangeRequestIds("MyProject");
        ((ObjectStorage)Mockito.doReturn((Object)expectedChangeRequest0).when((Object)this.objectStorage)).read("/MyProject/change_requests/1/information.cr");
        ((ObjectStorage)Mockito.doReturn((Object)expectedChangeRequest1).when((Object)this.objectStorage)).read("/MyProject/change_requests/2/information.cr");
        List changeRequests = this.spaceConfigStorage.loadChangeRequests("MyProject");
        Assert.assertSame((Object)expectedChangeRequest0, changeRequests.get(0));
        Assert.assertSame((Object)expectedChangeRequest1, changeRequests.get(1));
    }

    @Test
    public void loadChangeRequestTest() {
        ChangeRequest expectedChangeRequest = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ObjectStorage)Mockito.doReturn((Object)expectedChangeRequest).when((Object)this.objectStorage)).read("/MyProject/change_requests/1/information.cr");
        ChangeRequest changeRequest = this.spaceConfigStorage.loadChangeRequest("MyProject", Long.valueOf(1L));
        Assert.assertSame((Object)expectedChangeRequest, (Object)changeRequest);
    }

    @Test
    public void saveChangeRequestTest() {
        ChangeRequest changeRequest = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)1L).when((Object)changeRequest)).getId();
        this.spaceConfigStorage.saveChangeRequest("MyProject", changeRequest);
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).write((String)Mockito.eq((Object)"/MyProject/change_requests/1/information.cr"), (Object)((ChangeRequest)Mockito.same((Object)changeRequest)));
    }

    @Test
    public void deleteAllChangeRequestsTest() {
        Path crsPath = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests"));
        Path commentsPath = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/2/comments"));
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/information.cr")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/2/information.cr")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/2/comments/1.comment")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/2/comments/2.comment")), new FileAttribute[0]);
        ((ObjectStorage)Mockito.doReturn((Object)true).when((Object)this.objectStorage)).exists("/MyProject/change_requests");
        ((ObjectStorage)Mockito.doReturn((Object)true).when((Object)this.objectStorage)).exists("/MyProject/change_requests/2/comments");
        ((ObjectStorage)Mockito.doReturn((Object)crsPath).when((Object)this.objectStorage)).getPath("/MyProject/change_requests", new String[0]);
        ((ObjectStorage)Mockito.doReturn((Object)commentsPath).when((Object)this.objectStorage)).getPath("/MyProject/change_requests/2/comments", new String[0]);
        this.spaceConfigStorage.deleteAllChangeRequests("MyProject");
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/MyProject/change_requests/2/comments/1.comment"));
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/MyProject/change_requests/2/comments/2.comment"));
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/MyProject/change_requests/1/information.cr"));
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/MyProject/change_requests/2/information.cr"));
    }

    @Test
    public void deleteChangeRequestTest() {
        this.spaceConfigStorage.deleteChangeRequest("MyProject", Long.valueOf(1L));
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/MyProject/change_requests/1/information.cr"));
    }

    @Test
    public void deleteRepositoryTest() {
        Path crsPath = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests"));
        Path commentsPath = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/2/comments"));
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/information.cr")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/2/information.cr")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/2/comments/1.comment")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/2/comments/2.comment")), new FileAttribute[0]);
        ((ObjectStorage)Mockito.doReturn((Object)true).when((Object)this.objectStorage)).exists("/MyProject/change_requests");
        ((ObjectStorage)Mockito.doReturn((Object)true).when((Object)this.objectStorage)).exists("/MyProject/change_requests/2/comments");
        ((ObjectStorage)Mockito.doReturn((Object)crsPath).when((Object)this.objectStorage)).getPath("/MyProject/change_requests", new String[0]);
        ((ObjectStorage)Mockito.doReturn((Object)commentsPath).when((Object)this.objectStorage)).getPath("/MyProject/change_requests/2/comments", new String[0]);
        this.spaceConfigStorage.deleteRepository("MyProject");
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/MyProject/change_requests/2/comments/1.comment"));
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/MyProject/change_requests/2/comments/2.comment"));
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/MyProject/change_requests/1/information.cr"));
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/MyProject/change_requests/2/information.cr"));
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/MyProject"));
    }

    @Test
    public void getChangeRequestIdsTest() {
        Path crsPath = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests"));
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/information.cr")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/2/information.cr")), new FileAttribute[0]);
        ((ObjectStorage)Mockito.doReturn((Object)true).when((Object)this.objectStorage)).exists("/MyProject/change_requests");
        ((ObjectStorage)Mockito.doReturn((Object)crsPath).when((Object)this.objectStorage)).getPath("/MyProject/change_requests", new String[0]);
        List ids = this.spaceConfigStorage.getChangeRequestIds("MyProject");
        Assert.assertSame((Object)1L, ids.get(0));
        Assert.assertSame((Object)2L, ids.get(1));
    }

    @Test
    public void getChangeRequestIdsSkipInvalidIdsTest() {
        Path crsPath = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests"));
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/invalid-id/information.cr")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/information.cr")), new FileAttribute[0]);
        ((ObjectStorage)Mockito.doReturn((Object)true).when((Object)this.objectStorage)).exists("/MyProject/change_requests");
        ((ObjectStorage)Mockito.doReturn((Object)crsPath).when((Object)this.objectStorage)).getPath("/MyProject/change_requests", new String[0]);
        List ids = this.spaceConfigStorage.getChangeRequestIds("MyProject");
        Assert.assertSame((Object)1, (Object)ids.size());
        Assert.assertSame((Object)1L, ids.get(0));
    }

    @Test
    public void getChangeRequestIdsNoResultsTest() {
        Path crsPath = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests"));
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/information.cr")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/2/information.cr")), new FileAttribute[0]);
        List ids = this.spaceConfigStorage.getChangeRequestIds("MyOtherProject");
        Assert.assertSame((Object)0, (Object)ids.size());
    }

    @Test
    public void loadChangeRequestCommentsTest() {
        ArrayList<Long> ids = new ArrayList<Long>(){
            {
                this.add(1L);
                this.add(2L);
            }
        };
        ChangeRequestComment expectedChangeRequestComment0 = (ChangeRequestComment)Mockito.mock(ChangeRequestComment.class);
        ChangeRequestComment expectedChangeRequestComment1 = (ChangeRequestComment)Mockito.mock(ChangeRequestComment.class);
        ((SpaceConfigStorageImpl)Mockito.doReturn((Object)ids).when((Object)this.spaceConfigStorage)).getChangeRequestCommentIds("MyProject", Long.valueOf(1L));
        ((ObjectStorage)Mockito.doReturn((Object)expectedChangeRequestComment0).when((Object)this.objectStorage)).read("/MyProject/change_requests/1/comments/1.comment");
        ((ObjectStorage)Mockito.doReturn((Object)expectedChangeRequestComment1).when((Object)this.objectStorage)).read("/MyProject/change_requests/1/comments/2.comment");
        List comments = this.spaceConfigStorage.loadChangeRequestComments("MyProject", Long.valueOf(1L));
        Assert.assertSame((Object)expectedChangeRequestComment0, comments.get(0));
        Assert.assertSame((Object)expectedChangeRequestComment1, comments.get(1));
    }

    @Test
    public void loadChangeRequestCommentTest() {
        ChangeRequestComment expectedChangeRequestComment = (ChangeRequestComment)Mockito.mock(ChangeRequestComment.class);
        ((ObjectStorage)Mockito.doReturn((Object)expectedChangeRequestComment).when((Object)this.objectStorage)).read("/MyProject/change_requests/1/comments/1.comment");
        ChangeRequestComment changeRequestComment = this.spaceConfigStorage.loadChangeRequestComment("MyProject", Long.valueOf(1L), Long.valueOf(1L));
        Assert.assertSame((Object)expectedChangeRequestComment, (Object)changeRequestComment);
    }

    @Test
    public void saveChangeRequestCommentTest() {
        ChangeRequestComment changeRequestComment = (ChangeRequestComment)Mockito.mock(ChangeRequestComment.class);
        ((ChangeRequestComment)Mockito.doReturn((Object)1L).when((Object)changeRequestComment)).getId();
        this.spaceConfigStorage.saveChangeRequestComment("MyProject", Long.valueOf(1L), changeRequestComment);
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).write((String)Mockito.eq((Object)"/MyProject/change_requests/1/comments/1.comment"), (Object)((ChangeRequestComment)Mockito.same((Object)changeRequestComment)));
    }

    @Test
    public void deleteAllChangeRequestCommentsTest() {
        Path commentsPath = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments"));
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/1.comment")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/2.comment")), new FileAttribute[0]);
        ((ObjectStorage)Mockito.doReturn((Object)true).when((Object)this.objectStorage)).exists("/MyProject/change_requests/1/comments");
        ((ObjectStorage)Mockito.doReturn((Object)commentsPath).when((Object)this.objectStorage)).getPath("/MyProject/change_requests/1/comments", new String[0]);
        this.spaceConfigStorage.deleteAllChangeRequestComments("MyProject", Long.valueOf(1L));
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/MyProject/change_requests/1/comments/1.comment"));
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/MyProject/change_requests/1/comments/2.comment"));
    }

    @Test
    public void deleteChangeRequestCommentTest() {
        this.spaceConfigStorage.deleteChangeRequestComment("MyProject", Long.valueOf(1L), Long.valueOf(1L));
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).delete((String)Mockito.eq((Object)"/MyProject/change_requests/1/comments/1.comment"));
    }

    @Test
    public void getChangeRequestCommentIdsTest() {
        Path commentsPath = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments"));
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/1.comment")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/20.comment")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/30.comment")), new FileAttribute[0]);
        ((ObjectStorage)Mockito.doReturn((Object)true).when((Object)this.objectStorage)).exists("/MyProject/change_requests/1/comments");
        ((ObjectStorage)Mockito.doReturn((Object)commentsPath).when((Object)this.objectStorage)).getPath("/MyProject/change_requests/1/comments", new String[0]);
        List ids = this.spaceConfigStorage.getChangeRequestCommentIds("MyProject", Long.valueOf(1L));
        Assert.assertSame((Object)1L, ids.get(0));
        Assert.assertSame((Object)20L, ids.get(1));
        Assert.assertSame((Object)30L, ids.get(2));
    }

    @Test
    public void getChangeRequestCommentIdsSkipInvalidIdsTest() {
        Path commentsPath = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments"));
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/1.comment")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/20.comment")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/invalid-id.comment")), new FileAttribute[0]);
        ((ObjectStorage)Mockito.doReturn((Object)true).when((Object)this.objectStorage)).exists("/MyProject/change_requests/1/comments");
        ((ObjectStorage)Mockito.doReturn((Object)commentsPath).when((Object)this.objectStorage)).getPath("/MyProject/change_requests/1/comments", new String[0]);
        List ids = this.spaceConfigStorage.getChangeRequestCommentIds("MyProject", Long.valueOf(1L));
        Assert.assertSame((Object)2, (Object)ids.size());
        Assert.assertSame((Object)1L, ids.get(0));
        Assert.assertSame((Object)20L, ids.get(1));
    }

    @Test
    public void getChangeRequestCommentIdsNoResultsOtherChangeRequestTest() {
        Path commentsPath = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments"));
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/1.comment")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/20.comment")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/30.comment")), new FileAttribute[0]);
        List ids = this.spaceConfigStorage.getChangeRequestCommentIds("MyProject", Long.valueOf(2L));
        Assert.assertSame((Object)0, (Object)ids.size());
    }

    @Test
    public void getChangeRequestCommentIdsNoResultsOtherProjectTest() {
        Path commentsPath = fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments"));
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/1.comment")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/20.comment")), new FileAttribute[0]);
        fileSystemTestingUtils.getIoService().createFile(fileSystemTestingUtils.getIoService().get(URI.create("git://amend-repo-test/MyProject/change_requests/1/comments/30.comment")), new FileAttribute[0]);
        List ids = this.spaceConfigStorage.getChangeRequestCommentIds("MyOtherProject", Long.valueOf(1L));
        Assert.assertSame((Object)0, (Object)ids.size());
    }

    @Test
    public void testLoadSpaceInfo() {
        SpaceInfo spaceInfo = (SpaceInfo)Mockito.mock(SpaceInfo.class);
        String path = "src/test/resources/dummyOverride/FixedSpaceInfo.json";
        ((ObjectStorage)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException((Throwable)new MarshallingException())}).doReturn((Object)spaceInfo).when((Object)this.objectStorage)).read(ArgumentMatchers.anyString());
        Mockito.when((Object)this.objectStorage.exists(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.objectStorage.getPath((String)ArgumentMatchers.any(), new String[0])).thenReturn((Object)Paths.get((String)path, (String[])new String[0]));
        Mockito.when((Object)this.spaceConfigStorage.buildSpaceConfigFilePath(ArgumentMatchers.anyString())).thenReturn((Object)path);
        SpaceInfo si = this.spaceConfigStorage.loadSpaceInfo();
        ((ObjectStorage)Mockito.verify((Object)this.objectStorage)).exists((String)Mockito.eq((Object)path));
        Assert.assertEquals((Object)si, (Object)spaceInfo);
    }
}

