/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.clone;

import java.util.ArrayList;
import java.util.HashSet;
import org.guvnor.structure.client.editors.repository.RepositoryPreferences;
import org.guvnor.structure.client.editors.repository.clone.CloneRepositoryPresenter;
import org.guvnor.structure.client.editors.repository.clone.CloneRepositoryView;
import org.guvnor.structure.client.editors.repository.clone.answer.OuServiceAnswer;
import org.guvnor.structure.client.editors.repository.clone.answer.RsCreateRepositoryAnswer;
import org.guvnor.structure.client.editors.repository.clone.answer.RsCreateRepositoryFailAnswer;
import org.guvnor.structure.client.editors.repository.clone.answer.RsNormalizedNameAnswer;
import org.guvnor.structure.events.AfterCreateOrganizationalUnitEvent;
import org.guvnor.structure.events.AfterDeleteOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryAlreadyExistsException;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;

@RunWith(value=MockitoJUnitRunner.class)
public class CloneMavenRepositoryPresenterTest {
    private static final String ORG_UNIT_ONE = "OrganizationalUnitOne";
    private static final String ORG_UNIT_TWO = "OrganizationalUnitTwo";
    private static final String REPO_NAME = "GitRepositoryName";
    private static final String REPO_URL = "/home/user/git/url";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    @Mock
    private Message message;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private RepositoryPreferences repositoryPreferences;
    @Mock
    private CloneRepositoryView view;
    @Mock
    private Caller<RepositoryService> repoServiceCaller;
    @Mock
    private Caller<RepositoryService> repoFailServiceCaller;
    @Mock
    private Caller<OrganizationalUnitService> ouServiceCaller;
    @Mock
    private OrganizationalUnitService ouService;
    @Mock
    private RepositoryService repoService;
    @Mock
    private OrganizationalUnit ouUnit1;
    @Mock
    private OrganizationalUnit ouUnit2;
    @Mock
    private Repository repository;
    @Captor
    private ArgumentCaptor<Boolean> boolArgument;
    @Captor
    private ArgumentCaptor<Throwable> throwableArgument;
    @Captor
    private ArgumentCaptor<RepositoryEnvironmentConfigurations> repositoryEnvironmentConfigurationsArgumentCaptor;
    private CloneRepositoryPresenter presenter;

    @Before
    public void initPresenter() {
        HashSet<RoleImpl> userRoles = new HashSet<RoleImpl>();
        userRoles.add(new RoleImpl("mock-role"));
        ArrayList<OrganizationalUnit> units = new ArrayList<OrganizationalUnit>();
        units.add(this.ouUnit1);
        units.add(this.ouUnit2);
        Mockito.when((Object)this.ouUnit1.getName()).thenReturn((Object)ORG_UNIT_ONE);
        Mockito.when((Object)this.ouUnit2.getName()).thenReturn((Object)ORG_UNIT_TWO);
        Mockito.when((Object)this.view.isNameEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getName()).thenReturn((Object)REPO_NAME);
        Mockito.when((Object)this.view.getSelectedOrganizationalUnit()).thenReturn((Object)ORG_UNIT_ONE);
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)USERNAME);
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)PASSWORD);
        Mockito.when((Object)this.ouServiceCaller.call((RemoteCallback)Matchers.any(RemoteCallback.class), (ErrorCallback)Matchers.any(ErrorCallback.class))).thenAnswer((Answer)new OuServiceAnswer(units, this.ouService));
        Mockito.when((Object)this.repoServiceCaller.call((RemoteCallback)Matchers.any(RemoteCallback.class))).thenAnswer((Answer)new RsNormalizedNameAnswer(REPO_NAME, this.repoService));
        Mockito.when((Object)this.repoServiceCaller.call((RemoteCallback)Matchers.any(RemoteCallback.class), (ErrorCallback)Matchers.any(ErrorCallback.class))).thenAnswer((Answer)new RsCreateRepositoryAnswer(this.repository, this.repoService));
        Mockito.when((Object)this.repoFailServiceCaller.call((RemoteCallback)Matchers.any(RemoteCallback.class))).thenAnswer((Answer)new RsNormalizedNameAnswer(REPO_NAME, this.repoService));
        Mockito.when((Object)this.repositoryPreferences.isOUMandatory()).thenReturn((Object)false);
        this.presenter = new CloneRepositoryPresenter(this.repositoryPreferences, this.view, this.repoServiceCaller, this.ouServiceCaller, this.placeManager);
        this.presenter.init();
    }

    @Test
    public void testComponentsStaysOperational() {
        Mockito.when((Object)this.view.isGitUrlEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)REPO_URL);
        this.presenter.handleCloneClick();
        this.componentsLocked();
        this.verifyRepoCloned(true);
    }

    @Test
    public void testComponentsNonLockEmptyUrl() {
        Mockito.when((Object)this.view.isGitUrlEmpty()).thenReturn((Object)true);
        this.presenter.handleCloneClick();
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).showUrlHelpMandatoryMessage();
        this.componentsNotAffected();
        this.verifyRepoCloned(false);
    }

    @Test
    public void testComponentsNonLockInvalidUrl() {
        Mockito.when((Object)this.view.isGitUrlEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)"git repo");
        this.presenter.handleCloneClick();
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).showUrlHelpInvalidFormatMessage();
        this.componentsNotAffected();
        this.verifyRepoCloned(false);
    }

    @Test
    public void testComponentsNonLockOuMandatory() {
        Mockito.when((Object)this.view.isGitUrlEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)REPO_URL);
        Mockito.when((Object)this.view.getSelectedOrganizationalUnit()).thenReturn((Object)"non_existing");
        Mockito.when((Object)this.repositoryPreferences.isOUMandatory()).thenReturn((Object)true);
        this.presenter.handleCloneClick();
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).showOrganizationalUnitHelpMandatoryMessage();
        this.componentsNotAffected();
        this.verifyRepoCloned(false);
    }

    @Test
    public void testComponentsNonLockEmptyName() {
        Mockito.when((Object)this.view.isGitUrlEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)REPO_URL);
        Mockito.when((Object)this.view.isNameEmpty()).thenReturn((Object)true);
        this.presenter.handleCloneClick();
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).showNameHelpMandatoryMessage();
        this.componentsNotAffected();
        this.verifyRepoCloned(false);
    }

    @Test
    public void testAlreadyExistClone() {
        Mockito.when((Object)this.repoFailServiceCaller.call((RemoteCallback)Matchers.any(RemoteCallback.class), (ErrorCallback)Matchers.any(ErrorCallback.class))).thenAnswer((Answer)new RsCreateRepositoryFailAnswer(this.message, (Throwable)new RepositoryAlreadyExistsException(), this.repository, this.repoService));
        this.presenter = new CloneRepositoryPresenter(this.repositoryPreferences, this.view, this.repoFailServiceCaller, this.ouServiceCaller, this.placeManager);
        this.presenter.init();
        Mockito.when((Object)this.view.isGitUrlEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)REPO_URL);
        this.presenter.handleCloneClick();
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).errorRepositoryAlreadyExist();
        this.componentsLocked();
        this.componentsUnlocked();
        this.verifyRepoCloned(false);
    }

    @Test
    public void testFailClone() {
        Mockito.when((Object)this.view.isGitUrlEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)REPO_URL);
        RuntimeException exc = new RuntimeException();
        Mockito.when((Object)this.repoFailServiceCaller.call((RemoteCallback)Matchers.any(RemoteCallback.class), (ErrorCallback)Matchers.any(ErrorCallback.class))).thenAnswer((Answer)new RsCreateRepositoryFailAnswer(this.message, exc, this.repository, this.repoService));
        this.presenter = new CloneRepositoryPresenter(this.repositoryPreferences, this.view, this.repoFailServiceCaller, this.ouServiceCaller, this.placeManager);
        this.presenter.init();
        this.presenter.handleCloneClick();
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).errorCloneRepositoryFail((Throwable)this.throwableArgument.capture());
        Assert.assertEquals((Object)exc, (Object)this.throwableArgument.getValue());
        this.componentsLocked();
        this.componentsUnlocked();
        this.verifyRepoCloned(false);
    }

    @Test
    public void testGitUrlValidation() {
        Mockito.when((Object)this.view.isGitUrlEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)"a b c");
        this.presenter.handleCloneClick();
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)":");
        this.presenter.handleCloneClick();
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)"|");
        this.presenter.handleCloneClick();
        ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).showUrlHelpInvalidFormatMessage();
        this.componentsNotAffected();
        this.verifyRepoCloned(false);
    }

    @Test
    @Ignore(value="See comments above")
    public void testGitUrlValidationSpecial() {
        Mockito.when((Object)this.view.isGitUrlEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)"abc");
        this.presenter.handleCloneClick();
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).showUrlHelpInvalidFormatMessage();
        this.componentsNotAffected();
        this.verifyRepoCloned(false);
    }

    @Test
    public void testCloneNoGroup() {
        Mockito.when((Object)this.repositoryPreferences.isOUMandatory()).thenReturn((Object)true);
        Mockito.when((Object)this.view.isGitUrlEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)REPO_URL);
        Mockito.when((Object)this.view.getName()).thenReturn((Object)REPO_NAME);
        Mockito.when((Object)this.view.getSelectedOrganizationalUnit()).thenReturn((Object)"");
        this.presenter = new CloneRepositoryPresenter(this.repositoryPreferences, this.view, this.repoServiceCaller, this.ouServiceCaller, this.placeManager);
        this.presenter.handleCloneClick();
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setOrganizationalUnitGroupType(ValidationState.ERROR);
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).showOrganizationalUnitHelpMandatoryMessage();
        this.verifyRepoCloned(false);
    }

    @Test
    public void testCloneNoUrl() {
        Mockito.when((Object)this.repositoryPreferences.isOUMandatory()).thenReturn((Object)true);
        Mockito.when((Object)this.view.isGitUrlEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getName()).thenReturn((Object)REPO_NAME);
        Mockito.when((Object)this.view.getSelectedOrganizationalUnit()).thenReturn((Object)ORG_UNIT_ONE);
        this.presenter = new CloneRepositoryPresenter(this.repositoryPreferences, this.view, this.repoServiceCaller, this.ouServiceCaller, this.placeManager);
        this.presenter.handleCloneClick();
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setUrlGroupType(ValidationState.ERROR);
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).showUrlHelpMandatoryMessage();
        this.verifyRepoCloned(false);
    }

    @Test
    public void testCancelButton() {
        this.presenter.handleCancelClick();
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testCreateOUEvent() {
        OrganizationalUnitImpl ou = new OrganizationalUnitImpl("ou1", "ou");
        this.presenter.onCreateOrganizationalUnit(new AfterCreateOrganizationalUnitEvent((OrganizationalUnit)ou));
        ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addOrganizationalUnit((OrganizationalUnit)ou);
    }

    @Test
    public void testDeleteOUEvent() {
        OrganizationalUnitImpl ou = new OrganizationalUnitImpl("ou1", "ou");
        this.presenter.onDeleteOrganizationalUnit(new AfterDeleteOrganizationalUnitEvent((OrganizationalUnit)ou));
        ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).deleteOrganizationalUnit((OrganizationalUnit)ou);
    }

    @Test
    public void testResetWhenShown() {
        this.presenter.showForm();
        ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void testCloneManagedRepository() {
        Mockito.when((Object)this.view.isGitUrlEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.repositoryPreferences.isOUMandatory()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)REPO_URL);
        Mockito.when((Object)this.view.getName()).thenReturn((Object)REPO_NAME);
        this.presenter.handleCloneClick();
        this.verifyRepoCloned(true);
        ((RepositoryService)Mockito.verify((Object)this.repoService, (VerificationMode)Mockito.times((int)1))).createRepository((OrganizationalUnit)Matchers.any(OrganizationalUnit.class), Mockito.anyString(), Mockito.anyString(), (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.capture());
        RepositoryEnvironmentConfigurations configurations = (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.getValue();
        Assert.assertEquals((Object)USERNAME, (Object)configurations.getUserName());
        Assert.assertEquals((Object)PASSWORD, (Object)configurations.getPassword());
        Assert.assertEquals((Object)REPO_URL, (Object)configurations.getOrigin());
    }

    @Test
    public void testCloneNotManagedRepository() {
        Mockito.when((Object)this.view.isGitUrlEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.repositoryPreferences.isOUMandatory()).thenReturn((Object)false);
        Mockito.when((Object)this.view.getGitUrl()).thenReturn((Object)REPO_URL);
        Mockito.when((Object)this.view.getName()).thenReturn((Object)REPO_NAME);
        this.presenter.handleCloneClick();
        this.verifyRepoCloned(true);
        ((RepositoryService)Mockito.verify((Object)this.repoService, (VerificationMode)Mockito.times((int)1))).createRepository((OrganizationalUnit)Matchers.any(OrganizationalUnit.class), Mockito.anyString(), Mockito.anyString(), (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.capture());
        RepositoryEnvironmentConfigurations configurations = (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsArgumentCaptor.getValue();
        Assert.assertEquals((Object)USERNAME, (Object)configurations.getUserName());
        Assert.assertEquals((Object)PASSWORD, (Object)configurations.getPassword());
        Assert.assertEquals((Object)REPO_URL, (Object)configurations.getOrigin());
    }

    private void componentsNotAffected() {
        ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setCloneEnabled(Matchers.anyBoolean());
        ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setGitUrlEnabled(Matchers.anyBoolean());
        ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setNameEnabled(Matchers.anyBoolean());
        ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setOrganizationalUnitEnabled(Matchers.anyBoolean());
        ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setUsernameEnabled(Matchers.anyBoolean());
        ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setPasswordEnabled(Matchers.anyBoolean());
        ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showBusyPopupMessage();
        ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).closeBusyPopup();
    }

    private void componentsLocked() {
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).showBusyPopupMessage();
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setCloneEnabled(false);
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setGitUrlEnabled(false);
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setNameEnabled(false);
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setOrganizationalUnitEnabled(false);
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setUsernameEnabled(false);
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setPasswordEnabled(false);
    }

    private void componentsUnlocked() {
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).closeBusyPopup();
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setCloneEnabled(true);
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setGitUrlEnabled(true);
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setNameEnabled(true);
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setOrganizationalUnitEnabled(true);
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setUsernameEnabled(true);
        ((CloneRepositoryView)Mockito.verify((Object)this.view)).setPasswordEnabled(true);
    }

    private void verifyRepoCloned(boolean cloned) {
        if (cloned) {
            ((CloneRepositoryView)Mockito.verify((Object)this.view)).alertRepositoryCloned();
            ((CloneRepositoryView)Mockito.verify((Object)this.view)).hide();
        } else {
            ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).alertRepositoryCloned();
            ((CloneRepositoryView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
        }
    }
}

